/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.web;

import java.util.HashMap;
import java.util.Map;

public class MimeHelper {
    public static final String MIMETYPE_RTF = "application/rtf";
    public static final String RTF_EXTENSION = ".rtf";
    public static final String MIMETYPE_MS_WORD = "application/msword";
    public static final String MS_WORD_EXTENSION = ".doc";
    public static final String MIMETYPE_PDF = "application/pdf";
    public static final String PDF_EXTENSION = ".pdf";
    public static final String MIMETYPE_MS_EXCEL = "application/vnd.ms-excel";
    public static final String MS_EXCEL_EXTENSION = ".xls";
    public static final String MIMETYPE_MS_PPT = "application/vnd.ms-powerpoint";
    public static final String MS_PPT_EXTENSION = ".ppt";
    public static final String MIMETYPE_MS_PROJECT = "application/vnd.ms-project";
    public static final String MS_PROJECT_EXTENSION = ".mpp";
    public static final String MIMETYPE_ZIP = "application/zip";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String MIMETYPE_MP3 = "audio/mpeg";
    public static final String MP3_EXTENSION = ".mp3";
    public static final String MIMETYPE_WAV = "audio/x-wav";
    public static final String WAV_EXTENSION = ".wav";
    public static final String MIMETYPE_BMP = "image/bmp";
    public static final String BMP_EXTENSION = ".bmp";
    public static final String MIMETYPE_GIF = "image/gif";
    public static final String GIF_EXTENSION = ".gif";
    public static final String MIMETYPE_JPEG = "image/jpeg";
    public static final String JPEG_EXTENSION_1 = ".jpg";
    public static final String JPEG_EXTENSION_2 = ".jpe";
    public static final String JPEG_EXTENSION_3 = ".jpeg";
    public static final String MIMETYPE_PNG = "image/png";
    public static final String PNG_EXTENSION = ".png";
    public static final String MIMETYPE_SVG = "image/svg+xml";
    public static final String SVG_EXTENSION = ".svg";
    public static final String MIMETYPE_TIFF = "image/tiff";
    public static final String TIFF_EXTENSION_1 = ".tif";
    public static final String TIFF_EXTENSION_2 = ".tiff";
    public static final String MIMETYPE_CSV = "text/csv";
    public static final String CSV_EXTENSION = ".csv";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String HTML_EXTENSION_1 = ".html";
    public static final String HTML_EXTENSION_2 = ".htm";
    public static final String MIMETYPE_TEXT = "text/plain";
    public static final String TEXT_EXTENSION = ".txt";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String MIMETYPE_MPG = "video/mpeg";
    public static final String MPG_EXTENSION_1 = ".mpg";
    public static final String MPG_EXTENSION_2 = ".mpe";
    public static final String MPG_EXTENSION_3 = ".mpeg";
    public static final String MIMETYPE_AVI = "video/x-msvideo";
    public static final String AVI_EXTENSION = ".avi";
    public static final String MIMETYPE_XACTION = "text/xaction+xml";
    public static final String XACTION_EXTENSION = ".xaction";
    public static final String MIMETYPE_CSS = "text/css";
    public static final String CSS_EXTENSION = ".css";
    public static final String MIMETYPE_JS = "text/javascript";
    public static final String JS_EXTENSION = ".js";
    public static final String MIMETYPE_XML = "text/xml";
    public static final String XML_EXTENSION = ".xml";
    public static final String MIMETYPE_FLASH = "application/x-shockwave-flash";
    public static final String FLASH_EXTENSION = ".swf";
    public static final String MIMETYPE_MS_EXCEL_2007 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String MS_EXCEL_2007_EXTENSION = ".xlsx";
    public static final String MIMETYPE_EMAIL_MSG = "mime-message/text/html";
    public static final String EMAIL_MSG_EXTENSION = ".eml";
    private static final String UTF_CHARACTER_ENCODING = "UTF-8";
    private static final Map<String, String> mimes = new HashMap<String, String>();
    private static final Map<String, String> extensions = new HashMap<String, String>();
    private static final Map<String, String> defaultCharset = new HashMap<String, String>();

    public static String getExtension(String mimeType) {
        return mimes.get(mimeType);
    }

    public static String getExtension(String mimeType, String defaultExtension) {
        String extension = MimeHelper.getExtension(mimeType);
        return extension == null ? defaultExtension : extension;
    }

    public static String getMimeTypeFromExtension(String extension) {
        return extensions.get(extension.toLowerCase());
    }

    public static String getMimeTypeFromFileName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return extensions.get(fileName.substring(index));
    }

    public static String getDefaultCharset(String mimeType) {
        return defaultCharset.get(mimeType);
    }

    static {
        mimes.put(MIMETYPE_RTF, RTF_EXTENSION);
        mimes.put(MIMETYPE_MS_WORD, MS_WORD_EXTENSION);
        mimes.put(MIMETYPE_PDF, PDF_EXTENSION);
        mimes.put(MIMETYPE_MS_EXCEL, MS_EXCEL_EXTENSION);
        mimes.put(MIMETYPE_MS_PPT, MS_PPT_EXTENSION);
        mimes.put(MIMETYPE_MS_PROJECT, MS_PROJECT_EXTENSION);
        mimes.put(MIMETYPE_ZIP, ZIP_EXTENSION);
        mimes.put(MIMETYPE_MP3, MP3_EXTENSION);
        mimes.put(MIMETYPE_WAV, WAV_EXTENSION);
        mimes.put(MIMETYPE_BMP, BMP_EXTENSION);
        mimes.put(MIMETYPE_GIF, GIF_EXTENSION);
        mimes.put(MIMETYPE_JPEG, JPEG_EXTENSION_1);
        mimes.put(MIMETYPE_PNG, PNG_EXTENSION);
        mimes.put(MIMETYPE_SVG, SVG_EXTENSION);
        mimes.put(MIMETYPE_TIFF, TIFF_EXTENSION_1);
        mimes.put(MIMETYPE_CSV, CSV_EXTENSION);
        mimes.put(MIMETYPE_HTML, HTML_EXTENSION_1);
        mimes.put(MIMETYPE_TEXT, TEXT_EXTENSION);
        mimes.put(MIMETYPE_MPG, MPG_EXTENSION_1);
        mimes.put(MIMETYPE_AVI, AVI_EXTENSION);
        mimes.put(MIMETYPE_XACTION, XACTION_EXTENSION);
        mimes.put(MIMETYPE_CSS, CSS_EXTENSION);
        mimes.put(MIMETYPE_JS, JS_EXTENSION);
        mimes.put(MIMETYPE_XML, XML_EXTENSION);
        mimes.put(MIMETYPE_FLASH, FLASH_EXTENSION);
        mimes.put(MIMETYPE_MS_EXCEL_2007, MS_EXCEL_2007_EXTENSION);
        mimes.put(MIMETYPE_EMAIL_MSG, EMAIL_MSG_EXTENSION);
        extensions.put(RTF_EXTENSION, MIMETYPE_RTF);
        extensions.put(MS_WORD_EXTENSION, MIMETYPE_MS_WORD);
        extensions.put(PDF_EXTENSION, MIMETYPE_PDF);
        extensions.put(MS_EXCEL_EXTENSION, MIMETYPE_MS_EXCEL);
        extensions.put(MS_PPT_EXTENSION, MIMETYPE_MS_PPT);
        extensions.put(MS_PROJECT_EXTENSION, MIMETYPE_MS_PROJECT);
        extensions.put(ZIP_EXTENSION, MIMETYPE_ZIP);
        extensions.put(MP3_EXTENSION, MIMETYPE_MP3);
        extensions.put(WAV_EXTENSION, MIMETYPE_WAV);
        extensions.put(BMP_EXTENSION, MIMETYPE_BMP);
        extensions.put(GIF_EXTENSION, MIMETYPE_GIF);
        extensions.put(JPEG_EXTENSION_1, MIMETYPE_JPEG);
        extensions.put(JPEG_EXTENSION_2, MIMETYPE_JPEG);
        extensions.put(JPEG_EXTENSION_3, MIMETYPE_JPEG);
        extensions.put(PNG_EXTENSION, MIMETYPE_PNG);
        extensions.put(SVG_EXTENSION, MIMETYPE_SVG);
        extensions.put(TIFF_EXTENSION_1, MIMETYPE_TIFF);
        extensions.put(TIFF_EXTENSION_2, MIMETYPE_TIFF);
        extensions.put(CSV_EXTENSION, MIMETYPE_CSV);
        extensions.put(HTML_EXTENSION_1, MIMETYPE_HTML);
        extensions.put(HTML_EXTENSION_2, MIMETYPE_HTML);
        extensions.put(TEXT_EXTENSION, MIMETYPE_TEXT);
        extensions.put(MPG_EXTENSION_1, MIMETYPE_MPG);
        extensions.put(MPG_EXTENSION_2, MIMETYPE_MPG);
        extensions.put(MPG_EXTENSION_3, MIMETYPE_MPG);
        extensions.put(AVI_EXTENSION, MIMETYPE_AVI);
        extensions.put(XACTION_EXTENSION, MIMETYPE_XACTION);
        extensions.put(CSS_EXTENSION, MIMETYPE_CSS);
        extensions.put(JS_EXTENSION, MIMETYPE_JS);
        extensions.put(XML_EXTENSION, MIMETYPE_XML);
        extensions.put(FLASH_EXTENSION, MIMETYPE_FLASH);
        extensions.put(MS_EXCEL_2007_EXTENSION, MIMETYPE_MS_EXCEL_2007);
        extensions.put(PROPERTIES_EXTENSION, MIMETYPE_TEXT);
        extensions.put(EMAIL_MSG_EXTENSION, MIMETYPE_EMAIL_MSG);
        defaultCharset.put(MIMETYPE_HTML, UTF_CHARACTER_ENCODING);
        defaultCharset.put(MIMETYPE_TEXT, UTF_CHARACTER_ENCODING);
    }
}

