/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.Messages;

public class LocaleHelper {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final ThreadLocal<Locale> threadLocalesBase = new ThreadLocal();
    private static final ThreadLocal<Locale> threadLocalesOverride = new ThreadLocal();
    public static final int FORMAT_SHORT = 3;
    public static final int FORMAT_MEDIUM = 2;
    public static final int FORMAT_LONG = 1;
    public static final int FORMAT_FULL = 0;
    public static final int FORMAT_IGNORE = -1;
    private static Locale defaultLocale;
    public static final String UTF_8 = "UTF-8";
    private static String encoding;
    public static final String LEFT_TO_RIGHT = "LTR";
    private static String textDirection;
    public static final String USER_LOCALE_PARAM = "user_locale";

    public static Locale parseLocale(String locale) {
        if (StringUtils.isEmpty((String)locale)) {
            return null;
        }
        if (locale.contains("_")) {
            String[] parts = locale.split("_");
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(locale);
    }

    public static void setDefaultLocale(Locale newLocale) {
        if (newLocale == null) {
            newLocale = Locale.getDefault();
        }
        if (newLocale == null) {
            newLocale = DEFAULT_LOCALE;
        }
        defaultLocale = newLocale;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    @Deprecated
    public static void parseAndSetLocaleOverride(String localeOverride) {
        LocaleHelper.setThreadLocaleOverride(LocaleHelper.parseLocale(localeOverride));
    }

    @Deprecated
    public static void setLocaleOverride(Locale newLocale) {
        LocaleHelper.setThreadLocaleOverride(newLocale);
    }

    @Deprecated
    public static Locale getLocaleOverride() {
        return LocaleHelper.getThreadLocaleOverride();
    }

    public static void setThreadLocaleOverride(Locale newLocale) {
        if (newLocale == null) {
            threadLocalesOverride.remove();
        } else {
            threadLocalesOverride.set(newLocale);
        }
    }

    public static Locale getThreadLocaleOverride() {
        return threadLocalesOverride.get();
    }

    @Deprecated
    public static void setLocale(Locale newLocale) {
        LocaleHelper.setThreadLocaleBase(newLocale);
    }

    public static void setThreadLocaleBase(Locale newLocale) {
        if (newLocale == null) {
            threadLocalesBase.remove();
        } else {
            threadLocalesBase.set(newLocale);
        }
    }

    public static Locale getThreadLocaleBase() {
        return threadLocalesBase.get();
    }

    public static Locale getLocale() {
        Locale locale = LocaleHelper.getThreadLocaleOverride();
        if (locale != null) {
            return locale;
        }
        locale = LocaleHelper.getThreadLocaleBase();
        if (locale != null) {
            return locale;
        }
        return LocaleHelper.getDefaultLocale();
    }

    public static void setSessionLocaleOverride(Locale locale) {
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (session != null) {
            String localeCode = locale != null ? locale.toString() : null;
            session.setAttributeLocaleOverride(localeCode);
        }
    }

    public static void setSystemEncoding(String encoding) {
        Charset defaultCharset;
        Charset platformCharset = Charset.forName(encoding);
        if (platformCharset.compareTo(defaultCharset = Charset.defaultCharset()) != 0) {
            Logger.warn(LocaleHelper.class.getName(), Messages.getInstance().getString("LocaleHelper.WARN_CHARSETS_DONT_MATCH", platformCharset.name(), defaultCharset.name()));
        }
        LocaleHelper.encoding = encoding;
    }

    public static void setTextDirection(String textDirection) {
        LocaleHelper.textDirection = textDirection;
    }

    public static String getSystemEncoding() {
        return encoding;
    }

    public static String getTextDirection() {
        return textDirection;
    }

    public static String convertISOStringToSystemDefaultEncoding(String isoString) {
        return LocaleHelper.convertEncodedStringToSystemDefaultEncoding("ISO-8859-1", isoString);
    }

    public static String convertEncodedStringToSystemDefaultEncoding(String fromEncoding, String encodedStr) {
        return LocaleHelper.convertStringEncoding(encodedStr, fromEncoding, LocaleHelper.getSystemEncoding());
    }

    public static String isoToUtf8(String isoString) {
        return LocaleHelper.convertStringEncoding(isoString, "ISO-8859-1", UTF_8);
    }

    public static String utf8ToIso(String utf8String) {
        return LocaleHelper.convertStringEncoding(utf8String, UTF_8, "ISO-8859-1");
    }

    public static String convertStringEncoding(String sourceString, String sourceEncoding, String targetEncoding) {
        String targetString = null;
        if (null != sourceString && !sourceString.equals("")) {
            try {
                byte[] stringBytesSource = sourceString.getBytes(sourceEncoding);
                targetString = new String(stringBytesSource, targetEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            targetString = sourceString;
        }
        return targetString;
    }

    public static boolean isAscii(String aString) {
        return LocaleHelper.isWithinCharset(aString, "US-ASCII");
    }

    public static boolean isLatin1(String aString) {
        return LocaleHelper.isWithinCharset(aString, "ISO-8859-1");
    }

    public static boolean isWithinCharset(String aString, String charsetTarget) {
        byte[] stringBytes = aString.getBytes();
        CharsetDecoder decoder = Charset.forName(charsetTarget).newDecoder();
        try {
            decoder.decode(ByteBuffer.wrap(stringBytes));
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    public static DateFormat getDateFormat(int dateFormat, int timeFormat) {
        if (dateFormat != -1 && timeFormat != -1) {
            return DateFormat.getDateTimeInstance(dateFormat, timeFormat, LocaleHelper.getLocale());
        }
        if (dateFormat != -1) {
            return DateFormat.getDateInstance(dateFormat, LocaleHelper.getLocale());
        }
        if (timeFormat != -1) {
            return DateFormat.getTimeInstance(timeFormat, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getShortDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(3, 3, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(3, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(3, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getMediumDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(2, 2, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(2, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(2, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getLongDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(1, 1, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(1, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(1, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getFullDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(0, 0, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(0, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(0, LocaleHelper.getLocale());
        }
        return null;
    }

    public static NumberFormat getNumberFormat() {
        return NumberFormat.getNumberInstance(LocaleHelper.getLocale());
    }

    public static NumberFormat getCurrencyFormat() {
        return NumberFormat.getCurrencyInstance(LocaleHelper.getLocale());
    }

    public static String getClosestLocale(String locale, String[] locales) {
        if (locales == null || locales.length == 0) {
            return locale;
        }
        if (locale == null || locale.length() == 0) {
            return locales[0];
        }
        String localeLanguage = locale.substring(0, 2);
        String localeCountry = locale.length() > 4 ? locale.substring(0, 5) : localeLanguage;
        int looseMatch = -1;
        int closeMatch = -1;
        int exactMatch = -1;
        for (int idx = 0; idx < locales.length; ++idx) {
            if (locales[idx].equals(locale)) {
                exactMatch = idx;
                break;
            }
            if (locales[idx].length() > 1 && locales[idx].substring(0, 2).equals(localeLanguage)) {
                looseMatch = idx;
                continue;
            }
            if (locales[idx].length() <= 4 || !locales[idx].substring(0, 5).equals(localeCountry)) continue;
            closeMatch = idx;
        }
        if (exactMatch == -1) {
            locale = closeMatch != -1 ? locales[closeMatch] : (looseMatch != -1 ? locales[looseMatch] : locales[0]);
        }
        return locale;
    }

    static {
        encoding = UTF_8;
        textDirection = LEFT_TO_RIGHT;
        LocaleHelper.setDefaultLocale(null);
    }
}

