/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.messages.Messages;

public class FileHelper {
    private static final Log logger = LogFactory.getLog(FileHelper.class);

    public static String getStringFromInputStream(InputStream is) {
        try {
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            logger.error((Object)Messages.getInstance().getErrorString("FileUtil.ERROR_0001_ERROR", e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStringFromFile(File f) {
        String string;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(f);
            string = FileHelper.getStringFromInputStream(fin);
        }
        catch (Exception e) {
            try {
                logger.error((Object)Messages.getInstance().getErrorString("FileUtil.ERROR_0001_ERROR", e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileHelper.closeInputStream(fin);
                throw throwable;
            }
            FileHelper.closeInputStream(fin);
            return null;
        }
        FileHelper.closeInputStream(fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] bytes;
            byte[] byArray = bytes = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static void closeInputStream(InputStream strm) {
        if (null != strm) {
            try {
                strm.close();
            }
            catch (IOException e) {
                logger.warn((Object)Messages.getInstance().getString("FileHelper.WARN_ERROR_CLOSING_STREAM"), (Throwable)e);
            }
        }
    }

    public static void closeReader(Reader rdr) {
        if (null != rdr) {
            try {
                rdr.close();
            }
            catch (IOException e) {
                logger.warn((Object)Messages.getInstance().getString("FileHelper.WARN_ERROR_CLOSING_READER"), (Throwable)e);
            }
        }
    }
}

