/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoObjectRegistration;
import org.pentaho.platform.engine.core.system.objfac.RuntimeObjectFactory;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringPentahoObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIRuntimeObjectFactory
extends RuntimeObjectFactory {
    public static final String REFERENCE_CLASS = "reference_class";
    private BundleContext bundleContext;
    private AtomicBoolean osgiInitialized = new AtomicBoolean(false);
    private List<OSGIPentahoObjectRegistration> deferredRegistrations = new ArrayList<OSGIPentahoObjectRegistration>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Iterator<OSGIPentahoObjectRegistration> iterator = this.deferredRegistrations.iterator();
        List<OSGIPentahoObjectRegistration> list = this.deferredRegistrations;
        synchronized (list) {
            while (iterator.hasNext()) {
                OSGIPentahoObjectRegistration osgiPentahoObjectRegistration = iterator.next();
                RuntimeObjectFactory.ObjectRegistration deferredRegistration = osgiPentahoObjectRegistration.iPentahoObjectRegistration;
                Class[] classes = deferredRegistration.getPublishedClasses().toArray(new Class[deferredRegistration.getPublishedClasses().size()]);
                this.registerReference(deferredRegistration.getReference(), osgiPentahoObjectRegistration, classes);
                iterator.remove();
            }
        }
        this.osgiInitialized.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IPentahoObjectRegistration registerReference(final IPentahoObjectReference<?> reference, OSGIPentahoObjectRegistration existingRegistration, Class<?> ... classes) {
        if (this.bundleContext == null) {
            RuntimeObjectFactory.ObjectRegistration runtimeRegistration = (RuntimeObjectFactory.ObjectRegistration)super.registerReference(reference, classes);
            OSGIPentahoObjectRegistration osgiPentahoObjectRegistration = new OSGIPentahoObjectRegistration(runtimeRegistration);
            List<OSGIPentahoObjectRegistration> list = this.deferredRegistrations;
            synchronized (list) {
                this.deferredRegistrations.add(osgiPentahoObjectRegistration);
            }
            return osgiPentahoObjectRegistration;
        }
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(reference.getAttributes());
        ArrayList registrations = new ArrayList();
        for (Class<?> aClass : classes) {
            try {
                ServiceRegistration serviceRegistration;
                if (reference instanceof SingletonPentahoObjectReference || reference instanceof SpringPentahoObjectReference && hashtable.get("scope").equals("singleton")) {
                    ServiceFactory<Object> factory = new ServiceFactory<Object>(){

                        public Object getService(Bundle bundle, ServiceRegistration<Object> serviceRegistration) {
                            return reference.getObject();
                        }

                        public void ungetService(Bundle bundle, ServiceRegistration<Object> serviceRegistration, Object o) {
                        }
                    };
                    if (hashtable.containsKey("priority")) {
                        hashtable.put("service.ranking", hashtable.get("priority"));
                    }
                    serviceRegistration = this.bundleContext.registerService(aClass.getName(), (Object)factory, hashtable);
                    registrations.add(serviceRegistration);
                    continue;
                }
                Hashtable<String, String> referenceHashTable = new Hashtable<String, String>(hashtable);
                referenceHashTable.put(REFERENCE_CLASS, aClass.getName());
                serviceRegistration = this.bundleContext.registerService(IPentahoObjectReference.class.getName(), reference, referenceHashTable);
                registrations.add(serviceRegistration);
            }
            catch (ClassCastException e) {
                this.logger.error("Error Retriving object from OSGI, Class is not as expected", (Throwable)e);
            }
        }
        if (existingRegistration != null) {
            existingRegistration.setRegistrations(registrations);
            return existingRegistration;
        }
        return new OSGIPentahoObjectRegistration(registrations);
    }

    @Override
    public <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference, Class<?> ... classes) {
        return this.registerReference((IPentahoObjectReference<?>)reference, (OSGIPentahoObjectRegistration)null, classes);
    }

    @Override
    public boolean objectDefined(Class<?> clazz) {
        if (this.bundleContext == null || !this.osgiInitialized.get()) {
            return super.objectDefined(clazz);
        }
        try {
            Collection serviceReferences = this.bundleContext.getServiceReferences(IPentahoObjectReference.class, "(reference_class=" + clazz.getName() + ")");
            if (serviceReferences != null && serviceReferences.size() > 0) {
                return true;
            }
        }
        catch (IllegalStateException ise) {
            return false;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Error finding reference in OSGI");
        }
        return this.bundleContext.getServiceReference(clazz) != null;
    }

    @Override
    protected <T> List<IPentahoObjectReference<?>> getReferencesByQuery(Class<T> type, Map<String, String> query) {
        if (this.bundleContext == null || !this.osgiInitialized.get()) {
            return super.getReferencesByQuery(type, query);
        }
        return Collections.emptyList();
    }

    private class OSGIPentahoObjectRegistration
    implements IPentahoObjectRegistration {
        private List<ServiceRegistration<?>> registrations = new ArrayList();
        private RuntimeObjectFactory.ObjectRegistration iPentahoObjectRegistration;

        public OSGIPentahoObjectRegistration(List<ServiceRegistration<?>> registrations) {
            this.registrations.addAll(registrations);
        }

        public OSGIPentahoObjectRegistration(RuntimeObjectFactory.ObjectRegistration iPentahoObjectRegistration) {
            this.iPentahoObjectRegistration = iPentahoObjectRegistration;
        }

        public void remove() {
            if (this.iPentahoObjectRegistration != null) {
                this.iPentahoObjectRegistration.remove();
            }
            for (ServiceRegistration<?> registration : this.registrations) {
                try {
                    registration.unregister();
                }
                catch (IllegalStateException e) {
                    OSGIRuntimeObjectFactory.this.logger.debug("Error on Unregistering the service, it seems already be unregistered", (Throwable)e);
                }
            }
        }

        public void setRegistrations(List<ServiceRegistration<?>> registrations) {
            this.registrations = registrations;
            this.iPentahoObjectRegistration = null;
        }
    }
}

