/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.osgi.framework.BundleContext;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoObjectRegistration;
import org.pentaho.platform.api.engine.IPentahoPublisher;
import org.pentaho.platform.api.engine.IPentahoRegistrableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.IServerStatusProvider;
import org.pentaho.platform.api.engine.ISessionStartupAction;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PentahoSystemException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.SimpleMapCacheManager;
import org.pentaho.platform.engine.core.system.StandaloneApplicationContext;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.core.system.objfac.AggregateObjectFactory;
import org.pentaho.platform.engine.core.system.objfac.OSGIRuntimeObjectFactory;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class PentahoSystem {
    public static final boolean debug = true;
    public static final boolean trace = false;
    public static final boolean ignored = false;
    private static final String securityContextHolderStrategy = "MODE_INHERITABLETHREADLOCAL";
    public static final String JAVA_SYSTEM_PROPERTIES = "java-system-properties";
    public static int loggingLevel = 5;
    private static IApplicationContext applicationContext;
    protected static final String CONTENT_REPOSITORY = "IContentRepository";
    protected static final String RUNTIME_REPOSITORY = "IRuntimeRepository";
    private static final String SOLUTION_REPOSITORY = "IUnifiedRepository";
    protected static final String SOLUTION_ENGINE = "ISolutionEngine";
    public static final String BACKGROUND_EXECUTION = "IBackgroundExecution";
    public static final String CONDITIONAL_EXECUTION = "IConditionalExecution";
    public static String DEFAULT_CONDITIONAL_EXECUTION_PROVIDER;
    public static String DEFAULT_MESSAGE_FORMATTER;
    public static final String SCHEDULER = "IScheduler";
    public static final String MESSAGE_FORMATTER = "IMessageFormatter";
    public static final String SCOPE_GLOBAL = "global";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_LOCAL = "local";
    public static final String SCOPE = "scope";
    public static final String PENTAHO_SESSION_KEY = "pentaho-session-context";
    public static final String PENTAHO_AUTH_KEY = "pentaho-auth-context";
    public static final String PENTAHO_MDC_KEY = "pentaho-mdc-context";
    public static final String WAIT_SECONDS = "waitSeconds";
    public static final String CORS_REQUESTS_ALLOWED = "system.cors-requests-allowed";
    public static final String CORS_REQUESTS_ALLOWED_ORIGINS = "system.cors-requests-allowed-domains";
    private static Map globalAttributes;
    private static SimpleParameterProvider globalParameters;
    private static ISystemSettings systemSettingsService;
    private static List<IPentahoPublisher> administrationPlugins;
    private static List<IPentahoSystemListener> listeners;
    private static List<ISessionStartupAction> sessionStartupActions;
    private static AggregateObjectFactory aggObjectFactory;
    private static OSGIRuntimeObjectFactory runtimeObjectFactory;
    private static final Map initializationFailureDetailsMap;
    private static final List<String> RequiredObjects;
    private static final List<String> KnownOptionalObjects;
    private static final List<String> IgnoredObjects;
    public static final int SYSTEM_NOT_INITIALIZED = -1;
    public static final int SYSTEM_INITIALIZED_OK = 0;
    public static final int SYSTEM_LISTENERS_FAILED;
    public static final int SYSTEM_OBJECTS_FAILED;
    public static final int SYSTEM_PUBLISHERS_FAILED;
    public static final int SYSTEM_AUDIT_FAILED;
    public static final int SYSTEM_PENTAHOXML_FAILED;
    public static final int SYSTEM_SETTINGS_FAILED;
    public static final int SYSTEM_OTHER_FAILED;
    private static int initializedStatus;
    private static final String USERSETTING_SERVICE = "IUserSettingService";
    private static final String ACL_VOTER = "IAclVoter";
    private static final String CACHE_MANAGER = "ICacheManager";
    private static final List ACLFileExtensionList;
    private static final List UnmodifiableACLFileExtensionList;
    private static final List DownloadRolesList;
    private static final List UnmodifiableDownloadRolesList;
    private static final List logoutListeners;
    private static final IServerStatusProvider serverStatusProvider;
    public static final String HIDE_USER_HOME_FOLDER_ON_CREATION_PROPERTY = "system.hideUserHomeFolderOnCreate";
    public static final String DEFAULT_FOLDER_WHEN_HOME_FOLDER_IS_HIDDEN_PROPERTY = "system.defaultFolderWhenHomeFolderIsHidden";

    private static void defaultObjectFactory() {
        runtimeObjectFactory = new OSGIRuntimeObjectFactory();
        aggObjectFactory.registerObjectFactory((IPentahoObjectFactory)runtimeObjectFactory);
    }

    public static void setBundleContext(BundleContext context) {
        runtimeObjectFactory.setBundleContext(context);
    }

    public static boolean init() {
        return PentahoSystem.init(new StandaloneApplicationContext(".", "."));
    }

    public static boolean init(IApplicationContext pApplicationContext) {
        return PentahoSystem.init(pApplicationContext, null);
    }

    public static boolean init(IApplicationContext pApplicationContext, Map listenerMap) {
        Logger.debug(PentahoSystem.class, "PentahoSystem init called");
        if (initializedStatus == 0) {
            try {
                throw new IllegalStateException("'Init' method was run twice without 'shutdown'");
            }
            catch (IllegalStateException e) {
                Logger.error(PentahoSystem.class, "PentahoSystem was already initialized when init() called again without a preceding shutdown(). This is likely in error", (Throwable)e);
            }
        }
        initializedStatus = 0;
        SecurityContextHolder.setStrategyName((String)securityContextHolderStrategy);
        globalAttributes = Collections.synchronizedMap(new HashMap());
        globalParameters = new SimpleParameterProvider(globalAttributes);
        applicationContext = pApplicationContext;
        Logger.debug(PentahoSystem.class, "Setting property path");
        System.setProperty("pentaho.solutionpath", "solution:");
        if (systemSettingsService != null) {
            Logger.debug(PentahoSystem.class, "Reading ACL list from pentaho.xml");
            String aclFiles = PentahoSystem.getSystemSetting("acl-files", "xaction,url");
            StringTokenizer st = new StringTokenizer(aclFiles, ",");
            while (st.hasMoreElements()) {
                String extn = st.nextToken();
                if (!extn.startsWith(".")) {
                    extn = "." + extn;
                }
                ACLFileExtensionList.add(extn);
            }
            Logger.debug(PentahoSystem.class, "Reading Download Roles from pentaho.xml");
            String downloadRoles = PentahoSystem.getSystemSetting("download-roles", "Administrator");
            st = new StringTokenizer(downloadRoles, ",");
            while (st.hasMoreElements()) {
                DownloadRolesList.add(st.nextToken());
            }
        }
        Logger.debug(PentahoSystem.class, "Set Java System Properties");
        PentahoSystem.setSystemProperties();
        Logger.debug(PentahoSystem.class, "Initialize XML Factories");
        PentahoSystem.initXMLFactories();
        Logger.debug(PentahoSystem.class, "Set Logging Level from pentaho.xml setting");
        loggingLevel = 5;
        if (systemSettingsService != null) {
            loggingLevel = Logger.getLogLevel(systemSettingsService.getSystemSetting("log-level", "ERROR"));
        }
        Logger.setLogLevel(loggingLevel);
        Logger.debug(PentahoSystem.class, "Register host name verifier");
        PentahoSystem.registerHostnameVerifier();
        assert (null != aggObjectFactory) : "aggObjectFactory must be non-null";
        try {
            Logger.debug(PentahoSystem.class, "Validating object factory");
            PentahoSystem.validateObjectFactory();
        }
        catch (PentahoSystemException e1) {
            throw new RuntimeException(e1);
        }
        try {
            Logger.debug(PentahoSystem.class, "Start System Listeners");
            PentahoSystem.notifySystemListenersOfStartup();
        }
        catch (PentahoSystemException e) {
            String msg = e.getLocalizedMessage();
            Logger.error(PentahoSystem.class.getName(), msg, (Throwable)e);
            initializedStatus |= SYSTEM_LISTENERS_FAILED;
            PentahoSystem.addInitializationFailureMessage(SYSTEM_LISTENERS_FAILED, msg);
            return false;
        }
        Logger.debug(PentahoSystem.class, "Global startup");
        PentahoSystem.globalStartup();
        Logger.debug(PentahoSystem.class, "PentahoSystem Init Complete");
        return true;
    }

    private static void notifySystemListenersOfStartup() throws PentahoSystemException {
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        try {
            PentahoSystem.runAsSystem(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PentahoSystem.notifySystemListenersOfStartup(PentahoSessionHolder.getSession());
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new PentahoSystemException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runAsSystem(Callable<T> callable) throws Exception {
        String name = StringUtils.defaultIfEmpty((String)PentahoSystem.get(String.class, "singleTenantAdminUserName", null), (String)"admin");
        IPentahoSession origSession = PentahoSessionHolder.getSession();
        SecurityContext originalContext = SecurityContextHolder.getContext();
        try {
            StandaloneSession session = new StandaloneSession(name);
            session.setAuthenticated(name);
            ISystemSettings settings = PentahoSystem.getSystemSettings();
            String roleName = settings != null ? settings.getSystemSetting("acl-voter/admin-role", "Admin") : "Admin";
            ArrayList<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>();
            roles.add(new SimpleGrantedAuthority(roleName));
            User user = new User(name, "", true, true, true, true, roles);
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)"", roles);
            PentahoSessionHolder.setSession(session);
            SecurityContextHolder.clearContext();
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            T t = callable.call();
            return t;
        }
        finally {
            IPentahoSession sessionToDestroy = PentahoSessionHolder.getSession();
            if (sessionToDestroy != null && sessionToDestroy != origSession) {
                try {
                    sessionToDestroy.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            PentahoSessionHolder.setSession(origSession);
            SecurityContextHolder.setContext((SecurityContext)originalContext);
        }
    }

    private static void notifySystemListenersOfStartup(final IPentahoSession session) throws PentahoSystemException {
        if (listeners != null && listeners.size() > 0) {
            for (final IPentahoSystemListener systemListener : listeners) {
                try {
                    PentahoSystem.runAsSystem(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            PentahoSystem.systemEntryPoint();
                            try {
                                Logger.debug(PentahoSystem.class, "System Listener Start: " + systemListener.getClass().getName());
                                if (!systemListener.startup(session)) {
                                    throw new PentahoSystemException(Messages.getInstance().getErrorString("PentahoSystem.ERROR_0014_STARTUP_FAILURE", systemListener.getClass().getName()));
                                }
                                Logger.debug(PentahoSystem.class, "System Listener Complete: " + systemListener.getClass().getName());
                            }
                            catch (Throwable e) {
                                throw new PentahoSystemException(Messages.getInstance().getErrorString("PentahoSystem.ERROR_0014_STARTUP_FAILURE", systemListener.getClass().getName()), e);
                            }
                            finally {
                                PentahoSystem.systemExitPoint();
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof PentahoSystemException) {
                        throw (PentahoSystemException)((Object)e);
                    }
                    throw new PentahoSystemException((Throwable)e);
                }
            }
        }
    }

    private static void initXMLFactories() {
        String xpathToXMLFactoryNodes;
        List nds;
        if (systemSettingsService != null && null != (nds = systemSettingsService.getSystemSettings(xpathToXMLFactoryNodes = "xml-factories/factory-impl")) && !nds.isEmpty()) {
            Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_XML_FACTORIES_LOCATION_CHANGED", JAVA_SYSTEM_PROPERTIES));
            for (Node nd : nds) {
                Node nameAttr = nd.selectSingleNode("@name");
                Node implAttr = nd.selectSingleNode("@implementation");
                if (null != nameAttr && null != implAttr) {
                    String name = nameAttr.getText();
                    String impl = implAttr.getText();
                    System.setProperty(name, impl);
                    continue;
                }
                Logger.error(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0025_LOAD_XML_FACTORY_PROPERTIES_FAILED", xpathToXMLFactoryNodes));
            }
        }
    }

    private static void setSystemProperties() {
        ISystemConfig systemConfig = PentahoSystem.get(ISystemConfig.class);
        if (systemConfig == null) {
            return;
        }
        IConfiguration configuration = systemConfig.getConfiguration(JAVA_SYSTEM_PROPERTIES);
        if (configuration != null) {
            try {
                Properties systemSettingsProperties = configuration.getProperties();
                for (String propName : systemSettingsProperties.stringPropertyNames()) {
                    System.setProperty(propName, systemSettingsProperties.getProperty(propName));
                }
            }
            catch (IOException e) {
                Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_SYSTEM_PROPERTIES_READ_FAIL", JAVA_SYSTEM_PROPERTIES));
            }
        }
    }

    public static boolean getInitializedOK() {
        return initializedStatus == 0;
    }

    public static int getInitializedStatus() {
        return initializedStatus;
    }

    private static List<String> getAdditionalInitializationFailureMessages(int failureBit) {
        List l = (List)initializationFailureDetailsMap.get(new Integer(failureBit));
        return l;
    }

    public static List<String> getInitializationFailureMessages() {
        List<String> l;
        ArrayList<String> rtn = new ArrayList<String>();
        if (PentahoSystem.hasFailed(SYSTEM_SETTINGS_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_SETTINGS_FAILED", "PENTAHO_SYS_CFG_PATH"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_SETTINGS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_PUBLISHERS_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_PUBLISHERS_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_PUBLISHERS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_OBJECTS_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_OBJECTS_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_OBJECTS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_AUDIT_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_AUDIT_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_AUDIT_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_LISTENERS_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_LISTENERS_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_LISTENERS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_PENTAHOXML_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_PENTAHOXML_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_PENTAHOXML_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_OTHER_FAILED)) {
            rtn.add(Messages.getInstance().getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_OTHER_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_OTHER_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        return rtn;
    }

    public static void addInitializationFailureMessage(int failureBit, String message) {
        String msg;
        Integer i = new Integer(failureBit);
        List<String> l = (List<String>)initializationFailureDetailsMap.get(i);
        if (l == null) {
            l = Collections.synchronizedList(new ArrayList());
            initializationFailureDetailsMap.put(i, l);
        }
        if (!l.contains(msg = "&nbsp;&nbsp;&nbsp;" + message)) {
            l.add(msg);
        }
    }

    private static final boolean hasFailed(int errorToCheck) {
        return (initializedStatus & errorToCheck) == errorToCheck;
    }

    public static IContentOutputHandler getOutputDestinationFromContentRef(String contentTag, IPentahoSession session) {
        int pos = contentTag.indexOf(58);
        if (pos == -1) {
            Logger.error(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0029_OUTPUT_HANDLER_NOT_SPECIFIED", contentTag));
            return null;
        }
        String handlerId = contentTag.substring(0, pos);
        String contentRef = contentTag.substring(pos + 1);
        IContentOutputHandler output = PentahoSystem.get(IContentOutputHandler.class, handlerId, session);
        if (output != null) {
            output.setHandlerId(handlerId);
            output.setSession(session);
            output.setContentRef(contentRef);
        }
        return output;
    }

    public static <T> T get(Class<T> interfaceClass) {
        return PentahoSystem.get(interfaceClass, null, PentahoSessionHolder.getSession());
    }

    public static <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) {
        try {
            if (!aggObjectFactory.objectDefined(interfaceClass)) {
                Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_OBJECT_NOT_CONFIGURED", interfaceClass.getSimpleName()));
                return null;
            }
            IPentahoSession curSession = session == null ? PentahoSessionHolder.getSession() : session;
            return aggObjectFactory.get(interfaceClass, curSession, properties);
        }
        catch (ObjectFactoryException e) {
            Logger.debug(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0026_COULD_NOT_RETRIEVE_CONFIGURED_OBJECT", interfaceClass.getSimpleName()), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> getAll(Class<T> interfaceClass) {
        return PentahoSystem.getAll(interfaceClass, PentahoSessionHolder.getSession(), null);
    }

    public static <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession session) {
        return PentahoSystem.getAll(interfaceClass, session, null);
    }

    public static <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession session, Map<String, String> props) {
        try {
            if (!aggObjectFactory.objectDefined(interfaceClass)) {
                Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_OBJECT_NOT_CONFIGURED", interfaceClass.getSimpleName()));
                return Collections.emptyList();
            }
            IPentahoSession curSession = session == null ? PentahoSessionHolder.getSession() : session;
            return aggObjectFactory.getAll(interfaceClass, curSession, props);
        }
        catch (ObjectFactoryException e) {
            Logger.debug(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0026_COULD_NOT_RETRIEVE_CONFIGURED_OBJECT", interfaceClass.getSimpleName()), (Throwable)e);
            return null;
        }
    }

    public static <T> T get(Class<T> interfaceClass, IPentahoSession session) {
        IPentahoSession curSession = session == null ? PentahoSessionHolder.getSession() : session;
        return PentahoSystem.get(interfaceClass, null, curSession);
    }

    public static <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) {
        try {
            IPentahoSession curSession;
            IPentahoSession iPentahoSession = curSession = session == null ? PentahoSessionHolder.getSession() : session;
            if (key == null) {
                return aggObjectFactory.get(interfaceClass, curSession);
            }
            if (!aggObjectFactory.objectDefined(key) && !aggObjectFactory.objectDefined(interfaceClass)) {
                Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_OBJECT_NOT_CONFIGURED", key));
                return null;
            }
            return aggObjectFactory.get(interfaceClass, key, curSession);
        }
        catch (ObjectFactoryException e) {
            Logger.debug(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0026_COULD_NOT_RETRIEVE_CONFIGURED_OBJECT", key), (Throwable)e);
            return null;
        }
    }

    public static <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession) {
        return PentahoSystem.getObjectReference(interfaceClass, curSession, null);
    }

    public static <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) {
        if (!aggObjectFactory.objectDefined(interfaceClass)) {
            Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_OBJECT_NOT_CONFIGURED", interfaceClass.getSimpleName()));
            return null;
        }
        curSession = curSession == null ? PentahoSessionHolder.getSession() : curSession;
        try {
            return aggObjectFactory.getObjectReference(interfaceClass, curSession, properties);
        }
        catch (ObjectFactoryException e) {
            Logger.debug(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0026_COULD_NOT_RETRIEVE_CONFIGURED_OBJECT", interfaceClass.getSimpleName()), (Throwable)e);
            return null;
        }
    }

    public static <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) {
        return PentahoSystem.getObjectReferences(interfaceClass, curSession, null);
    }

    public static <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) {
        if (!aggObjectFactory.objectDefined(interfaceClass)) {
            Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.WARN_OBJECT_NOT_CONFIGURED", interfaceClass.getSimpleName()));
            return Collections.emptyList();
        }
        curSession = curSession == null ? PentahoSessionHolder.getSession() : curSession;
        try {
            return aggObjectFactory.getObjectReferences(interfaceClass, curSession, properties);
        }
        catch (ObjectFactoryException e) {
            Logger.debug(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0026_COULD_NOT_RETRIEVE_CONFIGURED_OBJECT", interfaceClass.getSimpleName()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static String getSystemName() {
        return Messages.getInstance().getString("PentahoSystem.USER_SYSTEM_TITLE");
    }

    public static IParameterProvider getGlobalParameters() {
        return globalParameters;
    }

    public static void sessionStartup(IPentahoSession session) {
        PentahoSystem.sessionStartup(session, null);
    }

    public static void clearGlobals() {
        globalAttributes.clear();
    }

    public static Object putInGlobalAttributesMap(Object key, Object value) {
        return globalAttributes.put(key, value);
    }

    public static Object removeFromGlobalAttributesMap(Object key) {
        return globalAttributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sessionStartup(IPentahoSession session, IParameterProvider sessionParameters) {
        List<ISessionStartupAction> sessionStartupActions = PentahoSystem.getSessionStartupActionsForType(session.getClass().getName());
        if (sessionStartupActions == null) {
            return;
        }
        if (!session.isAuthenticated()) {
            return;
        }
        Boolean startupActionsFired = (Boolean)session.getAttribute("StartupActionsFired");
        if (startupActionsFired == null || !startupActionsFired.booleanValue()) {
            try {
                Logger.debug(PentahoSystem.class, "Process session startup actions");
                if (sessionStartupActions == null) return;
                for (ISessionStartupAction sessionStartupAction : sessionStartupActions) {
                    IOutputHandler outputHandler = null;
                    String instanceId = null;
                    ISolutionEngine solutionEngine = PentahoSystem.get(ISolutionEngine.class, session);
                    solutionEngine.setLoggingLevel(loggingLevel);
                    solutionEngine.init(session);
                    String baseUrl = "";
                    HashMap<String, IParameterProvider> parameterProviderMap = new HashMap<String, IParameterProvider>();
                    if (sessionParameters == null) {
                        sessionParameters = new PentahoSessionParameterProvider(session);
                    }
                    parameterProviderMap.put(SCOPE_SESSION, sessionParameters);
                    SimpleUrlFactory urlFactory = new SimpleUrlFactory(baseUrl);
                    ArrayList messages = new ArrayList();
                    IRuntimeContext context = null;
                    try {
                        context = solutionEngine.execute(sessionStartupAction.getActionPath(), "Session startup actions", false, true, instanceId, false, parameterProviderMap, outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
                        if (null == context) {
                            return;
                        }
                        if (context.getStatus() != 6) continue;
                        for (String attributeName : context.getOutputNames()) {
                            IActionParameter output = context.getOutputParameter(attributeName);
                            Object data = output.getValue();
                            if (data == null) continue;
                            session.removeAttribute(attributeName);
                            session.setAttribute(attributeName, data);
                        }
                    }
                    catch (Throwable th) {
                        Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getString("PentahoSystem.WARN_UNABLE_TO_EXECUTE_SESSION_ACTION", th.getLocalizedMessage()), th);
                    }
                    finally {
                        if (context == null) continue;
                        context.dispose();
                    }
                }
                return;
            }
            finally {
                session.setAttribute("StartupActionsFired", (Object)true);
            }
        }
        Logger.debug(PentahoSystem.class, "Session startup actions already fired");
    }

    public static void globalStartup() {
        List<ISessionStartupAction> globalStartupActions = PentahoSystem.getGlobalStartupActions();
        if (globalStartupActions == null || globalStartupActions.size() == 0) {
            return;
        }
        Logger.debug(PentahoSystem.class, "Process global startup actions");
        try {
            SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PentahoSystem.globalStartup(PentahoSessionHolder.getSession());
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void globalStartup(IPentahoSession session) {
        boolean doGlobals;
        List<ISessionStartupAction> globalStartupActions = PentahoSystem.getGlobalStartupActions();
        if (globalStartupActions == null) {
            return;
        }
        boolean bl = doGlobals = globalAttributes.size() == 0;
        if (!doGlobals) {
            return;
        }
        if (globalStartupActions != null) {
            for (ISessionStartupAction globalStartupAction : globalStartupActions) {
                IOutputHandler outputHandler = null;
                String instanceId = null;
                ISolutionEngine solutionEngine = PentahoSystem.get(ISolutionEngine.class, session);
                solutionEngine.setLoggingLevel(loggingLevel);
                solutionEngine.init(session);
                String baseUrl = "";
                HashMap parameterProviderMap = new HashMap();
                SimpleUrlFactory urlFactory = new SimpleUrlFactory(baseUrl);
                ArrayList messages = new ArrayList();
                IRuntimeContext context = null;
                try {
                    context = solutionEngine.execute(globalStartupAction.getActionPath(), "Global startup actions", false, true, instanceId, false, parameterProviderMap, outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
                    if (null == context) {
                        return;
                    }
                    if (context.getStatus() != 6) continue;
                    for (String attributeName : context.getOutputNames()) {
                        IActionParameter output = context.getOutputParameter(attributeName);
                        Object data = output.getValue();
                        if (data == null) continue;
                        globalAttributes.remove(attributeName);
                        globalAttributes.put(attributeName, data);
                    }
                }
                catch (Throwable th) {
                    Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getString("PentahoSystem.WARN_UNABLE_TO_EXECUTE_GLOBAL_ACTION", th.getLocalizedMessage()), th);
                }
                finally {
                    if (context != null) {
                        context.dispose();
                    }
                }
            }
        }
    }

    public static void shutdown() {
        serverStatusProvider.setStatus(IServerStatusProvider.ServerStatus.STOPPING);
        Logger.debug(PentahoSystem.class, "Shutdown Listeners");
        if (listeners != null) {
            ListIterator<IPentahoSystemListener> systemListenerIterator = listeners.listIterator(listeners.size());
            while (systemListenerIterator.hasPrevious()) {
                IPentahoSystemListener listener = systemListenerIterator.previous();
                if (listener == null) continue;
                Logger.debug(PentahoSystem.class, "Shutdown Listener: " + listener.getClass().getName());
                try {
                    listener.shutdown();
                }
                catch (Throwable e) {
                    Logger.error(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0015_SHUTDOWN_FAILURE", listener.getClass().getName()), e);
                }
            }
        }
        Logger.debug(PentahoSystem.class, "Listeners Shut Down");
        PentahoSystem.clearObjectFactory();
        PentahoSystem.systemExitPoint();
        PentahoSystem.setApplicationContext(null);
        initializedStatus = -1;
        serverStatusProvider.setStatus(IServerStatusProvider.ServerStatus.DOWN);
    }

    public static IApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setApplicationContext(IApplicationContext pApplicationContext) {
        applicationContext = pApplicationContext;
    }

    @Deprecated
    public static Object createObject(String className, ILogger logger) {
        Object object = null;
        try {
            Class<?> componentClass = Class.forName(className.trim());
            object = componentClass.newInstance();
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getErrorString("PentahoSystem.ERROR_0013_COULD_NOT_CREATE_OBEJCT", className);
            if (null == logger) {
                Logger.fatal(PentahoSystem.class.getName(), msg, t);
            }
            logger.fatal(msg, t);
        }
        return object;
    }

    @Deprecated
    public static Object createObject(String className) {
        return PentahoSystem.createObject(className, null);
    }

    public static String getSystemSetting(String path, String settingName, String defaultValue) {
        if (systemSettingsService == null) {
            return defaultValue;
        }
        return systemSettingsService.getSystemSetting(path, settingName, defaultValue);
    }

    public static String getSystemSetting(String settingName, String defaultValue) {
        if (systemSettingsService == null) {
            return defaultValue;
        }
        return systemSettingsService.getSystemSetting(settingName, defaultValue);
    }

    public static ISystemSettings getSystemSettings() {
        return systemSettingsService;
    }

    public static void refreshSettings() {
        systemSettingsService.resetSettingsCache();
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        if (cacheManager != null) {
            cacheManager.removeFromGlobalCache((Object)WAIT_SECONDS);
        }
    }

    public static String publish(IPentahoSession session, String className) {
        Logger.debug(PentahoSystem.class, "Publisher execution");
        for (IPentahoPublisher publisher : administrationPlugins) {
            if (publisher == null || className != null && !className.equals(publisher.getClass().getName())) continue;
            try {
                Logger.debug(PentahoSystem.class, "Publisher publish: " + publisher.getClass().getName());
                return publisher.publish(session, loggingLevel);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return Messages.getInstance().getErrorString("PentahoSystem.ERROR_0017_PUBLISHER_NOT_FOUND");
    }

    public static List getPublisherList() {
        return new ArrayList<IPentahoPublisher>(administrationPlugins);
    }

    public static Document getPublishersDocument() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("publishers");
        if (administrationPlugins != null) {
            for (IPentahoPublisher publisher : administrationPlugins) {
                if (publisher == null) continue;
                try {
                    Element publisherNode = root.addElement("publisher");
                    publisherNode.addElement("name").setText(publisher.getName());
                    publisherNode.addElement("description").setText(publisher.getDescription());
                    publisherNode.addElement("class").setText(publisher.getClass().getName());
                }
                catch (Throwable throwable) {}
            }
        }
        return document;
    }

    public static void systemEntryPoint() {
        if (applicationContext != null) {
            applicationContext.invokeEntryPoints();
        }
    }

    public static void systemExitPoint() {
        if (applicationContext != null) {
            applicationContext.invokeExitPoints();
        }
    }

    private static void registerHostnameVerifier() {
        try {
            String LOCALHOST = "localhost";
            String tmphost = "localhost";
            try {
                String fullyQualifiedServerURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
                if (null == fullyQualifiedServerURL) {
                    return;
                }
                URL url = new URL(fullyQualifiedServerURL);
                tmphost = url.getHost();
            }
            catch (MalformedURLException e) {
                Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0030_VERIFIER_FAILED"), (Throwable)e);
            }
            final String host = tmphost;
            HostnameVerifier myHv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostName, SSLSession session) {
                    return hostName.equals(host) || hostName.equals("localhost");
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(myHv);
        }
        catch (Throwable t) {
            Logger.warn(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0030_VERIFIER_FAILED"), t);
        }
    }

    public static ICacheManager getCacheManager(IPentahoSession session) {
        try {
            ICacheManager cacheManager = aggObjectFactory.get(ICacheManager.class, session);
            return cacheManager;
        }
        catch (ObjectFactoryException e) {
            SimpleMapCacheManager cacheManager = SimpleMapCacheManager.getInstance();
            Logger.warn(PentahoSystem.class.getName(), "Using default cache manager");
            return cacheManager;
        }
    }

    public static List getACLFileExtensionList() {
        return UnmodifiableACLFileExtensionList;
    }

    public static List getDownloadRolesList() {
        return UnmodifiableDownloadRolesList;
    }

    public static void addLogoutListener(ILogoutListener listener) {
        if (logoutListeners.contains(listener)) {
            return;
        }
        logoutListeners.add(listener);
    }

    public static ILogoutListener remove(ILogoutListener listener) {
        if (logoutListeners.remove(listener)) {
            return listener;
        }
        return null;
    }

    public static void invokeLogoutListeners(IPentahoSession session) {
        for (ILogoutListener listener : logoutListeners) {
            listener.onLogout(session);
        }
    }

    public static IPentahoObjectFactory getObjectFactory() {
        return aggObjectFactory;
    }

    public static void registerObjectFactory(IPentahoObjectFactory pentahoObjectFactory) {
        aggObjectFactory.registerObjectFactory(pentahoObjectFactory);
    }

    public static boolean deregisterObjectFactory(IPentahoObjectFactory factory) {
        return aggObjectFactory.deregisterObjectFactory(factory);
    }

    public static void registerPrimaryObjectFactory(IPentahoObjectFactory pentahoObjectFactory) {
        aggObjectFactory.registerObjectFactory(pentahoObjectFactory, true);
    }

    public static void setAdministrationPlugins(List<IPentahoPublisher> administrationPlugins) {
        PentahoSystem.administrationPlugins = administrationPlugins;
    }

    public static void setSystemListeners(List<IPentahoSystemListener> systemListeners) {
        listeners = systemListeners;
    }

    public static void setSessionStartupActions(List<ISessionStartupAction> actions) {
        sessionStartupActions = actions;
    }

    public static void setSystemSettingsService(ISystemSettings systemSettingsService) {
        PentahoSystem.systemSettingsService = systemSettingsService;
    }

    private static List<ISessionStartupAction> getSessionStartupActionsForType(String sessionClassName) {
        ArrayList<ISessionStartupAction> startupActions = new ArrayList<ISessionStartupAction>();
        if (sessionStartupActions != null) {
            for (ISessionStartupAction sessionStartupAction : sessionStartupActions) {
                if (!sessionStartupAction.getSessionType().equals(sessionClassName) || !sessionStartupAction.getActionOutputScope().equals(SCOPE_SESSION)) continue;
                startupActions.add(sessionStartupAction);
            }
        }
        return startupActions;
    }

    private static List<ISessionStartupAction> getGlobalStartupActions() {
        ArrayList<ISessionStartupAction> startupActions = new ArrayList<ISessionStartupAction>();
        if (sessionStartupActions != null) {
            for (ISessionStartupAction sessionStartupAction : sessionStartupActions) {
                if (!sessionStartupAction.getActionOutputScope().equals(SCOPE_GLOBAL)) continue;
                startupActions.add(sessionStartupAction);
            }
        }
        return startupActions;
    }

    private static void validateObjectFactory() throws PentahoSystemException {
        boolean isValid;
        boolean isRequiredValid = true;
        for (String interfaceName : RequiredObjects) {
            isValid = aggObjectFactory.objectDefined(interfaceName);
            isRequiredValid &= isValid;
            if (isValid) continue;
            Logger.fatal(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoSystem.ERROR_0021_OBJECT_NOT_SPECIFIED", interfaceName));
        }
        for (String interfaceName : KnownOptionalObjects) {
            isValid = aggObjectFactory.objectDefined(interfaceName);
            if (isValid) continue;
            Logger.info(PentahoSystem.class.getName(), Messages.getInstance().getString("PentahoSystem.ERROR_0021_OBJECT_NOT_SPECIFIED", interfaceName));
        }
        if (!isRequiredValid) {
            throw new PentahoSystemException(Messages.getInstance().getErrorString("PentahoSystem.ERROR_0420_MISSING_REQUIRED_OBJECT"));
        }
    }

    public static void clearObjectFactory() {
        aggObjectFactory.clear();
        PentahoSystem.defaultObjectFactory();
    }

    public static <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference, IPentahoRegistrableObjectFactory.Types types) {
        return runtimeObjectFactory.registerReference(reference, types);
    }

    public static IPentahoObjectRegistration registerObject(Object obj) {
        return runtimeObjectFactory.registerObject(obj);
    }

    public static IPentahoObjectRegistration registerObject(Object obj, IPentahoRegistrableObjectFactory.Types types) {
        return runtimeObjectFactory.registerObject(obj, types);
    }

    public static <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference) {
        return runtimeObjectFactory.registerReference(reference);
    }

    public static <T> IPentahoObjectRegistration registerObject(T obj, Class<?> ... classes) {
        return runtimeObjectFactory.registerObject(obj, classes);
    }

    public static <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference, Class<?> ... classes) {
        return runtimeObjectFactory.registerReference(reference, classes);
    }

    static {
        administrationPlugins = new ArrayList<IPentahoPublisher>();
        listeners = new ArrayList<IPentahoSystemListener>();
        sessionStartupActions = new ArrayList<ISessionStartupAction>();
        aggObjectFactory = new AggregateObjectFactory();
        initializationFailureDetailsMap = Collections.synchronizedMap(new HashMap());
        RequiredObjects = new ArrayList<String>();
        KnownOptionalObjects = new ArrayList<String>();
        IgnoredObjects = new ArrayList<String>();
        SYSTEM_LISTENERS_FAILED = (int)Math.pow(2.0, 0.0);
        SYSTEM_OBJECTS_FAILED = (int)Math.pow(2.0, 1.0);
        SYSTEM_PUBLISHERS_FAILED = (int)Math.pow(2.0, 2.0);
        SYSTEM_AUDIT_FAILED = (int)Math.pow(2.0, 3.0);
        SYSTEM_PENTAHOXML_FAILED = (int)Math.pow(2.0, 4.0);
        SYSTEM_SETTINGS_FAILED = (int)Math.pow(2.0, 5.0);
        SYSTEM_OTHER_FAILED = (int)Math.pow(2.0, 6.0);
        initializedStatus = -1;
        ACLFileExtensionList = new ArrayList();
        UnmodifiableACLFileExtensionList = UnmodifiableList.decorate((List)ACLFileExtensionList);
        DownloadRolesList = new ArrayList();
        UnmodifiableDownloadRolesList = UnmodifiableList.decorate((List)DownloadRolesList);
        logoutListeners = Collections.synchronizedList(new ArrayList());
        serverStatusProvider = IServerStatusProvider.LOCATOR.getProvider();
        PentahoSystem.defaultObjectFactory();
        KnownOptionalObjects.add(SOLUTION_REPOSITORY);
        KnownOptionalObjects.add(ACL_VOTER);
        KnownOptionalObjects.add(CONDITIONAL_EXECUTION);
        KnownOptionalObjects.add(RUNTIME_REPOSITORY);
        KnownOptionalObjects.add(CACHE_MANAGER);
        KnownOptionalObjects.add(CONTENT_REPOSITORY);
        KnownOptionalObjects.add("IUITemplater");
        KnownOptionalObjects.add("IUserFilesComponent");
        KnownOptionalObjects.add(BACKGROUND_EXECUTION);
        KnownOptionalObjects.add(SCHEDULER);
        KnownOptionalObjects.add(MESSAGE_FORMATTER);
        KnownOptionalObjects.add(USERSETTING_SERVICE);
        IgnoredObjects.add("IAuditEntry");
    }
}

