/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jws.WebService;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.webservices.NodeRepositoryFileDataDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclAceDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.api.repository2.unified.webservices.StringKeyStringValueDto;
import org.pentaho.platform.api.repository2.unified.webservices.VersionSummaryDto;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.locale.PentahoLocale;
import org.pentaho.platform.repository2.unified.webservices.IUnifiedRepositoryWebService;
import org.pentaho.platform.repository2.unified.webservices.NodeRepositoryFileDataAdapter;
import org.pentaho.platform.repository2.unified.webservices.PropertiesWrapper;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAceAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeAdapter;
import org.pentaho.platform.repository2.unified.webservices.VersionSummaryAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(endpointInterface="org.pentaho.platform.repository2.unified.webservices.IUnifiedRepositoryWebService", serviceName="unifiedRepository", portName="unifiedRepositoryPort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class DefaultUnifiedRepositoryWebService
implements IUnifiedRepositoryWebService {
    private static Logger logger = LoggerFactory.getLogger(DefaultUnifiedRepositoryWebService.class);
    protected IUnifiedRepository repo;
    protected RepositoryFileAdapter repositoryFileAdapter = new RepositoryFileAdapter();
    protected NodeRepositoryFileDataAdapter nodeRepositoryFileDataAdapter = new NodeRepositoryFileDataAdapter();
    protected RepositoryFileAclAdapter repositoryFileAclAdapter = new RepositoryFileAclAdapter();
    protected RepositoryFileAclAceAdapter repositoryFileAclAceAdapter = new RepositoryFileAclAceAdapter();
    protected VersionSummaryAdapter versionSummaryAdapter = new VersionSummaryAdapter();
    protected RepositoryFileTreeAdapter repositoryFileTreeAdapter;

    public DefaultUnifiedRepositoryWebService() {
        this.repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        if (this.repo == null) {
            throw new IllegalStateException();
        }
    }

    public DefaultUnifiedRepositoryWebService(IUnifiedRepository repo) {
        this.repo = repo;
    }

    public static Logger getLogger() {
        return logger;
    }

    @Override
    public List<RepositoryFileDto> getChildrenFromRequest(RepositoryRequest repositoryRequest) {
        return this.marshalFiles(this.repo.getChildren(repositoryRequest), repositoryRequest);
    }

    @Override
    @Deprecated
    public List<RepositoryFileDto> getChildren(String folderId) {
        return this.getChildrenWithFilter(folderId, null);
    }

    @Override
    @Deprecated
    public List<RepositoryFileDto> getChildrenWithFilter(String folderId, String filter) {
        return this.getChildrenWithFilterAndHidden(folderId, filter, false);
    }

    @Override
    @Deprecated
    public List<RepositoryFileDto> getChildrenWithFilterAndHidden(String folderId, String filter, Boolean showHiddenFiles) {
        return this.marshalFiles(this.repo.getChildren(new RepositoryRequest(folderId, showHiddenFiles, Integer.valueOf(0), filter)));
    }

    @Override
    public NodeRepositoryFileDataDto getDataAsNodeForRead(String fileId) {
        NodeRepositoryFileData fileData = (NodeRepositoryFileData)this.repo.getDataForRead((Serializable)((Object)fileId), NodeRepositoryFileData.class);
        return fileData != null ? this.nodeRepositoryFileDataAdapter.marshal(fileData) : null;
    }

    @Override
    public List<NodeRepositoryFileDataDto> getDataAsNodeForReadInBatch(List<RepositoryFileDto> files) {
        ArrayList<NodeRepositoryFileDataDto> data = new ArrayList<NodeRepositoryFileDataDto>(files.size());
        for (RepositoryFileDto f : files) {
            if (f.getVersionId() == null) {
                data.add(this.nodeRepositoryFileDataAdapter.marshal((NodeRepositoryFileData)this.repo.getDataForRead((Serializable)((Object)f.getId()), NodeRepositoryFileData.class)));
                continue;
            }
            data.add(this.nodeRepositoryFileDataAdapter.marshal((NodeRepositoryFileData)this.repo.getDataAtVersionForRead((Serializable)((Object)f.getId()), (Serializable)((Object)f.getVersionId()), NodeRepositoryFileData.class)));
        }
        return data;
    }

    public RepositoryFileDto getFile(String path) {
        this.validateEtcReadAccess(path);
        RepositoryFile file = this.repo.getFile(path);
        return file != null ? this.repositoryFileAdapter.marshal(file) : null;
    }

    public RepositoryFileDto getFileById(String fileId) {
        RepositoryFile file = this.repo.getFileById((Serializable)((Object)fileId));
        return file != null ? this.repositoryFileAdapter.marshal(file) : null;
    }

    @Override
    public RepositoryFileDto getFile(String path, boolean loadLocaleMaps, PentahoLocale locale) {
        RepositoryFile file = this.repo.getFile(path, loadLocaleMaps, (IPentahoLocale)locale);
        return file != null ? this.repositoryFileAdapter.marshal(file) : null;
    }

    @Override
    public RepositoryFileDto getFileById(String fileId, boolean loadLocaleMaps, PentahoLocale locale) {
        RepositoryFile file = this.repo.getFileById((Serializable)((Object)fileId), loadLocaleMaps, (IPentahoLocale)locale);
        return file != null ? this.repositoryFileAdapter.marshal(file) : null;
    }

    @Override
    public RepositoryFileTreeDto getTree(String path, int depth, String filter, boolean showHidden) {
        RepositoryRequest repositoryRequest = new RepositoryRequest(path, Boolean.valueOf(showHidden), Integer.valueOf(depth), filter);
        return this.getTreeFromRequest(repositoryRequest);
    }

    @Override
    public RepositoryFileTreeDto getTreeFromRequest(RepositoryRequest repositoryRequest) {
        RepositoryFileTree tree;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean isAdmin = policy.isAllowed("org.pentaho.security.administerSecurity");
        if (!isAdmin) {
            repositoryRequest.setIncludeSystemFolders(false);
            DefaultUnifiedRepositoryWebService.getLogger().warn("User does not have administrator privileges; setting includeSystemFolders to false.");
        }
        if ((tree = this.repo.getTree(repositoryRequest)) != null) {
            return new RepositoryFileTreeAdapter(repositoryRequest).marshal(tree);
        }
        return null;
    }

    protected List<RepositoryFileDto> marshalFiles(List<RepositoryFile> files) {
        ArrayList<RepositoryFileDto> fileDtos = new ArrayList<RepositoryFileDto>();
        for (RepositoryFile file : files) {
            fileDtos.add(this.repositoryFileAdapter.marshal(file));
        }
        return fileDtos;
    }

    private List<RepositoryFileDto> marshalFiles(List<RepositoryFile> files, RepositoryRequest repositoryRequest) {
        ArrayList<RepositoryFileDto> fileDtos = new ArrayList<RepositoryFileDto>();
        RepositoryFileAdapter filteringRepositoryFileAdapter = new RepositoryFileAdapter(repositoryRequest);
        for (RepositoryFile file : files) {
            fileDtos.add(filteringRepositoryFileAdapter.marshal(file));
        }
        return fileDtos;
    }

    private List<RepositoryFileAclAceDto> marshalAces(List<RepositoryFileAce> aces) {
        ArrayList<RepositoryFileAclAceDto> aceDtos = new ArrayList<RepositoryFileAclAceDto>();
        for (RepositoryFileAce ace : aces) {
            aceDtos.add(this.repositoryFileAclAceAdapter.marshal(ace));
        }
        return aceDtos;
    }

    @Override
    public RepositoryFileDto createFolder(String parentFolderId, RepositoryFileDto file, String versionMessage) {
        RepositoryFile newFile = this.repo.createFolder((Serializable)((Object)parentFolderId), this.repositoryFileAdapter.unmarshal(file), versionMessage);
        return newFile != null ? this.repositoryFileAdapter.marshal(newFile) : null;
    }

    @Override
    public RepositoryFileDto createFolderWithAcl(String parentFolderId, RepositoryFileDto file, RepositoryFileAclDto acl, String versionMessage) {
        RepositoryFile newFile = this.repo.createFolder((Serializable)((Object)parentFolderId), this.repositoryFileAdapter.unmarshal(file), this.repositoryFileAclAdapter.unmarshal(acl), versionMessage);
        return newFile != null ? this.repositoryFileAdapter.marshal(newFile) : null;
    }

    @Override
    public void deleteFile(String fileId, String versionMessage) {
        this.repo.deleteFile((Serializable)((Object)fileId), versionMessage);
    }

    @Override
    public void deleteFileAtVersion(String fileId, String versionId) {
        this.repo.deleteFileAtVersion((Serializable)((Object)fileId), (Serializable)((Object)versionId));
    }

    @Override
    public void deleteFileWithPermanentFlag(String fileId, boolean permanent, String versionMessage) {
        this.repo.deleteFile((Serializable)((Object)fileId), permanent, versionMessage);
    }

    @Override
    public List<RepositoryFileDto> getDeletedFiles() {
        return this.marshalFiles(this.repo.getAllDeletedFiles());
    }

    @Override
    public List<RepositoryFileDto> getDeletedFilesInFolder(String folderPath) {
        return this.marshalFiles(this.repo.getDeletedFiles(folderPath));
    }

    @Override
    public List<RepositoryFileDto> getDeletedFilesInFolderWithFilter(String folderPath, String filter) {
        return this.marshalFiles(this.repo.getDeletedFiles(folderPath, filter));
    }

    @Override
    public void lockFile(String fileId, String message) {
        this.repo.lockFile((Serializable)((Object)fileId), message);
    }

    @Override
    public void moveFile(String fileId, String destAbsPath, String versionMessage) {
        this.repo.moveFile((Serializable)((Object)fileId), destAbsPath, versionMessage);
    }

    @Override
    public void copyFile(String fileId, String destAbsPath, String versionMessage) {
        this.repo.copyFile((Serializable)((Object)fileId), destAbsPath, versionMessage);
    }

    @Override
    public void undeleteFile(String fileId, String versionMessage) {
        this.repo.undeleteFile((Serializable)((Object)fileId), versionMessage);
    }

    @Override
    public void unlockFile(String fileId) {
        this.repo.unlockFile((Serializable)((Object)fileId));
    }

    @Override
    public RepositoryFileDto createFile(String parentFolderId, RepositoryFileDto file, NodeRepositoryFileDataDto data, String versionMessage) {
        this.validateEtcWriteAccess(parentFolderId);
        return this.repositoryFileAdapter.marshal(this.repo.createFile((Serializable)((Object)parentFolderId), this.repositoryFileAdapter.unmarshal(file), (IRepositoryFileData)this.nodeRepositoryFileDataAdapter.unmarshal(data), versionMessage));
    }

    @Override
    public RepositoryFileDto createFileWithAcl(String parentFolderId, RepositoryFileDto file, NodeRepositoryFileDataDto data, RepositoryFileAclDto acl, String versionMessage) {
        this.validateEtcWriteAccess(parentFolderId);
        return this.repositoryFileAdapter.marshal(this.repo.createFile((Serializable)((Object)parentFolderId), this.repositoryFileAdapter.unmarshal(file), (IRepositoryFileData)this.nodeRepositoryFileDataAdapter.unmarshal(data), this.repositoryFileAclAdapter.unmarshal(acl), versionMessage));
    }

    @Override
    public RepositoryFileDto updateFile(RepositoryFileDto file, NodeRepositoryFileDataDto data, String versionMessage) {
        return this.repositoryFileAdapter.marshal(this.repo.updateFile(this.repositoryFileAdapter.unmarshal(file), (IRepositoryFileData)this.nodeRepositoryFileDataAdapter.unmarshal(data), versionMessage));
    }

    @Override
    public boolean canUnlockFile(String fileId) {
        return this.repo.canUnlockFile((Serializable)((Object)fileId));
    }

    @Override
    public RepositoryFileAclDto getAcl(String fileId) {
        if (this.repo == null) {
            return null;
        }
        return this.repositoryFileAclAdapter.marshal(this.repo.getAcl((Serializable)((Object)fileId)));
    }

    @Override
    public NodeRepositoryFileDataDto getDataAsNodeForReadAtVersion(String fileId, String versionId) {
        return this.nodeRepositoryFileDataAdapter.marshal((NodeRepositoryFileData)this.repo.getDataAtVersionForRead((Serializable)((Object)fileId), (Serializable)((Object)versionId), NodeRepositoryFileData.class));
    }

    @Override
    public List<RepositoryFileAclAceDto> getEffectiveAces(String fileId) {
        return this.marshalAces(this.repo.getEffectiveAces((Serializable)((Object)fileId)));
    }

    @Override
    public List<RepositoryFileAclAceDto> getEffectiveAcesWithForceFlag(String fileId, boolean forceEntriesInheriting) {
        return this.marshalAces(this.repo.getEffectiveAces((Serializable)((Object)fileId), forceEntriesInheriting));
    }

    @Override
    public RepositoryFileDto getFileAtVersion(String fileId, String versionId) {
        return this.repositoryFileAdapter.marshal(this.repo.getFileAtVersion((Serializable)((Object)fileId), (Serializable)((Object)versionId)));
    }

    @Override
    public void restoreFileAtVersion(String fileId, String versionId, String versionMessage) {
        this.repo.restoreFileAtVersion((Serializable)((Object)fileId), (Serializable)((Object)versionId), versionMessage);
    }

    @Override
    public RepositoryFileAclDto updateAcl(RepositoryFileAclDto acl) {
        return this.repositoryFileAclAdapter.marshal(this.repo.updateAcl(this.repositoryFileAclAdapter.unmarshal(acl)));
    }

    @Override
    public List<VersionSummaryDto> getVersionSummaries(String fileId) {
        return this.marshalVersionSummaries(this.repo.getVersionSummaries((Serializable)((Object)fileId)));
    }

    private List<VersionSummaryDto> marshalVersionSummaries(List<VersionSummary> versionSummaries) {
        ArrayList<VersionSummaryDto> versionSummaryDtos = new ArrayList<VersionSummaryDto>();
        for (VersionSummary versionSummary : versionSummaries) {
            versionSummaryDtos.add(this.versionSummaryAdapter.marshal(versionSummary));
        }
        return versionSummaryDtos;
    }

    @Override
    public VersionSummaryDto getVersionSummary(String fileId, String versionId) {
        return this.versionSummaryAdapter.marshal(this.repo.getVersionSummary((Serializable)((Object)fileId), (Serializable)((Object)versionId)));
    }

    @Override
    public List<VersionSummaryDto> getVersionSummaryInBatch(List<RepositoryFileDto> files) {
        ArrayList<VersionSummaryDto> versions = new ArrayList<VersionSummaryDto>(files.size());
        for (RepositoryFileDto file : files) {
            versions.add(this.versionSummaryAdapter.marshal(this.repo.getVersionSummary((Serializable)((Object)file.getId()), (Serializable)((Object)file.getVersionId()))));
        }
        return versions;
    }

    @Override
    public boolean hasAccess(String path, List<Integer> permissions) {
        return this.repo.hasAccess(path, RepositoryFileAclAceAdapter.toPerms(permissions));
    }

    @Override
    public List<RepositoryFileDto> getReferrers(String fileId) {
        ArrayList<RepositoryFileDto> fileList = new ArrayList<RepositoryFileDto>();
        for (RepositoryFile file : this.repo.getReferrers((Serializable)((Object)fileId))) {
            fileList.add(this.repositoryFileAdapter.marshal(file));
        }
        return fileList;
    }

    @Override
    public void setFileMetadata(String fileId, List<StringKeyStringValueDto> fileMetadataMap) {
        HashMap<String, String> metadataMap = new HashMap<String, String>(fileMetadataMap.size());
        for (StringKeyStringValueDto dto : fileMetadataMap) {
            metadataMap.put(dto.getKey(), dto.getValue());
        }
        this.repo.setFileMetadata((Serializable)((Object)fileId), metadataMap);
    }

    @Override
    public List<StringKeyStringValueDto> getFileMetadata(String fileId) {
        Map metadataMap = this.repo.getFileMetadata((Serializable)((Object)fileId));
        ArrayList<StringKeyStringValueDto> fileMetadataMap = new ArrayList<StringKeyStringValueDto>(metadataMap.size());
        for (String key : metadataMap.keySet()) {
            fileMetadataMap.add(new StringKeyStringValueDto(key, ((Serializable)metadataMap.get(key)).toString()));
        }
        return fileMetadataMap;
    }

    @Override
    public List<Character> getReservedChars() {
        return this.repo.getReservedChars();
    }

    protected void validateEtcWriteAccess(String parentFolderId) {
        String etcFolderId;
        RepositoryFile etcFolder = this.repo.getFile("/etc");
        if (etcFolder != null && (etcFolderId = etcFolder.getId().toString()).equals(parentFolderId)) {
            throw new RuntimeException("This service is not allowed to access the ETC folder in JCR.");
        }
    }

    protected void validateEtcReadAccess(String path) {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean isAdmin = policy.isAllowed("org.pentaho.security.administerSecurity");
        if (!isAdmin && path.startsWith("/etc")) {
            throw new RuntimeException("This user is not allowed to access the ETC folder in JCR.");
        }
    }

    @Override
    public List<PentahoLocale> getAvailableLocalesForFileById(String fileId) {
        ArrayList<PentahoLocale> pentahoLocales = new ArrayList<PentahoLocale>();
        List locales = this.repo.getAvailableLocalesForFileById((Serializable)((Object)fileId));
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                pentahoLocales.add(new PentahoLocale(locale));
            }
        }
        return pentahoLocales;
    }

    @Override
    public PropertiesWrapper getLocalePropertiesForFileById(String fileId, String locale) {
        return new PropertiesWrapper(this.repo.getLocalePropertiesForFileById((Serializable)((Object)fileId), locale));
    }

    @Override
    public void setLocalePropertiesForFileByFileId(String fileId, String locale, Properties properties) {
        this.repo.setLocalePropertiesForFileById((Serializable)((Object)fileId), locale, properties);
    }

    @Override
    public void deleteLocalePropertiesForFile(String fileId, String locale) {
        this.repo.deleteLocalePropertiesForFile(this.repo.getFileById((Serializable)((Object)fileId)), locale);
    }

    @Override
    public RepositoryFileDto updateFolder(RepositoryFileDto folder, String versionMessage) {
        return this.repositoryFileAdapter.marshal(this.repo.updateFolder(this.repositoryFileAdapter.unmarshal(folder), versionMessage));
    }
}

