/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.jackrabbit.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.JcrAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityRolePrincipal;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.messages.Messages;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class SpringSecurityPrincipalProvider
implements PrincipalProvider {
    public static final String ROLE_CACHE_REGION = "principalProviderRoleCache";
    public static final String USER_CACHE_REGION = "principalProviderUserCache";
    private ICacheManager cacheManager;
    private Log logger = LogFactory.getLog(SpringSecurityPrincipalProvider.class);
    private UserDetailsService userDetailsService;
    private IUserRoleListService userRoleListService;
    private String adminId;
    private AdminPrincipal adminPrincipal;
    private String anonymousId;
    private final AnonymousPrincipal anonymousPrincipal = new AnonymousPrincipal();
    final boolean ACCOUNT_NON_EXPIRED = true;
    final boolean CREDS_NON_EXPIRED = true;
    final boolean ACCOUNT_NON_LOCKED = true;
    private boolean skipUserVerification;
    private final String SKIP_USER_VERIFICATION_PROP_KEY = "skipUserVerificationOnPrincipalCreation";
    private final boolean SKIP_USER_VERIFICATION_DEFAULT_VALUE = true;
    private ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties options) {
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (this.initialized.get()) {
                throw new IllegalStateException(Messages.getInstance().getString("SpringSecurityPrincipalProvider.ERROR_0001_ALREADY_INITIALIZED"));
            }
        }
        this.adminId = options.getProperty("adminId", "admin");
        this.adminPrincipal = new AdminPrincipal(this.adminId);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("using adminId [%s]", this.adminId));
        }
        this.anonymousId = options.getProperty("anonymousId", "anonymous");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("using anonymousId [%s]", this.anonymousId));
        }
        this.cacheManager = PentahoSystem.getCacheManager(null);
        if (this.cacheManager != null) {
            if (!this.cacheManager.cacheEnabled(USER_CACHE_REGION)) {
                this.cacheManager.addCacheRegion(USER_CACHE_REGION);
            }
            if (!this.cacheManager.cacheEnabled(ROLE_CACHE_REGION)) {
                this.cacheManager.addCacheRegion(ROLE_CACHE_REGION);
            }
        }
        this.initSkipUserVerification(options);
        this.initialized.set(true);
    }

    public void close() {
        this.checkInitialized();
        this.clearCaches();
        this.cacheManager = null;
        this.initialized.set(false);
    }

    public synchronized void clearCaches() {
        if (this.cacheManager != null) {
            this.cacheManager.clearRegionCache(ROLE_CACHE_REGION);
            this.cacheManager.clearRegionCache(USER_CACHE_REGION);
        }
    }

    public synchronized boolean canReadPrincipal(Session session, Principal principalToRead) {
        this.checkInitialized();
        return true;
    }

    public synchronized Principal getPrincipal(String principalName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("principalName: [" + principalName + "]"));
        }
        this.checkInitialized();
        Assert.notNull((Object)principalName);
        if (JcrAclMetadataStrategy.AclMetadataPrincipal.isAclMetadataPrincipal(principalName)) {
            return new JcrAclMetadataStrategy.AclMetadataPrincipal(principalName);
        }
        if (this.adminId.equals(principalName)) {
            return this.adminPrincipal;
        }
        if (this.anonymousId.equals(principalName)) {
            return this.anonymousPrincipal;
        }
        if (EveryonePrincipal.getInstance().getName().equals(principalName)) {
            return EveryonePrincipal.getInstance();
        }
        if (JcrTenantUtils.isTenantedUser(principalName)) {
            if (this.cacheManager != null) {
                Principal userFromUserCache = (Principal)this.cacheManager.getFromRegionCache(USER_CACHE_REGION, (Object)JcrTenantUtils.getTenantedUser(principalName));
                if (userFromUserCache != null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("user " + principalName + " found in cache"));
                    }
                    return userFromUserCache;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("user " + principalName + " not found in cache"));
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(" Cache is not available. Will create a principal for user [" + principalName + ']'));
            }
            if (this.skipUserVerification || this.internalGetUserDetails(principalName) != null) {
                UserPrincipal user = new UserPrincipal(principalName);
                if (this.cacheManager != null) {
                    this.cacheManager.putInRegionCache(USER_CACHE_REGION, (Object)principalName, (Object)user);
                }
                return user;
            }
        } else if (JcrTenantUtils.isTenatedRole(principalName)) {
            if (this.cacheManager != null) {
                Principal roleFromCache = (Principal)this.cacheManager.getFromRegionCache(ROLE_CACHE_REGION, (Object)JcrTenantUtils.getTenantedRole(principalName));
                if (roleFromCache != null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("role " + principalName + " found in cache"));
                    }
                    return roleFromCache;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("role " + principalName + " not found in cache"));
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(" Cache is not available. Will create a principal for role [" + principalName + ']'));
            }
            SpringSecurityRolePrincipal roleToCache = this.createSpringSecurityRolePrincipal(principalName);
            if (this.cacheManager != null) {
                this.cacheManager.putInRegionCache(ROLE_CACHE_REGION, (Object)principalName, (Object)roleToCache);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("assuming " + principalName + " is a role"));
            }
            return roleToCache;
        }
        return null;
    }

    public PrincipalIterator getGroupMembership(Principal principal) {
        this.checkInitialized();
        Assert.notNull((Object)principal);
        HashSet<Object> groups = new HashSet<Object>();
        if (principal instanceof AnonymousPrincipal) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        if (principal instanceof EveryonePrincipal) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        if (!(principal instanceof Group || principal instanceof AdminPrincipal || principal instanceof JcrAclMetadataStrategy.AclMetadataPrincipal)) {
            UserDetails user = this.internalGetUserDetails(principal.getName());
            if (user == null) {
                return new PrincipalIteratorAdapter(groups);
            }
            for (GrantedAuthority role : user.getAuthorities()) {
                String roleAuthority = role.getAuthority();
                Principal fromCache = this.cacheManager == null ? null : (Principal)this.cacheManager.getFromRegionCache(ROLE_CACHE_REGION, (Object)roleAuthority);
                if (fromCache != null) {
                    groups.add(fromCache);
                    continue;
                }
                groups.add(this.createSpringSecurityRolePrincipal(roleAuthority));
            }
        }
        groups.add(EveryonePrincipal.getInstance());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("group membership for principal=" + principal + " is " + groups));
        }
        return new PrincipalIteratorAdapter(groups);
    }

    protected UserDetails internalGetUserDetails(String username) {
        Object ssPrincipal;
        if (username != null && username.equals("administrators")) {
            return null;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && (ssPrincipal = auth.getPrincipal()) instanceof UserDetails && username.equals(((UserDetails)ssPrincipal).getUsername())) {
            return (UserDetails)ssPrincipal;
        }
        UserDetails user = null;
        ArrayList<SimpleGrantedAuthority> auths = null;
        ArrayList<SimpleGrantedAuthority> authorities = null;
        User newUser = null;
        if (this.getUserDetailsService() != null) {
            block14: {
                try {
                    String role;
                    user = this.getUserDetailsService().loadUserByUsername(username);
                    if (auth == null || auth.getAuthorities() == null || auth.getAuthorities().size() == 0) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("Authentication object from SecurityContextHolder is null, so getting the roles for [ " + user.getUsername() + " ]  from IUserRoleListService "));
                        }
                        List roles = this.getUserRoleListService().getRolesForUser(JcrTenantUtils.getCurrentTenant(), username);
                        authorities = new ArrayList(roles.size());
                        Iterator iterator = roles.iterator();
                        while (iterator.hasNext()) {
                            role = (String)iterator.next();
                            authorities.add(new SimpleGrantedAuthority(role));
                        }
                    } else {
                        authorities = new ArrayList<SimpleGrantedAuthority>(auth.getAuthorities().size());
                        authorities.addAll(auth.getAuthorities());
                    }
                    auths = new ArrayList(authorities.size());
                    for (GrantedAuthority grantedAuthority : authorities) {
                        Object rolePrincipal;
                        role = grantedAuthority.getAuthority();
                        String tenatedRoleString = JcrTenantUtils.getTenantedRole(role);
                        if (this.cacheManager != null && (rolePrincipal = this.cacheManager.getFromRegionCache(ROLE_CACHE_REGION, (Object)role)) == null) {
                            SpringSecurityRolePrincipal ssRolePrincipal = new SpringSecurityRolePrincipal(tenatedRoleString);
                            this.cacheManager.putInRegionCache(ROLE_CACHE_REGION, (Object)role, (Object)ssRolePrincipal);
                        }
                        auths.add(new SimpleGrantedAuthority(tenatedRoleString));
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("found user in back-end " + user.getUsername()));
                    }
                }
                catch (UsernameNotFoundException e) {
                    if (!this.logger.isTraceEnabled()) break block14;
                    this.logger.trace((Object)("username " + username + " not in cache or back-end; returning null"));
                }
            }
            if (user != null) {
                if (auths == null || auths.size() <= 0) {
                    this.logger.trace((Object)("Authorities are null, so creating an empty Auth array ==  " + user.getUsername()));
                    auths = new ArrayList<SimpleGrantedAuthority>();
                }
                String password = user.getPassword() != null ? user.getPassword() : "";
                newUser = new User(user.getUsername(), password, user.isEnabled(), true, true, true, auths);
            }
        }
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() {
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (!this.initialized.get()) {
                throw new IllegalStateException(Messages.getInstance().getString("SpringSecurityPrincipalProvider.ERROR_0003_NOT_INITIALIZED"));
            }
        }
    }

    public PrincipalIterator findPrincipals(String simpleFilter) {
        throw new UnsupportedOperationException();
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        throw new UnsupportedOperationException();
    }

    public PrincipalIterator getPrincipals(int searchType) {
        throw new UnsupportedOperationException();
    }

    protected UserDetailsService getUserDetailsService() {
        if (null != this.userDetailsService) {
            return this.userDetailsService;
        }
        if (PentahoSystem.getInitializedOK()) {
            this.userDetailsService = (UserDetailsService)PentahoSystem.get(UserDetailsService.class);
            return this.userDetailsService;
        }
        return null;
    }

    protected IUserRoleListService getUserRoleListService() {
        if (null != this.userRoleListService) {
            return this.userRoleListService;
        }
        if (PentahoSystem.getInitializedOK()) {
            this.userRoleListService = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
            return this.userRoleListService;
        }
        return null;
    }

    private SpringSecurityRolePrincipal createSpringSecurityRolePrincipal(String principal) {
        return new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(principal));
    }

    private void initSkipUserVerification(Properties prop) {
        this.skipUserVerification = true;
        if (prop != null && prop.containsKey("skipUserVerificationOnPrincipalCreation") && !prop.getProperty("skipUserVerificationOnPrincipalCreation").isEmpty()) {
            this.skipUserVerification = Boolean.valueOf(prop.getProperty("skipUserVerificationOnPrincipalCreation", String.valueOf(true)));
        } else if (this.systemConfig != null) {
            try {
                IConfiguration config = this.systemConfig.getConfiguration("security");
                if (config != null && config.getProperties().containsKey("skipUserVerificationOnPrincipalCreation") && !config.getProperties().getProperty("skipUserVerificationOnPrincipalCreation").isEmpty()) {
                    this.skipUserVerification = Boolean.valueOf(config.getProperties().getProperty("skipUserVerificationOnPrincipalCreation", String.valueOf(true)));
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
        this.logger.info((Object)("Property 'skipUserVerificationOnPrincipalCreation' is '" + this.skipUserVerification + "'"));
    }
}

