/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.bigdata.api.hdfs.impl;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystem;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystemFactory;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystemLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemLocatorImpl
implements HadoopFileSystemLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileSystemLocatorImpl.class);
    private final List<HadoopFileSystemFactory> hadoopFileSystemFactories;

    public HadoopFileSystemLocatorImpl(List<HadoopFileSystemFactory> hadoopFileSystemFactories) {
        this.hadoopFileSystemFactories = hadoopFileSystemFactories;
    }

    public HadoopFileSystem getHadoopFilesystem(NamedCluster namedCluster) throws ClusterInitializationException {
        return this.getHadoopFilesystem(namedCluster, null);
    }

    public HadoopFileSystem getHadoopFilesystem(NamedCluster namedCluster, URI uri) throws ClusterInitializationException {
        for (HadoopFileSystemFactory hadoopFileSystemFactory : this.hadoopFileSystemFactories) {
            if (!hadoopFileSystemFactory.canHandle(namedCluster)) continue;
            try {
                return hadoopFileSystemFactory.create(namedCluster, uri);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to create " + uri.getScheme() + " service with " + hadoopFileSystemFactory + " for " + namedCluster, (Throwable)e);
            }
        }
        return null;
    }
}

