/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.jdbc.impl;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.pentaho.big.data.api.jdbc.impl.DriverLocatorImpl;
import org.pentaho.big.data.api.jdbc.impl.HasDeregisterDriver;
import org.pentaho.big.data.api.jdbc.impl.HasRegisterDriver;
import org.pentaho.big.data.api.jdbc.impl.LazyDelegatingDriver;
import org.pentaho.di.core.database.DelegatingDriver;
import org.pentaho.hadoop.shim.api.jdbc.JdbcUrlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInitializingDriver
implements Driver {
    private static final List<String> BIG_DATA_DRIVER_URL_PATTERNS = new ArrayList<String>();
    @VisibleForTesting
    protected static Logger logger = LoggerFactory.getLogger(ClusterInitializingDriver.class);
    private final JdbcUrlParser jdbcUrlParser;
    private final HasRegisterDriver hasRegisterDriver;
    private final HasDeregisterDriver hasDeregisterDriver;
    DelegatingDriver delegatingDriver;
    LazyDelegatingDriver[] lazyDelegatingDrivers;

    public ClusterInitializingDriver(JdbcUrlParser jdbcUrlParser, DriverLocatorImpl driverRegistry) {
        this(jdbcUrlParser, driverRegistry, null);
    }

    public ClusterInitializingDriver(JdbcUrlParser jdbcUrlParser, DriverLocatorImpl driverRegistry, Integer numLazyProxies) {
        this(jdbcUrlParser, driverRegistry, numLazyProxies, DriverManager::registerDriver, DriverManager::deregisterDriver);
    }

    public ClusterInitializingDriver(JdbcUrlParser jdbcUrlParser, DriverLocatorImpl driverRegistry, Integer numLazyProxies, HasRegisterDriver hasRegisterDriver, HasDeregisterDriver hasDeregisterDriver) {
        this.jdbcUrlParser = jdbcUrlParser;
        this.hasRegisterDriver = hasRegisterDriver;
        this.hasDeregisterDriver = hasDeregisterDriver;
        int lazyProxies = Optional.ofNullable(numLazyProxies).orElse(5);
        try {
            this.delegatingDriver = new DelegatingDriver((Driver)this);
            hasRegisterDriver.registerDriver((Driver)this.delegatingDriver);
        }
        catch (SQLException e) {
            logger.warn("Unable to register cluster initializing driver", (Throwable)e);
        }
        this.lazyDelegatingDrivers = new LazyDelegatingDriver[lazyProxies];
        for (int i = 0; i < lazyProxies; ++i) {
            try {
                this.lazyDelegatingDrivers[i] = new LazyDelegatingDriver(driverRegistry, hasRegisterDriver, hasDeregisterDriver);
                continue;
            }
            catch (SQLException e) {
                logger.warn("Failed to register " + LazyDelegatingDriver.class.getName(), (Throwable)e);
            }
        }
    }

    public void destroy() {
        try {
            if (this.delegatingDriver != null) {
                this.hasDeregisterDriver.deregisterDriver((Driver)this.delegatingDriver);
            }
        }
        catch (SQLException e) {
            logger.warn("Unable to deregister cluster initializing driver", (Throwable)e);
        }
        finally {
            this.delegatingDriver = null;
        }
        for (int i = 0; i != this.lazyDelegatingDrivers.length; ++i) {
            if (this.lazyDelegatingDrivers[i] == null) continue;
            this.lazyDelegatingDrivers[i].destroy();
            this.lazyDelegatingDrivers[i] = null;
        }
        this.lazyDelegatingDrivers = null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.checkIfUsesBigDataDriver(url)) {
            this.initializeCluster(url);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (this.checkIfUsesBigDataDriver(url)) {
            this.initializeCluster(url);
        }
        return false;
    }

    boolean checkIfUsesBigDataDriver(String url) {
        List<String> urlPatterns = this.getUrlPatternsForBigDataDrivers();
        for (String pattern : urlPatterns) {
            if (!url.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    List<String> getUrlPatternsForBigDataDrivers() {
        return BIG_DATA_DRIVER_URL_PATTERNS;
    }

    private void initializeCluster(String url) {
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:hive:.*");
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:hive2:.*");
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:impala:.*");
        BIG_DATA_DRIVER_URL_PATTERNS.add(".+:spark:.*");
    }
}

