/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.ui;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepOption;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.JmsProducerMeta;
import org.pentaho.di.trans.step.jms.ui.ConnectionForm;
import org.pentaho.di.trans.step.jms.ui.DestinationForm;
import org.pentaho.di.trans.step.jms.ui.JmsDialogSecurityLayout;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JmsProducerDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final int SHELL_MIN_WIDTH = 528;
    private static final int SHELL_MIN_HEIGHT = 670;
    private ModifyListener lsMod;
    private final JmsDelegate jmsDelegate;
    private final JmsProducerMeta meta;
    private CTabFolder wTabFolder;
    private ConnectionForm connectionForm;
    private DestinationForm destinationForm;
    private ComboVar wMessageField;
    private TableView propertiesTable;
    private TableView optionsTable;
    private JmsDialogSecurityLayout jmsDialogSecurityLayout;
    private List<StepOption> options;

    public JmsProducerDialog(Shell parent, Object meta, TransMeta transMeta, String stepname) {
        super(parent, (BaseStepMeta)meta, transMeta, stepname);
        this.meta = (JmsProducerMeta)((Object)meta);
        this.jmsDelegate = this.meta.jmsDelegate;
        this.options = this.meta.retriveOptions();
        this.lsMod = e -> this.meta.setChanged();
        this.lsOK = e -> this.ok();
        this.lsCancel = e -> this.cancel();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.shell.setMinimumSize(528, 670);
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)spacer);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        fdSpacer.width = 497;
        spacer.setLayoutData((Object)fdSpacer);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)hSpacer);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 2;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)spacer, 15);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wSetupTab = new CTabItem(this.wTabFolder, 0);
        wSetupTab.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.SetupTab", (String[])new String[0]));
        Composite wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        this.jmsDialogSecurityLayout = new JmsDialogSecurityLayout(this.props, this.wTabFolder, this.lsMod, this.transMeta, this.jmsDelegate.sslEnabled, this.jmsDelegate);
        this.jmsDialogSecurityLayout.buildSecurityTab();
        this.connectionForm = new ConnectionForm(wSetupComp, this.props, this.transMeta, this.lsMod, this.jmsDelegate, this.jmsDialogSecurityLayout);
        Group group = this.connectionForm.layoutForm();
        this.jmsDialogSecurityLayout.setConnectionForm(this.connectionForm);
        this.destinationForm = new DestinationForm(wSetupComp, (Composite)group, this.props, this.transMeta, this.lsMod, this.jmsDelegate.destinationType, this.jmsDelegate.destinationName);
        Composite destinationFormComposite = this.destinationForm.layoutForm();
        Label lbMessageField = new Label(wSetupComp, 16384);
        this.props.setLook((Control)lbMessageField);
        lbMessageField.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.MessageField", (String[])new String[0]));
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(0, 0);
        fdMessage.top = new FormAttachment((Control)destinationFormComposite, 15);
        fdMessage.width = 250;
        lbMessageField.setLayoutData((Object)fdMessage);
        this.wMessageField = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wMessageField);
        this.wMessageField.addModifyListener(this.lsMod);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(0, 0);
        fdMessageField.top = new FormAttachment((Control)lbMessageField, 5);
        fdMessageField.width = 250;
        this.wMessageField.setLayoutData((Object)fdMessageField);
        Listener lsMessageFocus = e -> {
            String current = this.wMessageField.getText();
            this.wMessageField.getCComboWidget().removeAll();
            this.wMessageField.setText(current);
            try {
                RowMetaInterface rmi = this.transMeta.getPrevStepFields(this.meta.getParentStepMeta().getName());
                List ls = rmi.getValueMetaList();
                for (Object l : ls) {
                    ValueMetaBase vmb = (ValueMetaBase)l;
                    this.wMessageField.add(vmb.getName());
                }
            }
            catch (KettleStepException kettleStepException) {
                // empty catch block
            }
        };
        this.wMessageField.getCComboWidget().addListener(15, lsMessageFocus);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        wSetupComp.setLayoutData((Object)fdSetupComp);
        wSetupComp.layout();
        wSetupTab.setControl((Control)wSetupComp);
        this.wTabFolder.setSelection(0);
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wMessageField.setText(Strings.nullToEmpty((String)this.meta.getFieldToSend()));
        this.buildOptionsTab();
        this.buildProperiesTab();
        this.setSize();
        this.meta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void buildProperiesTab() {
        CTabItem wPropertiesTab = new CTabItem(this.wTabFolder, 0);
        wPropertiesTab.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.Properties.Tab", (String[])new String[0]));
        Composite wPropertiesComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wPropertiesComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wPropertiesComp.setLayout((Layout)fieldsLayout);
        FormData propertiesFormData = new FormData();
        propertiesFormData.left = new FormAttachment(0, 0);
        propertiesFormData.top = new FormAttachment((Control)wPropertiesComp, 0);
        propertiesFormData.right = new FormAttachment(100, 0);
        propertiesFormData.bottom = new FormAttachment(100, 0);
        wPropertiesComp.setLayoutData((Object)propertiesFormData);
        this.buildPropertiesTable(wPropertiesComp);
        wPropertiesComp.layout();
        wPropertiesTab.setControl((Control)wPropertiesComp);
    }

    private void buildPropertiesTable(Composite parentWidget) {
        ColumnInfo[] columns = this.getPropertiesColumns();
        int fieldCount = this.meta.getPropertyValuesByName().size();
        this.propertiesTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.propertiesTable.setSortable(false);
        this.propertiesTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(215);
            table.getColumn(2).setWidth(215);
        });
        this.populateProperties();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        Arrays.stream(this.propertiesTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.propertiesTable.setLayoutData((Object)fdData);
    }

    private ColumnInfo[] getPropertiesColumns() {
        ColumnInfo propertyName = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.Properties.Column.Name", (String[])new String[0]), 1, false, false);
        propertyName.setUsingVariables(true);
        ColumnInfo propertyValue = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProducerDialog.Properties.Column.Value", (String[])new String[0]), 1, false, false);
        propertyValue.setUsingVariables(true);
        return new ColumnInfo[]{propertyName, propertyValue};
    }

    public static Map<String, String> getMapFromTableView(TableView table) {
        int itemCount = table.getItemCount();
        LinkedHashMap<String, String> propertyValuesByName = new LinkedHashMap<String, String>();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = table.getTable().getItem(rowIndex);
            String propertyName = row.getText(1);
            String propertyValue = row.getText(2);
            if (StringUtils.isBlank((String)propertyName) || propertyValuesByName.containsKey(propertyName)) continue;
            propertyValuesByName.put(propertyName, propertyValue);
        }
        return propertyValuesByName;
    }

    private void populateProperties() {
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.meta.getPropertyValuesByName().entrySet()) {
            TableItem key = this.propertiesTable.getTable().getItem(rowIndex++);
            key.setText(1, entry.getKey());
            key.setText(2, entry.getValue());
        }
    }

    private void buildOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Options.Tab", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wOptionsComp);
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginHeight = 15;
        optionsLayout.marginWidth = 15;
        wOptionsComp.setLayout((Layout)optionsLayout);
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)fdOptionsComp);
        ColumnInfo[] columns = this.getOptionsColumns();
        int fieldCount = 1;
        this.optionsTable = new TableView((VariableSpace)this.transMeta, wOptionsComp, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        this.optionsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(215);
            table.getColumn(2).setWidth(215);
        });
        this.populateOptionsTable();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        fdData.width = 360;
        Arrays.stream(this.optionsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.optionsTable.setReadonly(true);
        this.optionsTable.setLayoutData((Object)fdData);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private ColumnInfo[] getOptionsColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Options.Column.Name", (String[])new String[0]), 1, false, true);
        ColumnInfo optionValue = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Options.Column.Value", (String[])new String[0]), 1, false, false);
        optionValue.setUsingVariables(true);
        return new ColumnInfo[]{optionName, optionValue};
    }

    private void populateOptionsTable() {
        this.optionsTable.clearAll();
        this.options.stream().forEach(option -> this.optionsTable.add(new String[]{option.getText(), option.getValue()}));
        this.optionsTable.remove(0);
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.jmsDelegate.connectionType = this.connectionForm.getConnectionType();
        this.jmsDelegate.ibmUrl = this.connectionForm.getIbmUrl();
        this.jmsDelegate.amqUrl = this.connectionForm.getActiveUrl();
        this.jmsDelegate.destinationType = this.destinationForm.getDestinationType();
        this.jmsDelegate.destinationName = this.destinationForm.getDestinationName();
        this.meta.setFieldToSend(this.wMessageField.getText());
        this.meta.setPropertyValuesByName(JmsProducerDialog.getMapFromTableView(this.propertiesTable));
        this.jmsDialogSecurityLayout.saveTableValues();
        this.jmsDialogSecurityLayout.saveAuthentication();
        this.saveOptions();
        this.dispose();
    }

    private List<StepOption> saveOptions() {
        IntStream.range(0, this.optionsTable.getItemCount()).mapToObj(i -> this.optionsTable.getItem(i)).forEach(item -> this.options.stream().forEach(option -> {
            if (option.getText().equals(item[0])) {
                switch (option.getKey()) {
                    case "DISABLE_MESSAGE_ID": {
                        this.meta.setDisableMessageId(item[1]);
                        break;
                    }
                    case "DISABLE_MESSAGE_TIMESTAMP": {
                        this.meta.setDisableMessageTimestamp(item[1]);
                        break;
                    }
                    case "DELIVERY_MODE": {
                        this.meta.setDeliveryMode(item[1]);
                        break;
                    }
                    case "PRIORITY": {
                        this.meta.setPriority(item[1]);
                        break;
                    }
                    case "TIME_TO_LIVE": {
                        this.meta.setTimeToLive(item[1]);
                        break;
                    }
                    case "DELIVERY_DELAY": {
                        this.meta.setDeliveryDelay(item[1]);
                        break;
                    }
                    case "JMS_CORRELATION_ID": {
                        this.meta.setJmsCorrelationId(item[1]);
                        break;
                    }
                    case "JMS_TYPE": {
                        this.meta.setJmsType(item[1]);
                        break;
                    }
                    default: {
                        this.log.logBasic(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Options.OptionNotFound", (String[])new String[]{option.getKey()}));
                    }
                }
            }
        }));
        return this.options;
    }

    public void setSize() {
        JmsProducerDialog.setSize((Shell)this.shell);
        this.shell.setMinimumSize(528, 670);
        this.shell.setSize(528, 670);
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private Image getImage() {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
        String id = plugin.getIds()[0];
        if (id != null) {
            return ((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(id)).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48);
        }
        return null;
    }
}

