/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.ui;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsConsumerMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

public class FieldsTab {
    public static final String STRING_DESC = ValueMetaBase.getTypeDesc((int)2);
    private CTabFolder wTabFolder;
    private PropsUI props;
    TableView fieldsTable;
    private VariableSpace transMeta;
    private ModifyListener lsMod;
    private String message;
    private String destination;
    private String messageId;
    private String jmsTimestamp;
    private String jmsRedelivered;

    public FieldsTab(CTabFolder wTabFolder, PropsUI props, VariableSpace transMeta, ModifyListener lsMod, JmsConsumerMeta jmsMeta) {
        this.wTabFolder = wTabFolder;
        this.props = props;
        this.transMeta = transMeta;
        this.lsMod = lsMod;
        this.message = jmsMeta.messageField;
        this.destination = jmsMeta.destinationField;
        this.messageId = jmsMeta.messageId;
        this.jmsTimestamp = jmsMeta.jmsTimestamp;
        this.jmsRedelivered = jmsMeta.jmsRedelivered;
    }

    public void buildFieldsTab() {
        Preconditions.checkArgument((this.wTabFolder.getItemCount() > 0 ? 1 : 0) != 0);
        CTabItem wFieldsTab = new CTabItem(this.wTabFolder, 0, this.wTabFolder.getItemCount() - 1);
        wFieldsTab.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.FieldsTab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        FormData fieldsFormData = new FormData();
        fieldsFormData.left = new FormAttachment(0, 0);
        fieldsFormData.top = new FormAttachment((Control)wFieldsComp, 0);
        fieldsFormData.right = new FormAttachment(100, 0);
        fieldsFormData.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fieldsFormData);
        this.buildFieldTable(wFieldsComp, (Control)wFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void buildFieldTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getFieldColumns();
        this.fieldsTable = new TableView(this.transMeta, parentWidget, 67586, columns, 5, true, this.lsMod, this.props, false);
        this.fieldsTable.setSortable(false);
        this.fieldsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(147);
            table.getColumn(2).setWidth(147);
            table.getColumn(3).setWidth(147);
        });
        this.populateFieldData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.right = new FormAttachment(100, 0);
        Arrays.stream(this.fieldsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.fieldsTable.setReadonly(true);
        this.fieldsTable.setLayoutData((Object)fdData);
    }

    private void populateFieldData() {
        TableItem messageItem = this.fieldsTable.getTable().getItem(0);
        messageItem.setText(1, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.InputName.Message", (String[])new String[0]));
        messageItem.setText(2, this.message);
        messageItem.setText(3, STRING_DESC);
        TableItem topicItem = this.fieldsTable.getTable().getItem(1);
        topicItem.setText(1, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.InputName.Destination", (String[])new String[0]));
        topicItem.setText(2, this.destination);
        topicItem.setText(3, STRING_DESC);
        TableItem messageIdItem = this.fieldsTable.getTable().getItem(2);
        messageIdItem.setText(1, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.InputName.MessageId", (String[])new String[0]));
        messageIdItem.setText(2, this.messageId);
        messageIdItem.setText(3, STRING_DESC);
        TableItem jmsTimestampIdItem = this.fieldsTable.getTable().getItem(3);
        jmsTimestampIdItem.setText(1, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.InputName.JMSTimestamp", (String[])new String[0]));
        jmsTimestampIdItem.setText(2, this.jmsTimestamp);
        jmsTimestampIdItem.setText(3, STRING_DESC);
        TableItem jmsRedeliveredItem = this.fieldsTable.getTable().getItem(4);
        jmsRedeliveredItem.setText(1, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.InputName.JMSRedelivered", (String[])new String[0]));
        jmsRedeliveredItem.setText(2, this.jmsRedelivered);
        jmsRedeliveredItem.setText(3, STRING_DESC);
    }

    private ColumnInfo[] getFieldColumns() {
        ColumnInfo referenceName = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.Column.Ref", (String[])new String[0]), 1, false, true);
        ColumnInfo name = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo type = new ColumnInfo(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsConsumerDialog.Column.Type", (String[])new String[0]), 1, false, true);
        return new ColumnInfo[]{referenceName, name, type};
    }
}

