/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.ui;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;
import org.pentaho.di.trans.step.jms.ui.ConnectionForm;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.BaseDialog;
import org.pentaho.di.ui.core.dialog.BaseMessageDialog;
import org.pentaho.di.ui.core.widget.CheckBoxTableCombo;

public class CheckBoxTableComboDefaultButton
extends CheckBoxTableCombo {
    private Button wUseDefaultCheckBox;
    private JmsProvider.ConnectionType selectedConnectionType;
    private Composite parentComposite;
    protected boolean errorDialogProceed = true;
    private ConnectionForm connectionForm;
    private static final String JAVAX_SSL_TRUSTSTORE_PATH = "javax.net.ssl.trustStore";
    private static final String JAVAX_SSL_TRUSTSTORE_PASS = "javax.net.ssl.trustStorePassword";
    private static final String JAVAX_SSL_KEYSTORE_PATH = "javax.net.ssl.keyStore";
    private static final String JAVAX_SSL_KEYSTORE_PASS = "javax.net.ssl.keyStorePassword";
    private static final String HTTPS_CIPHER_SUITES = "https.cipherSuites";

    public CheckBoxTableComboDefaultButton(Composite parentComposite, PropsUI props, final ModifyListener lsMod, TransMeta transMeta, Map<String, String> dataMap, final Consumer<JmsProvider.ConnectionType> toggleVisibilityCallback, JmsDelegate delegate) {
        super(parentComposite, props, lsMod, transMeta, dataMap, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSLButton", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSLTable", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.Column.Name", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.Column.Value", (String[])new String[0]), delegate.sslEnabled);
        this.parentComposite = parentComposite;
        this.wUseDefaultCheckBox = new Button(parentComposite, 32);
        this.wUseDefaultCheckBox.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_USE_DEFAULT", (String[])new String[0]));
        FormData fdCheckBox = new FormData();
        fdCheckBox.left = new FormAttachment((Control)this.wCheckBox, 10);
        this.wUseDefaultCheckBox.setLayoutData((Object)fdCheckBox);
        this.wUseDefaultCheckBox.setSelection(delegate.sslUseDefaultContext);
        this.wUseDefaultCheckBox.setEnabled(delegate.sslEnabled);
        this.selectedConnectionType = JmsProvider.ConnectionType.valueOf(delegate.connectionType);
        for (Listener l : this.wCheckBox.getListeners(13)) {
            if (!(l instanceof SelectionListener)) continue;
            this.wCheckBox.removeSelectionListener((SelectionListener)l);
        }
        this.wCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean selection = ((Button)selectionEvent.getSource()).getSelection();
                boolean proceed = true;
                if (selection) {
                    proceed = CheckBoxTableComboDefaultButton.this.checkCommandLineArgs();
                }
                if (proceed) {
                    CheckBoxTableComboDefaultButton.this.wUseDefaultCheckBox.setEnabled(selection);
                } else {
                    CheckBoxTableComboDefaultButton.this.wCheckBox.setSelection(false);
                    CheckBoxTableComboDefaultButton.this.wUseDefaultCheckBox.setEnabled(false);
                }
                lsMod.modifyText(null);
                CheckBoxTableComboDefaultButton.this.resetPropertyTableVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        this.wUseDefaultCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                toggleVisibilityCallback.accept(CheckBoxTableComboDefaultButton.this.selectedConnectionType);
                lsMod.modifyText(null);
                CheckBoxTableComboDefaultButton.this.resetPropertyTableVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    void setConnectionForm(ConnectionForm connectionForm) {
        this.connectionForm = connectionForm;
    }

    boolean getUseDefaultSslContext() {
        return this.wUseDefaultCheckBox.getSelection();
    }

    void setSelectedConnectionType(JmsProvider.ConnectionType type) {
        this.selectedConnectionType = type;
    }

    JmsProvider.ConnectionType getSelectedConnectionType() {
        return this.selectedConnectionType;
    }

    public void resetPropertyTableVisibility() {
        this.propertiesTable.setEnabled(this.wCheckBox.getSelection() && (this.selectedConnectionType.equals((Object)JmsProvider.ConnectionType.WEBSPHERE) || !this.wUseDefaultCheckBox.getSelection()));
        this.propertiesTable.table.setEnabled(this.wCheckBox.getSelection() && (this.selectedConnectionType.equals((Object)JmsProvider.ConnectionType.WEBSPHERE) || !this.wUseDefaultCheckBox.getSelection()));
    }

    public void addSelectionListenerToSslCheckbox(SelectionListener l) {
        this.wCheckBox.addSelectionListener(l);
    }

    protected boolean checkCommandLineArgs() {
        this.errorDialogProceed = true;
        if (null != this.connectionForm && JmsProvider.ConnectionType.ACTIVEMQ.equals((Object)JmsProvider.ConnectionType.valueOf(this.connectionForm.getConnectionType()))) {
            String arg;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            boolean showDialog = false;
            Iterator<String> iterator = runtimeMXBean.getInputArguments().iterator();
            while (iterator.hasNext() && !(showDialog = (arg = iterator.next()).contains(JAVAX_SSL_KEYSTORE_PASS) || arg.contains(JAVAX_SSL_KEYSTORE_PATH) || arg.contains(JAVAX_SSL_TRUSTSTORE_PASS) || arg.contains(JAVAX_SSL_TRUSTSTORE_PATH) || arg.contains(HTTPS_CIPHER_SUITES))) {
            }
            if (showDialog) {
                this.errorDialogProceed = false;
                BaseMessageDialog errorDlg = new BaseMessageDialog(this.parentComposite.getShell(), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.ACTIVEMQ_COMMAND_LINE_ARGS_MISMATCH_TITLE", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.ACTIVEMQ_COMMAND_LINE_ARGS_MISMATCH_MSG", (String[])new String[0]), 350);
                HashMap<String, Listener> buttons = new HashMap<String, Listener>();
                buttons.put(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.ACTIVEMQ_COMMAND_LINE_ARGS_MISMATCH_YES", (String[])new String[0]), arg_0 -> this.lambda$checkCommandLineArgs$0((BaseDialog)errorDlg, arg_0));
                buttons.put(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.ACTIVEMQ_COMMAND_LINE_ARGS_MISMATCH_NO", (String[])new String[0]), arg_0 -> this.lambda$checkCommandLineArgs$1((BaseDialog)errorDlg, arg_0));
                errorDlg.setButtons(buttons);
                errorDlg.open();
            }
        }
        return this.errorDialogProceed;
    }

    private /* synthetic */ void lambda$checkCommandLineArgs$1(BaseDialog errorDlg, Event event) {
        errorDlg.dispose();
        this.errorDialogProceed = false;
    }

    private /* synthetic */ void lambda$checkCommandLineArgs$0(BaseDialog errorDlg, Event event) {
        errorDlg.dispose();
        this.errorDialogProceed = true;
    }
}

