/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.getfields.types.json.node;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.getfields.types.json.node.ArrayNode;
import org.pentaho.getfields.types.json.node.Node;

public class ObjectNode
extends Node {
    public static final String TYPE = "Object";
    private List<Node> children = new ArrayList<Node>();

    public ObjectNode(String key) {
        super(key);
    }

    public void addValue(Node value) {
        this.children.add(value);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public void dedupe() {
        for (Node node : this.children) {
            node.dedupe();
        }
    }

    public boolean containsKey(String key) {
        return this.children.stream().anyMatch(node -> node.getKey().equals(key));
    }

    public Node getByKey(String key) {
        return this.children.stream().filter(node -> node.getKey().equals(key)).findFirst().orElse(null);
    }

    public void combine(ObjectNode secondNode) {
        for (Node node : secondNode.getChildren()) {
            if (!this.containsKey(node.getKey())) {
                this.addValue(node);
            }
            if (node instanceof ObjectNode) {
                ObjectNode objectNode1 = (ObjectNode)this.getByKey(node.getKey());
                ObjectNode objectNode2 = (ObjectNode)node;
                objectNode1.combine(objectNode2);
            }
            if (!(node instanceof ArrayNode)) continue;
            ArrayNode arrayNode1 = (ArrayNode)this.getByKey(node.getKey());
            ArrayNode arrayNode2 = (ArrayNode)node;
            arrayNode1.combine(arrayNode2);
            arrayNode1.dedupe();
        }
    }

    public String toString() {
        String output = "";
        output = this.getKey() != null ? output + this.getKey() + ": {\n" : "{\n";
        for (Node node : this.children) {
            output = output + node.toString();
        }
        return output + "},\n";
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

