/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.getfields.types.json.node;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.getfields.types.json.node.Node;
import org.pentaho.getfields.types.json.node.ObjectNode;

public class ArrayNode
extends Node {
    public static final String TYPE = "Array";
    private List<Node> children = new ArrayList<Node>();

    public ArrayNode(String key) {
        super(key);
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void combine(ArrayNode arrayNode) {
        Node node;
        int i;
        ObjectNode objectNode = new ObjectNode(null);
        ArrayNode arrayNode1 = new ArrayNode(null);
        for (i = 0; i < arrayNode.getChildren().size(); ++i) {
            node = arrayNode.getChildren().get(i);
            if (node instanceof ObjectNode) {
                objectNode.setKey(node.getKey());
                objectNode.combine((ObjectNode)node);
            }
            if (!(node instanceof ArrayNode)) continue;
            arrayNode1.combine((ArrayNode)node);
        }
        for (i = 0; i < this.children.size(); ++i) {
            node = this.children.get(i);
            if (node instanceof ObjectNode) {
                objectNode.combine((ObjectNode)node);
            }
            if (!(node instanceof ArrayNode)) continue;
            arrayNode1.combine((ArrayNode)node);
        }
        if (objectNode.getKey() != null || objectNode.hasChildren()) {
            this.children.add(objectNode);
        }
        if (arrayNode1.hasChildren()) {
            this.children.add(arrayNode1);
        }
    }

    @Override
    public void dedupe() {
        ObjectNode objectNode = new ObjectNode(null);
        ArrayNode arrayNode = new ArrayNode(null);
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = this.children.get(i);
            if (child instanceof ObjectNode) {
                objectNode.setKey(child.getKey());
                objectNode.combine((ObjectNode)child);
            }
            if (!(child instanceof ArrayNode)) continue;
            arrayNode.combine((ArrayNode)child);
        }
        this.children.clear();
        if (objectNode.getChildren().size() > 0) {
            this.children.add(objectNode);
        }
        if (arrayNode.getChildren().size() > 0) {
            arrayNode.dedupe();
            this.children.add(arrayNode);
        }
    }

    public String toString() {
        String output = "";
        output = this.key != null ? output + this.key + ": [\n" : "[\n";
        for (Node child : this.children) {
            output = output + child.toString();
        }
        return output + "],\n";
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

