/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.getfields.types.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.getfields.types.json.Configuration;
import org.pentaho.getfields.types.json.node.ArrayNode;
import org.pentaho.getfields.types.json.node.Node;
import org.pentaho.getfields.types.json.node.ObjectNode;
import org.pentaho.getfields.types.json.node.ValueNode;

public class JsonSampler {
    private int start = 0;
    private Configuration configuration;
    private JsonFactory jsonFactory = new MappingJsonFactory();

    public JsonSampler(Configuration configuration) {
        this.configuration = configuration;
    }

    public JsonSampler() {
        this.configuration = new Configuration();
    }

    private Node sample(JsonParser jsonParser) throws IOException {
        jsonParser.enable(JsonParser.Feature.ALLOW_COMMENTS);
        Node node = null;
        while (jsonParser.nextToken() != null) {
            if (jsonParser.currentToken() == JsonToken.START_ARRAY) {
                node = new ArrayNode(null);
                this.sampleArray(jsonParser, (ArrayNode)node);
            }
            if (jsonParser.currentToken() == JsonToken.START_OBJECT) {
                node = new ObjectNode(null);
                this.sampleObject(jsonParser, (ObjectNode)node);
            }
            if (this.start <= this.configuration.getLines()) continue;
        }
        if (node != null && this.configuration.isDedupe()) {
            node.dedupe();
        }
        return node;
    }

    public Node sample(InputStream inputStream) throws IOException {
        try (JsonParser jsonParser = this.jsonFactory.createParser(inputStream);){
            Node node = this.sample(jsonParser);
            return node;
        }
    }

    public Node sample(String file) throws IOException, KettleFileException {
        return this.sample(KettleVFS.getInputStream((String)file));
    }

    private void sampleArray(JsonParser jsonParser, ArrayNode arrayNode) throws IOException {
        ++this.start;
        if (this.start > this.configuration.getLines()) {
            return;
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            if (this.start > this.configuration.getLines()) {
                return;
            }
            Node node = this.getValue(jsonParser, null);
            arrayNode.addChild(node);
            if (node instanceof ObjectNode) {
                this.sampleObject(jsonParser, (ObjectNode)node);
            }
            if (!(node instanceof ArrayNode)) continue;
            this.sampleArray(jsonParser, (ArrayNode)node);
        }
    }

    private void sampleObject(JsonParser jsonParser, ObjectNode objectNode) throws IOException {
        ++this.start;
        if (this.start > this.configuration.getLines()) {
            return;
        }
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            if (this.start > this.configuration.getLines()) {
                return;
            }
            if (jsonParser.currentToken() != JsonToken.FIELD_NAME) continue;
            String name = jsonParser.getCurrentName();
            jsonParser.nextToken();
            Node node = this.getValue(jsonParser, name);
            if (node instanceof ObjectNode) {
                this.sampleObject(jsonParser, (ObjectNode)node);
            }
            if (node instanceof ArrayNode) {
                this.sampleArray(jsonParser, (ArrayNode)node);
            }
            objectNode.addValue(node);
        }
    }

    private Node getValue(JsonParser jsonParser, String key) {
        try {
            switch (jsonParser.currentToken()) {
                case START_OBJECT: {
                    return new ObjectNode(key);
                }
                case START_ARRAY: {
                    return new ArrayNode(key);
                }
                case VALUE_STRING: {
                    return new ValueNode<String>(key, jsonParser.getValueAsString());
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return new ValueNode<Boolean>(key, jsonParser.getValueAsBoolean());
                }
                case VALUE_NULL: {
                    return new ValueNode<Object>(key, null);
                }
                case VALUE_NUMBER_FLOAT: {
                    return new ValueNode<Double>(key, jsonParser.getValueAsDouble());
                }
                case VALUE_NUMBER_INT: {
                    return new ValueNode<BigInteger>(key, jsonParser.getBigIntegerValue());
                }
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return null;
    }
}

