/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.getfields.endpoint;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.getfields.types.json.JsonSampler;
import org.pentaho.getfields.types.json.node.Node;

public class GetFieldsEndpoint {
    private static final String JSON = "json";

    @GET
    @Path(value="/sample/{path}/{type}")
    @Produces(value={"application/json"})
    public Response loadFile(@PathParam(value="path") String path, @PathParam(value="type") String type) {
        switch (type) {
            case "json": {
                return this.loadJson(path);
            }
        }
        return null;
    }

    private Response loadJson(String path) {
        JsonSampler jsonSampler = new JsonSampler();
        Node node = null;
        try {
            node = jsonSampler.sample(path);
        }
        catch (KettleFileException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return Response.ok((Object)node).build();
    }
}

