/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.codegen.ConnectionMetadataConstructor;
import com.sforce.ws.codegen.FactoryMetadataConstructor;
import com.sforce.ws.codegen.Generator;
import com.sforce.ws.codegen.metadata.ConnectionClassMetadata;
import com.sforce.ws.codegen.metadata.ConnectionWrapperClassMetadata;
import com.sforce.ws.codegen.metadata.ConnectorMetadata;
import com.sforce.ws.codegen.metadata.FactoryClassMetadata;
import com.sforce.ws.tools.ToolsException;
import com.sforce.ws.util.FileUtil;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.SfdcApiType;
import com.sforce.ws.wsdl.Types;
import com.sforce.ws.wsdl.WsdlParseException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupDir;

public class wsdlc
extends Generator {
    private static final String CONNECTOR_JAVA = "Connector.java";
    public static final String TEMPLATE_DIR = String.format("%s/templates", Generator.class.getPackage().getName().replace('.', '/'));
    static final String STANDALONE_JAR = "standalone-jar";
    static final String PACKAGE_PREFIX = "package-prefix";
    static final String JAVA_TIME = "java-time";
    public static final String CONNECTION = "connection";
    public static final String CONNECTOR = "connector";
    public static final String CONNECTION_WRAPPER = "connectionWrapper";
    public static final String INTERFACE_CONNECTION_WRAPPER = "iconnectionWrapper";
    public static final String FACTORY = "factory";
    public static final String IFACTORY = "ifactory";

    public static void main(String[] args) throws Exception {
        try {
            wsdlc.run(args);
        }
        catch (ToolsException e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String wsdlUrl, String destJarFilename, String packagePrefix, boolean javaTime, boolean standAlone, STGroupDir templates, String destDir, boolean compile) throws ToolsException, WsdlParseException, IOException {
        File destDirectory;
        URL wsdl;
        wsdlc wsc = new wsdlc(packagePrefix, templates, javaTime);
        File destJar = new File(destJarFilename);
        if (destJar.exists() && !destJar.delete()) {
            throw new ToolsException(String.format("Output Jar file exists and cannot be deleted: %s", destJar.getAbsolutePath()));
        }
        if (!(destJar.getParentFile() == null || destJar.getParentFile().exists() || destJar.getParentFile().mkdirs() || destJar.getParentFile().exists())) {
            throw new ToolsException(String.format("Cannot create jar file directory: %s", destJar.getParentFile().getAbsolutePath()));
        }
        try {
            wsdl = new URL(wsdlUrl);
        }
        catch (MalformedURLException e) {
            try {
                wsdl = new URL(String.format("file:%s", wsdlUrl));
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
        if (destDir == null) {
            destDirectory = File.createTempFile("wsc-scratch", "tmp");
            FileUtil.deleteDir(destDirectory);
        } else {
            destDirectory = new File(destDir);
        }
        destDirectory.mkdirs();
        try {
            wsc.generate(wsdl, destDirectory);
            if (compile) {
                wsc.compileTypes();
                wsc.generateJarFile(destJar, standAlone, destDirectory);
            }
        }
        finally {
            if (destDir == null) {
                FileUtil.deleteDir(destDirectory);
            }
        }
    }

    static void run(String[] args) throws Exception {
        if (args.length < 2 || args.length > 4) {
            throw new ToolsException(" usage: java com.sforce.ws.tools.wsdlc -nc <wsdl-file> <jar-file> <dest-dir>");
        }
        boolean compile = true;
        String destJarFilename = null;
        String wsdlUrl = null;
        String destDir = null;
        for (String arg : args) {
            if (arg.equals("-nc")) {
                compile = false;
                continue;
            }
            if (wsdlUrl == null) {
                wsdlUrl = arg;
                continue;
            }
            if (destJarFilename == null) {
                destJarFilename = arg;
                continue;
            }
            if (destDir == null) {
                destDir = arg;
                continue;
            }
            throw new ToolsException(" usage: java com.sforce.ws.tools.wsdlc -nc <wsdl-file> <jar-file> <dest-dir>");
        }
        String packagePrefix = System.getProperty(PACKAGE_PREFIX);
        boolean standAlone = Boolean.parseBoolean(System.getProperty(STANDALONE_JAR, "false"));
        boolean javaTime = Boolean.parseBoolean(System.getProperty(JAVA_TIME, "false"));
        STGroupDir stGroupDir = new STGroupDir(TEMPLATE_DIR, '$', '$');
        wsdlc.run(wsdlUrl, destJarFilename, packagePrefix, javaTime, standAlone, stGroupDir, destDir, compile);
    }

    public wsdlc(String packagePrefix, STGroupDir templates, boolean javaTime) {
        super(packagePrefix, templates, packagePrefix, javaTime);
    }

    public wsdlc(String packagePrefix, STGroupDir templates) {
        super(packagePrefix, templates, packagePrefix, false);
    }

    private void generateConnectionClasses(Definitions definitions, File dir) throws IOException {
        ConnectionClassMetadata gen = new ConnectionMetadataConstructor(definitions, this.typeMapper, this.packagePrefix).getConnectionClassMetadata();
        ST template = this.templates.getInstanceOf(CONNECTION);
        this.javaFiles.add(this.generate(gen.getPackageName(), gen.getClassName() + ".java", gen, template, dir));
    }

    private void generateConnectionWrapperClasses(Definitions definitions, File dir) throws IOException {
        ConnectionClassMetadata connectionMetadata = new ConnectionMetadataConstructor(definitions, this.typeMapper, this.packagePrefix).getConnectionClassMetadata();
        ConnectionWrapperClassMetadata gen = new ConnectionWrapperClassMetadata(connectionMetadata.getPackageName(), connectionMetadata.getClassName() + "Wrapper", null, connectionMetadata);
        ST template = this.templates.getInstanceOf(CONNECTION_WRAPPER);
        File wrapperFile = this.generate(gen.getPackageName(), gen.getClassName() + ".java", gen, template, dir);
        this.javaFiles.add(wrapperFile);
        template = this.templates.getInstanceOf(INTERFACE_CONNECTION_WRAPPER);
        this.javaFiles.add(this.generate(gen.getPackageName(), gen.getInterfaceName() + ".java", gen, template, dir));
    }

    private void generateFactoryClasses(Definitions definitions, File dir) throws IOException {
        FactoryClassMetadata gen = new FactoryMetadataConstructor(definitions, this.typeMapper, this.packagePrefix).getFactoryClassMetadata();
        ST template = this.templates.getInstanceOf(FACTORY);
        this.javaFiles.add(this.generate(gen.getPackageName(), gen.getClassName() + ".java", gen, template, dir));
        template = this.templates.getInstanceOf(IFACTORY);
        this.javaFiles.add(this.generate(gen.getPackageName(), gen.getInterfaceName() + ".java", gen, template, dir));
    }

    private void generateConnectorClasses(Definitions definitions, File dir) throws IOException {
        ConnectorMetadata gen = new ConnectorMetadata(definitions, this.packagePrefix);
        ST template = this.templates.getInstanceOf(CONNECTOR);
        this.javaFiles.add(this.generate(gen.getPackageName(), CONNECTOR_JAVA, gen, template, dir));
    }

    @Override
    protected void generate(Definitions definitions, SfdcApiType sfdcApiType, Types types, File dir) throws IOException {
        super.generate(definitions, sfdcApiType, types, dir);
        this.generateConnectionClasses(definitions, dir);
        this.generateConnectorClasses(definitions, dir);
        if (this.generateInterfaces) {
            this.generateConnectionWrapperClasses(definitions, dir);
            this.generateFactoryClasses(definitions, dir);
        }
    }
}

