/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.hbase.mapping;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;

public interface ColumnFilter {
    public String getFieldAlias();

    public void setFieldAlias(String var1);

    public String getFieldType();

    public void setFieldType(String var1);

    public ComparisonType getComparisonOperator();

    public void setComparisonOperator(ComparisonType var1);

    public boolean getSignedComparison();

    public void setSignedComparison(boolean var1);

    public String getConstant();

    public void setConstant(String var1);

    public String getFormat();

    public void setFormat(String var1);

    public void appendXML(StringBuilder var1);

    public void saveRep(Repository var1, ObjectId var2, ObjectId var3, int var4) throws KettleException;

    public static enum ComparisonType {
        EQUAL("="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        NOT_EQUAL("!="),
        SUBSTRING("Substring"),
        REGEX("Regular expression"),
        PREFIX("Starts from");

        private final String m_stringVal;

        private ComparisonType(String name) {
            this.m_stringVal = name;
        }

        public static String[] getAllOperators() {
            return new String[]{EQUAL.toString(), NOT_EQUAL.toString(), GREATER_THAN.toString(), GREATER_THAN_OR_EQUAL.toString(), LESS_THAN.toString(), LESS_THAN_OR_EQUAL.toString(), SUBSTRING.toString(), PREFIX.toString(), REGEX.toString()};
        }

        public static String[] getStringOperators() {
            return new String[]{SUBSTRING.toString(), PREFIX.toString(), REGEX.toString()};
        }

        public static String[] getNumericOperators() {
            return new String[]{EQUAL.toString(), NOT_EQUAL.toString(), GREATER_THAN.toString(), GREATER_THAN_OR_EQUAL.toString(), LESS_THAN.toString(), LESS_THAN_OR_EQUAL.toString()};
        }

        public static ComparisonType stringToOpp(String opp) {
            for (ComparisonType comparisonType : ComparisonType.values()) {
                if (!comparisonType.toString().equals(opp)) continue;
                return comparisonType;
            }
            return null;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

