/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.ILockObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IRevisionObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectRevision;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectRevisions;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorerCallback;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.BrowseController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTab;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.custom.DialogConstant;
import org.pentaho.ui.xul.swt.tags.SwtConfirmBox;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class RevisionController
extends AbstractXulEventHandler
implements IUISupportController,
Serializable {
    private static final long serialVersionUID = 4072800373062217146L;
    private static final Class<?> PKG = IUIEEUser.class;
    private static final String OPEN_REVISION_BUTTON = "revision-open";
    private static final String RESTORE_REVISION_BUTTON = "revision-restore";
    protected XulTree folderTree;
    protected XulTree fileTable;
    protected XulTab historyTab;
    protected Repository repository;
    protected XulTree revisionTable;
    protected MainController mainController;
    protected BrowseController browseController;
    protected BindingFactory bf;
    protected XulTabbox filePropertiesTabbox;
    protected RepositoryExplorerCallback callback;
    protected UIRepositoryObjectRevisions revisions;
    protected Binding revisionBinding;
    protected boolean masterVersioningEnabled = true;
    protected boolean masterCommentsEnabled = true;
    private XulMessageBox messageBox;
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };

    public void init(Repository repository) throws ControllerInitializationException {
        block2: {
            try {
                this.repository = repository;
                this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
                this.browseController = (BrowseController)this.getXulDomContainer().getEventHandler("browseController");
                this.bf = new DefaultBindingFactory();
                this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
                this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
                this.createBindings();
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block2;
                throw new ControllerInitializationException((Throwable)e);
            }
        }
    }

    private void createBindings() {
        block2: {
            this.filePropertiesTabbox = (XulTabbox)this.document.getElementById("file-properties-tabs");
            this.historyTab = (XulTab)this.document.getElementById("history");
            this.revisionTable = (XulTree)this.document.getElementById("revision-table");
            this.folderTree = (XulTree)this.document.getElementById("folder-tree");
            this.fileTable = (XulTree)this.document.getElementById("file-table");
            this.historyTab.setVisible(false);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            BindingConvertor<int[], Boolean> forButtons = new BindingConvertor<int[], Boolean>(){

                public Boolean sourceToTarget(int[] value) {
                    return value != null && value.length > 0;
                }

                public int[] targetToSource(Boolean value) {
                    return null;
                }
            };
            Binding openButtonBinding = this.bf.createBinding((Object)this.revisionTable, "selectedRows", OPEN_REVISION_BUTTON, "!disabled", new BindingConvertor[]{forButtons});
            Binding restoreButtonBinding = this.bf.createBinding((Object)this.revisionTable, "selectedRows", RESTORE_REVISION_BUTTON, "!disabled", new BindingConvertor[]{forButtons});
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.folderTree, "selectedItems", (Object)this, "historyTabVisibility", new BindingConvertor[0]);
            this.revisionBinding = this.bf.createBinding((Object)this, "revisionObjects", (Object)this.revisionTable, "elements", new BindingConvertor[0]);
            this.revisionBinding = this.bf.createBinding((Object)this.browseController, "repositoryItems", (Object)this, "revisionObjects", new BindingConvertor[]{new BindingConvertor<List<UIRepositoryObject>, UIRepositoryObjectRevisions>(){

                private void disableButtons() {
                    RevisionController.this.document.getElementById(RevisionController.OPEN_REVISION_BUTTON).setDisabled(true);
                    RevisionController.this.document.getElementById(RevisionController.RESTORE_REVISION_BUTTON).setDisabled(true);
                }

                public UIRepositoryObjectRevisions sourceToTarget(List<UIRepositoryObject> ro) {
                    UIRepositoryObjectRevisions revisions;
                    block7: {
                        if (ro == null || ro.isEmpty() || !RevisionController.this.masterVersioningEnabled) {
                            return new UIRepositoryObjectRevisions();
                        }
                        if (ro.get(0) instanceof UIRepositoryDirectory) {
                            RevisionController.this.historyTab.setVisible(false);
                            RevisionController.this.filePropertiesTabbox.setSelectedIndex(0);
                            this.disableButtons();
                            return null;
                        }
                        revisions = null;
                        try {
                            UIRepositoryContent rc = (UIRepositoryContent)ro.get(0);
                            if (rc instanceof IRevisionObject) {
                                Boolean versioningEnabled = ((IRevisionObject)rc).getVersioningEnabled();
                                RevisionController.this.historyTab.setVisible(versioningEnabled.booleanValue());
                                if (!versioningEnabled.booleanValue()) {
                                    return new UIRepositoryObjectRevisions();
                                }
                            } else {
                                throw new IllegalStateException(BaseMessages.getString((Class)PKG, (String)"RevisionsController.RevisionsNotSupported", (String[])new String[0]));
                            }
                            Boolean versionCommentEnabled = ((IRevisionObject)rc).getVersionCommentEnabled();
                            RevisionController.this.setRevisionTableColumns(versionCommentEnabled);
                            revisions = ((IRevisionObject)rc).getRevisions();
                        }
                        catch (KettleException e) {
                            if (RevisionController.this.mainController != null && RevisionController.this.mainController.handleLostRepository((Throwable)e)) break block7;
                            throw new RuntimeException(e);
                        }
                    }
                    return revisions;
                }

                public List<UIRepositoryObject> targetToSource(UIRepositoryObjectRevisions elements) {
                    return null;
                }
            }});
            try {
                openButtonBinding.fireSourceChanged();
                restoreButtonBinding.fireSourceChanged();
                this.revisionBinding.fireSourceChanged();
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public void setRevisionObjects(UIRepositoryObjectRevisions revisions) {
        this.revisions = revisions;
        this.firePropertyChange("revisionObjects", null, revisions);
    }

    public UIRepositoryObjectRevisions getRevisionObjects() {
        return this.revisions;
    }

    public String getName() {
        return "revisionController";
    }

    public <T> void setHistoryTabVisibility(Collection<T> items) {
        this.historyTab.setVisible(false);
        this.filePropertiesTabbox.setSelectedIndex(0);
    }

    public RepositoryExplorerCallback getCallback() {
        return this.callback;
    }

    public void setCallback(RepositoryExplorerCallback callback) {
        this.callback = callback;
    }

    public void openRevision() {
        block3: {
            Collection content = this.fileTable.getSelectedItems();
            UIRepositoryContent contentToOpen = (UIRepositoryContent)content.iterator().next();
            Collection revision = this.revisionTable.getSelectedItems();
            UIRepositoryObjectRevision revisionToOpen = (UIRepositoryObjectRevision)revision.iterator().next();
            if (this.mainController != null && this.mainController.getCallback() != null) {
                try {
                    this.mainController.getCallback().open(contentToOpen, revisionToOpen.getName());
                }
                catch (Exception e) {
                    if (this.mainController == null) break block3;
                    this.mainController.handleLostRepository((Throwable)e);
                }
            }
        }
    }

    public void restoreRevision() {
        block3: {
            try {
                Collection content = this.fileTable.getSelectedItems();
                final UIRepositoryContent contentToRestore = (UIRepositoryContent)content.iterator().next();
                Collection versions = this.revisionTable.getSelectedItems();
                final UIRepositoryObjectRevision versionToRestore = (UIRepositoryObjectRevision)versions.iterator().next();
                SwtConfirmBox confirmbox = this.promptCommitComment(this.document);
                if (contentToRestore instanceof ILockObject && ((ILockObject)contentToRestore).isLocked()) {
                    this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"RevisionsController.RestoreLockedFileNotAllowed", (String[])new String[0]));
                    this.messageBox.open();
                    return;
                }
                confirmbox.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

                    public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                        block4: {
                            if (!status.equals((Object)XulDialogCallback.Status.CANCEL)) {
                                try {
                                    if (!(contentToRestore instanceof IRevisionObject)) {
                                        throw new IllegalStateException(BaseMessages.getString((Class)PKG, (String)"RevisionsController.RevisionsNotSupported", (String[])new String[0]));
                                    }
                                    ((IRevisionObject)contentToRestore).restoreRevision(versionToRestore, value);
                                    ArrayList<UIRepositoryContent> objects = new ArrayList<UIRepositoryContent>();
                                    objects.add(contentToRestore);
                                    RevisionController.this.browseController.setRepositoryObjects(objects);
                                }
                                catch (Exception e) {
                                    if (RevisionController.this.mainController != null && RevisionController.this.mainController.handleLostRepository((Throwable)e)) break block4;
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }

                    public void onError(XulComponent component, Throwable err) {
                        if (RevisionController.this.mainController == null || !RevisionController.this.mainController.handleLostRepository(err)) {
                            throw new RuntimeException(err);
                        }
                    }
                });
                confirmbox.open();
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block3;
                throw new RuntimeException(new KettleException((Throwable)e));
            }
        }
    }

    private SwtConfirmBox promptCommitComment(Document document) throws XulException {
        SwtConfirmBox confirmbox = (SwtConfirmBox)document.createElement("confirmbox");
        confirmbox.setTitle(BaseMessages.getString(PKG, (String)"RepositoryExplorer.CommitTitle", (String[])new String[0]));
        confirmbox.setButtons((Object[])new DialogConstant[]{DialogConstant.OK, DialogConstant.CANCEL});
        confirmbox.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorer.CommitLabel", (String[])new String[0]));
        return confirmbox;
    }

    private void setRevisionTableColumns(Boolean versionCommentEnabled) {
        if (versionCommentEnabled.booleanValue()) {
            this.revisionTable.getColumns().getColumn(2).setHidden(false);
        } else {
            this.revisionTable.getColumns().getColumn(2).setHidden(true);
        }
    }
}

