/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IAclObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.controller.PermissionsCheckboxHandler;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcl;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAclModel;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcls;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.util.XulDialogCallback;

public abstract class AbstractPermissionsController
extends AbstractXulEventHandler {
    private static final Class<?> PKG = IUIEEUser.class;
    protected BindingFactory bf;
    protected XulMessageBox messageBox;
    protected XulConfirmBox confirmBox;
    protected XulListbox userRoleList;
    protected XulListbox availableUserList;
    protected XulListbox availableRoleList;
    protected XulListbox selectedUserList;
    protected XulListbox selectedRoleList;
    protected XulCheckbox writeCheckbox;
    protected XulCheckbox readCheckbox;
    protected XulCheckbox manageAclCheckbox;
    protected XulCheckbox deleteCheckbox;
    protected XulButton addAclButton;
    protected XulButton removeAclButton;
    protected XulDialog manageAclsDialog;
    protected XulButton assignUserButton;
    protected XulButton unassignUserButton;
    protected XulButton assignRoleButton;
    protected XulButton unassignRoleButton;
    protected XulButton applyAclButton;
    protected Binding securityBinding;
    protected UIRepositoryObjectAcls viewAclsModel;
    protected UIRepositoryObjectAclModel manageAclsModel;
    protected RepositorySecurityProvider service;
    protected MainController mainController;
    protected PermissionsCheckboxHandler permissionsCheckboxHandler;
    protected ContextChangeVetoer.TYPE returnType;

    protected abstract List<? extends Object> getSelectedObjects();

    protected void init(Repository rep) throws Exception {
        if (rep == null || !rep.hasService(RepositorySecurityProvider.class)) {
            throw new ControllerInitializationException(BaseMessages.getString(PKG, (String)"PermissionsController.ERROR_0001_UNABLE_TO_INITIAL_REPOSITORY_SERVICE", RepositorySecurityManager.class, (String[])new String[0]));
        }
        this.service = (RepositorySecurityProvider)rep.getService(RepositorySecurityProvider.class);
        this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
        this.viewAclsModel = new UIRepositoryObjectAcls();
        this.manageAclsModel = new UIRepositoryObjectAclModel(this.viewAclsModel);
        this.bf = new DefaultBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
        this.confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
        this.confirmBox.setTitle(BaseMessages.getString(PKG, (String)"PermissionsController.RemoveAclWarning", (String[])new String[0]));
        this.confirmBox.setMessage(BaseMessages.getString(PKG, (String)"PermissionsController.RemoveAclWarningText", (String[])new String[0]));
        this.confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
        this.confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
        this.confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

            public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                if (returnCode == XulDialogCallback.Status.ACCEPT) {
                    AbstractPermissionsController.this.viewAclsModel.removeSelectedAcls();
                }
            }

            public void onError(XulComponent sender, Throwable t) {
            }
        });
    }

    protected String getXulPrefix() {
        return "";
    }

    protected void createBindings() {
        this.userRoleList = (XulListbox)this.document.getElementById(this.getXulPrefix() + "user-role-list");
        this.writeCheckbox = (XulCheckbox)this.document.getElementById(this.getXulPrefix() + "write-checkbox");
        this.readCheckbox = (XulCheckbox)this.document.getElementById(this.getXulPrefix() + "read-checkbox");
        this.manageAclCheckbox = (XulCheckbox)this.document.getElementById(this.getXulPrefix() + "manage-checkbox");
        this.deleteCheckbox = (XulCheckbox)this.document.getElementById(this.getXulPrefix() + "delete-checkbox");
        this.addAclButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "add-acl-button");
        this.removeAclButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "remove-acl-button");
        this.manageAclsDialog = (XulDialog)this.document.getElementById(this.getXulPrefix() + "manage-acls-dialog");
        this.permissionsCheckboxHandler = new PermissionsCheckboxHandler(this.readCheckbox, this.writeCheckbox, this.deleteCheckbox, this.manageAclCheckbox);
        this.availableUserList = (XulListbox)this.document.getElementById(this.getXulPrefix() + "available-user-list");
        this.selectedUserList = (XulListbox)this.document.getElementById(this.getXulPrefix() + "selected-user-list");
        this.availableRoleList = (XulListbox)this.document.getElementById(this.getXulPrefix() + "available-role-list");
        this.selectedRoleList = (XulListbox)this.document.getElementById(this.getXulPrefix() + "selected-role-list");
        this.assignRoleButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "assign-role");
        this.unassignRoleButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "unassign-role");
        this.assignUserButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "assign-user");
        this.unassignUserButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "unassign-user");
        this.applyAclButton = (XulButton)this.document.getElementById(this.getXulPrefix() + "apply-acl");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.manageAclsModel, "availableUserList", (Object)this.availableUserList, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.manageAclsModel, "selectedUserList", (Object)this.selectedUserList, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.manageAclsModel, "availableRoleList", (Object)this.availableRoleList, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.manageAclsModel, "selectedRoleList", (Object)this.selectedRoleList, "elements", new BindingConvertor[0]);
        BindingConvertor<int[], List<UIRepositoryObjectAcl>> indicesToObjectsConverter = new BindingConvertor<int[], List<UIRepositoryObjectAcl>>(){

            public int[] targetToSource(List<UIRepositoryObjectAcl> acls) {
                if (acls != null) {
                    int i = 0;
                    int[] retVal = new int[acls.size()];
                    for (UIRepositoryObjectAcl acl : acls) {
                        retVal[i++] = AbstractPermissionsController.this.viewAclsModel.getAceIndex(acl.getAce());
                    }
                    return retVal;
                }
                return null;
            }

            public List<UIRepositoryObjectAcl> sourceToTarget(int[] indices) {
                if (indices != null && indices.length > 0) {
                    ArrayList<UIRepositoryObjectAcl> retVal = new ArrayList<UIRepositoryObjectAcl>();
                    for (int i = 0; i < indices.length; ++i) {
                        retVal.add(new UIRepositoryObjectAcl(AbstractPermissionsController.this.viewAclsModel.getAceAtIndex(indices[i])));
                    }
                    return retVal;
                }
                return null;
            }
        };
        BindingConvertor<int[], List<String>> indexToAvailableUserConverter = new BindingConvertor<int[], List<String>>(){

            public List<String> sourceToTarget(int[] indices) {
                ArrayList<String> userList = new ArrayList<String>();
                for (int i = 0; i < indices.length; ++i) {
                    userList.add(AbstractPermissionsController.this.manageAclsModel.getAvailableUser(indices[i]));
                }
                return userList;
            }

            public int[] targetToSource(List<String> userList) {
                int[] indices = new int[userList.size()];
                int i = 0;
                for (String user : userList) {
                    indices[i++] = AbstractPermissionsController.this.manageAclsModel.getAvailableUserIndex(user);
                }
                return indices;
            }
        };
        BindingConvertor<int[], List<String>> indexToAvailableRoleConverter = new BindingConvertor<int[], List<String>>(){

            public List<String> sourceToTarget(int[] indices) {
                ArrayList<String> roleList = new ArrayList<String>();
                for (int i = 0; i < indices.length; ++i) {
                    roleList.add(AbstractPermissionsController.this.manageAclsModel.getAvailableRole(indices[i]));
                }
                return roleList;
            }

            public int[] targetToSource(List<String> roleList) {
                int[] indices = new int[roleList.size()];
                int i = 0;
                for (String role : roleList) {
                    indices[i++] = AbstractPermissionsController.this.manageAclsModel.getAvailableRoleIndex(role);
                }
                return indices;
            }
        };
        BindingConvertor<int[], List<UIRepositoryObjectAcl>> indexToSelectedUserConverter = new BindingConvertor<int[], List<UIRepositoryObjectAcl>>(){

            public List<UIRepositoryObjectAcl> sourceToTarget(int[] indices) {
                ArrayList<UIRepositoryObjectAcl> userList = new ArrayList<UIRepositoryObjectAcl>();
                for (int i = 0; i < indices.length; ++i) {
                    userList.add(AbstractPermissionsController.this.manageAclsModel.getSelectedUser(indices[i]));
                }
                return userList;
            }

            public int[] targetToSource(List<UIRepositoryObjectAcl> userList) {
                int[] indices = new int[userList.size()];
                int i = 0;
                for (UIRepositoryObjectAcl user : userList) {
                    indices[i++] = AbstractPermissionsController.this.manageAclsModel.getSelectedUserIndex(user);
                }
                return indices;
            }
        };
        BindingConvertor<int[], List<UIRepositoryObjectAcl>> indexToSelectedRoleConverter = new BindingConvertor<int[], List<UIRepositoryObjectAcl>>(){

            public List<UIRepositoryObjectAcl> sourceToTarget(int[] indices) {
                ArrayList<UIRepositoryObjectAcl> roleList = new ArrayList<UIRepositoryObjectAcl>();
                for (int i = 0; i < indices.length; ++i) {
                    roleList.add(AbstractPermissionsController.this.manageAclsModel.getSelectedRole(indices[i]));
                }
                return roleList;
            }

            public int[] targetToSource(List<UIRepositoryObjectAcl> roleList) {
                int[] indices = new int[roleList.size()];
                int i = 0;
                for (UIRepositoryObjectAcl role : roleList) {
                    indices[i++] = AbstractPermissionsController.this.manageAclsModel.getSelectedRoleIndex(role);
                }
                return indices;
            }
        };
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.availableUserList, "selectedIndices", (Object)this.manageAclsModel, "selectedAvailableUsers", new BindingConvertor[]{indexToAvailableUserConverter});
        this.bf.createBinding((Object)this.selectedUserList, "selectedIndices", (Object)this.manageAclsModel, "selectedAssignedUsers", new BindingConvertor[]{indexToSelectedUserConverter});
        this.bf.createBinding((Object)this.availableRoleList, "selectedIndices", (Object)this.manageAclsModel, "selectedAvailableRoles", new BindingConvertor[]{indexToAvailableRoleConverter});
        this.bf.createBinding((Object)this.selectedRoleList, "selectedIndices", (Object)this.manageAclsModel, "selectedAssignedRoles", new BindingConvertor[]{indexToSelectedRoleConverter});
        this.bf.createBinding((Object)this.userRoleList, "selectedIndices", (Object)this.viewAclsModel, "selectedAclList", new BindingConvertor[]{indicesToObjectsConverter});
        BindingConvertor<Integer, Boolean> accumulatorButtonConverter = new BindingConvertor<Integer, Boolean>(){

            public Boolean sourceToTarget(Integer value) {
                if (value != null && value >= 0) {
                    return true;
                }
                return false;
            }

            public Integer targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.selectedUserList, "selectedIndex", (Object)this.manageAclsModel, "userUnassignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.availableUserList, "selectedIndex", (Object)this.manageAclsModel, "userAssignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.manageAclsModel, "userUnassignmentPossible", (Object)this.unassignUserButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.manageAclsModel, "userAssignmentPossible", (Object)this.assignUserButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.selectedRoleList, "selectedIndex", (Object)this.manageAclsModel, "roleUnassignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.availableRoleList, "selectedIndex", (Object)this.manageAclsModel, "roleAssignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.manageAclsModel, "roleUnassignmentPossible", (Object)this.unassignRoleButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.manageAclsModel, "roleAssignmentPossible", (Object)this.assignRoleButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.viewAclsModel, "removeEnabled", (Object)this.removeAclButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.viewAclsModel, "selectedAclList", (Object)this, "aclState", new BindingConvertor[]{new BindingConvertor<List<UIRepositoryObjectAcl>, UIRepositoryObjectAcl>(){

            public UIRepositoryObjectAcl sourceToTarget(List<UIRepositoryObjectAcl> value) {
                if (value != null && value.size() > 0) {
                    return value.get(0);
                }
                return null;
            }

            public List<UIRepositoryObjectAcl> targetToSource(UIRepositoryObjectAcl value) {
                return null;
            }
        }});
        this.bf.createBinding((Object)this.userRoleList, "selectedItem", (Object)this, "recipientChanged", new BindingConvertor[0]);
    }

    public void assignUsers() {
        this.manageAclsModel.assignUsers(Arrays.asList(this.availableUserList.getSelectedItems()));
    }

    public void unassignUsers() {
        this.manageAclsModel.unassign(Arrays.asList(this.selectedUserList.getSelectedItems()));
    }

    public void assignRoles() {
        this.manageAclsModel.assignRoles(Arrays.asList(this.availableRoleList.getSelectedItems()));
    }

    public void unassignRoles() {
        this.manageAclsModel.unassign(Arrays.asList(this.selectedRoleList.getSelectedItems()));
    }

    public void showManageAclsDialog() throws Exception {
        try {
            this.manageAclsModel.clear();
            this.manageAclsModel.setAclsList(this.service.getAllUsers(), this.service.getAllRoles());
        }
        catch (KettleException ke) {
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"PermissionsController.UnableToGetUserOrRole", (String[])new String[]{ke.getLocalizedMessage()}));
            this.messageBox.open();
        }
        this.manageAclsDialog.show();
    }

    public void closeManageAclsDialog() {
        this.manageAclsDialog.hide();
    }

    public void updateAcls() {
        this.manageAclsModel.updateSelectedAcls();
        this.viewAclsModel.setSelectedAclList(null);
        this.setAclState(null);
        this.closeManageAclsDialog();
    }

    public void removeAcl() throws Exception {
        this.confirmBox.open();
    }

    public void setRecipientChanged(UIRepositoryObjectAcl acl) throws Exception {
        ArrayList<UIRepositoryObjectAcl> acls = new ArrayList<UIRepositoryObjectAcl>();
        if (acl != null) {
            acls.add(acl);
        }
        this.viewAclsModel.setSelectedAclList(acls);
    }

    protected void updateCheckboxes(UIRepositoryObjectAcl acl) {
        this.permissionsCheckboxHandler.updateCheckboxes(this.hasManageAclAccess(), acl.getPermissionSet());
    }

    public void setAclState(UIRepositoryObjectAcl acl) {
        if (acl != null && acl.getPermissionSet() != null) {
            this.updateCheckboxes(acl);
        } else {
            this.permissionsCheckboxHandler.setAllChecked(false);
            this.permissionsCheckboxHandler.setAllDisabled(true);
        }
    }

    protected boolean hasManageAclAccess() {
        block3: {
            try {
                Object ro = this.getSelectedObjects().get(0);
                if (ro instanceof IAclObject) {
                    return ((IAclObject)ro).hasAccess(RepositoryFilePermission.ACL_MANAGEMENT);
                }
            }
            catch (Exception e) {
                if (KettleRepositoryLostException.lookupStackStrace((Throwable)e) != null) break block3;
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void clearSelectedObjAcl() {
        Object ro = this.getSelectedObjects().get(0);
        if (ro instanceof IAclObject) {
            ((IAclObject)ro).clearAcl();
        }
    }

    public void updatePermission() {
        UIRepositoryObjectAcl acl = (UIRepositoryObjectAcl)this.userRoleList.getSelectedItem();
        if (acl == null) {
            throw new IllegalStateException(BaseMessages.getString(PKG, (String)"PermissionsController.NoSelectedRecipient", (String[])new String[0]));
        }
        acl.setPermissionSet(this.permissionsCheckboxHandler.processCheckboxes());
        this.clearSelectedObjAcl();
        this.viewAclsModel.updateAcl(acl);
    }

    public ContextChangeVetoer.TYPE onContextChange() {
        try {
            if (this.viewAclsModel.isModelDirty()) {
                if (!this.hasManageAclAccess()) {
                    this.viewAclsModel.clear();
                    this.clearSelectedObjAcl();
                    this.viewAclsModel.setModelDirty(false);
                    return ContextChangeVetoer.TYPE.OK;
                }
                XulConfirmBox confirmBox = null;
                try {
                    confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                confirmBox.setTitle(BaseMessages.getString(PKG, (String)"PermissionsController.ContextChangeWarning", (String[])new String[0]));
                confirmBox.setMessage(BaseMessages.getString(PKG, (String)"PermissionsController.ContextChangeWarningText", (String[])new String[0]));
                confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Yes", (String[])new String[0]));
                confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.No", (String[])new String[0]));
                confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

                    public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                        if (returnCode == XulDialogCallback.Status.ACCEPT) {
                            AbstractPermissionsController.this.returnType = ContextChangeVetoer.TYPE.OK;
                            AbstractPermissionsController.this.viewAclsModel.clear();
                            AbstractPermissionsController.this.clearSelectedObjAcl();
                            AbstractPermissionsController.this.viewAclsModel.setModelDirty(false);
                        } else {
                            AbstractPermissionsController.this.returnType = ContextChangeVetoer.TYPE.CANCEL;
                        }
                    }

                    public void onError(XulComponent sender, Throwable t) {
                        AbstractPermissionsController.this.returnType = ContextChangeVetoer.TYPE.NO_OP;
                    }
                });
                confirmBox.open();
            } else {
                this.returnType = ContextChangeVetoer.TYPE.NO_OP;
            }
            return this.returnType;
        }
        catch (Exception e) {
            if (KettleRepositoryLostException.lookupStackStrace((Throwable)e) != null) {
                return ContextChangeVetoer.TYPE.NO_OP;
            }
            throw new RuntimeException(e);
        }
    }
}

