/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;

public class PurRepositoryImporter
extends RepositoryImporter
implements Serializable {
    private static final long serialVersionUID = 2853810493291696227L;
    private PurRepository rep;
    private Map<Class<?>, List<?>> sharedObjectsByType = null;

    public PurRepositoryImporter(PurRepository repository) {
        super((Repository)repository, (LogChannelInterface)new LogChannel((Object)"Repository import"));
        this.rep = repository;
    }

    protected <T extends SharedObjectInterface> List<T> getSharedObjects(Class<T> clazz) {
        ArrayList<SharedObjectInterface> result = new ArrayList<SharedObjectInterface>();
        List<?> typeList = this.sharedObjectsByType.get(clazz);
        if (typeList != null) {
            for (Object obj : typeList) {
                result.add((SharedObjectInterface)clazz.cast(obj));
            }
        }
        return result;
    }

    private void populateSharedObjectsMap() throws KettleException {
        this.sharedObjectsByType = new HashMap();
        for (Map.Entry<RepositoryObjectType, List<? extends SharedObjectInterface>> entry : this.rep.loadAndCacheSharedObjects().entrySet()) {
            Class<DatabaseMeta> clazz = null;
            switch (entry.getKey()) {
                case DATABASE: {
                    clazz = DatabaseMeta.class;
                    break;
                }
                case SLAVE_SERVER: {
                    clazz = SlaveServer.class;
                    break;
                }
                case PARTITION_SCHEMA: {
                    clazz = PartitionSchema.class;
                    break;
                }
                case CLUSTER_SCHEMA: {
                    clazz = ClusterSchema.class;
                    break;
                }
            }
            if (clazz == null) continue;
            this.sharedObjectsByType.put(clazz, new ArrayList(entry.getValue()));
        }
    }

    protected void loadSharedObjects() throws KettleException {
    }

    protected void replaceSharedObjects(TransMeta transMeta) throws KettleException {
        this.populateSharedObjectsMap();
        super.replaceSharedObjects(transMeta);
    }

    protected void replaceSharedObjects(JobMeta jobMeta) throws KettleException {
        this.populateSharedObjectsMap();
        super.replaceSharedObjects(jobMeta);
    }

    protected boolean equals(DatabaseMeta databaseMeta, DatabaseMeta databaseMeta2) {
        return this.rep.getDatabaseMetaTransformer().equals((RepositoryElementInterface)databaseMeta, (RepositoryElementInterface)databaseMeta2);
    }

    protected boolean equals(SlaveServer slaveServer, SlaveServer slaveServer2) {
        return this.rep.getSlaveTransformer().equals((RepositoryElementInterface)slaveServer, (RepositoryElementInterface)slaveServer2);
    }

    protected boolean equals(ClusterSchema clusterSchema, ClusterSchema clusterSchema2) {
        return this.rep.getClusterTransformer().equals((RepositoryElementInterface)clusterSchema, (RepositoryElementInterface)clusterSchema2);
    }

    protected boolean equals(PartitionSchema partitionSchema, PartitionSchema partitionSchema2) {
        return this.rep.getPartitionSchemaTransformer().equals((RepositoryElementInterface)partitionSchema, (RepositoryElementInterface)partitionSchema2);
    }

    protected void saveTransMeta(TransMeta transMeta) throws KettleException {
        this.rep.saveKettleEntity((RepositoryElementInterface)transMeta, this.getVersionComment(), null, true, false, false, false, false);
    }

    protected void saveJobMeta(JobMeta jobMeta) throws KettleException {
        this.rep.saveKettleEntity((RepositoryElementInterface)jobMeta, this.getVersionComment(), null, true, false, false, false, false);
    }
}

