/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.pur.ActiveCache;
import org.pentaho.di.repository.pur.ActiveCacheLoader;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.PurRepositorySecurityProvider;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.platform.security.policy.rolebased.ws.IAuthorizationPolicyWebService;

public class AbsSecurityProvider
extends PurRepositorySecurityProvider
implements IAbsSecurityProvider,
Serializable {
    private static final long FIVE_MINUTES = 300000L;
    private static final long serialVersionUID = -41954375242408881L;
    private IAuthorizationPolicyWebService authorizationPolicyWebService = null;
    private final ActiveCache<String, List<String>> allowedActionsActiveCache = new ActiveCache<String, List<String>>(new ActiveCacheLoader<String, List<String>>(){

        @Override
        public List<String> load(String key) throws Exception {
            return AbsSecurityProvider.this.authorizationPolicyWebService.getAllowedActions(key);
        }
    }, 300000L);
    private final ActiveCache<String, Boolean> isAllowedActiveCache = new ActiveCache<String, Boolean>(new ActiveCacheLoader<String, Boolean>(){

        @Override
        public Boolean load(String key) throws Exception {
            return AbsSecurityProvider.this.authorizationPolicyWebService.isAllowed(key);
        }
    }, 300000L);

    public AbsSecurityProvider(PurRepository repository, PurRepositoryMeta repositoryMeta, IUser userInfo, ServiceManager serviceManager) {
        super(repository, repositoryMeta, userInfo, serviceManager);
        try {
            this.authorizationPolicyWebService = serviceManager.createService(userInfo.getLogin(), userInfo.getPassword(), IAuthorizationPolicyWebService.class);
            if (this.authorizationPolicyWebService == null) {
                AbsSecurityProvider.getLogger().error((Object)BaseMessages.getString(AbsSecurityProvider.class, (String)"AbsSecurityProvider.ERROR_0001_UNABLE_TO_INITIALIZE_AUTH_POLICY_WEBSVC", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            AbsSecurityProvider.getLogger().error((Object)BaseMessages.getString(AbsSecurityProvider.class, (String)"AbsSecurityProvider.ERROR_0001_UNABLE_TO_INITIALIZE_AUTH_POLICY_WEBSVC", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public List<String> getAllowedActions(String nameSpace) throws KettleException {
        try {
            return this.allowedActionsActiveCache.get(nameSpace);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(AbsSecurityProvider.class, (String)"AbsSecurityProvider.ERROR_0003_UNABLE_TO_ACCESS_GET_ALLOWED_ACTIONS", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public boolean isAllowed(String actionName) throws KettleException {
        try {
            return this.isAllowedActiveCache.get(actionName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(AbsSecurityProvider.class, (String)"AbsSecurityProvider.ERROR_0002_UNABLE_TO_ACCESS_IS_ALLOWED", (String[])new String[0]), (Throwable)e);
        }
    }

    public void validateAction(RepositoryOperation ... operations) throws KettleException {
        block6: for (RepositoryOperation operation : operations) {
            switch (operation) {
                case EXECUTE_TRANSFORMATION: 
                case EXECUTE_JOB: {
                    this.checkOperationAllowed("org.pentaho.repository.execute");
                    continue block6;
                }
                case MODIFY_TRANSFORMATION: 
                case MODIFY_JOB: {
                    this.checkOperationAllowed("org.pentaho.repository.create");
                    continue block6;
                }
                case SCHEDULE_TRANSFORMATION: 
                case SCHEDULE_JOB: {
                    this.checkOperationAllowed("org.pentaho.scheduler.manage");
                    continue block6;
                }
                case MODIFY_DATABASE: {
                    this.checkOperationAllowed("org.pentaho.platform.dataaccess.datasource.security.manage");
                }
            }
        }
    }

    private void checkOperationAllowed(String operation) throws KettleException {
        if (!this.isAllowed(operation)) {
            throw new KettleException(operation + " : permission not allowed");
        }
    }
}

