/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.IPurgeUtilityLayout;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.util.Transform;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class PurgeUtilityHTMLLayout
implements StringLayout,
IPurgeUtilityLayout {
    protected static final int BUF_SIZE = 256;
    protected static final int MAX_CAPACITY = 1024;
    protected static final String fontCss = "font-family: arial,sans-serif; font-size: x-small";
    protected static final String thCss = "background: #336699; color: #FFFFFF; text-align: left";
    static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final String REGEXP = Strings.LINE_SEPARATOR.equals("\n") ? "\n" : Strings.LINE_SEPARATOR + "|\n";
    private Level loggerLogLevel = Level.DEBUG;
    private StringBuffer sbuf = new StringBuffer(256);
    String title = "Log4J Log Messages";

    public PurgeUtilityHTMLLayout(Level loggerLogLevel) {
        this.loggerLogLevel = loggerLogLevel;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    public Map<String, String> getContentFormat() {
        return null;
    }

    public void activateOptions() {
    }

    @Override
    public String format(LogEvent event) {
        String[] s;
        Level logLevel = event.getLevel();
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        if (this.showTimeColumn()) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            date.setTime(event.getTimeMillis());
            String time = null;
            try {
                time = df.format(date);
            }
            catch (Exception ex) {
                StatusLogger.getLogger().error("Error occured while converting date.", (Throwable)ex);
            }
            this.sbuf.append(LINE_SEP + "<tr>" + LINE_SEP);
            this.sbuf.append("<td>");
            this.sbuf.append(Transform.escapeHtmlTags((String)time));
            this.sbuf.append("</td>" + LINE_SEP);
        }
        this.sbuf.append("<td title=\"Purge File/Folder\">");
        this.sbuf.append(Transform.escapeHtmlTags((String)ThreadContext.get((String)"currentFile")));
        this.sbuf.append("</td>" + LINE_SEP);
        if (this.showLevelColumn()) {
            this.sbuf.append("<td title=\"Level\">");
            if (logLevel.equals((Object)Level.DEBUG)) {
                this.sbuf.append("<font color=\"#339933\">");
                this.sbuf.append(Transform.escapeHtmlTags((String)String.valueOf(event.getLevel())));
                this.sbuf.append("</font>");
            } else if (logLevel.isMoreSpecificThan(Level.WARN)) {
                this.sbuf.append("<font color=\"#993300\"><strong>");
                this.sbuf.append(Transform.escapeHtmlTags((String)String.valueOf(event.getLevel())));
                this.sbuf.append("</strong></font>");
            } else {
                this.sbuf.append(Transform.escapeHtmlTags((String)String.valueOf(event.getLevel())));
            }
            this.sbuf.append("</td>" + LINE_SEP);
        }
        if (this.showCodeLineColumn()) {
            StackTraceElement element = event.getSource();
            this.sbuf.append("<td>");
            this.sbuf.append(Transform.escapeHtmlTags((String)ThreadContext.get((String)"codeLine")));
            this.sbuf.append("</td>" + LINE_SEP);
        }
        this.sbuf.append("<td title=\"Message\">");
        this.sbuf.append(Transform.escapeHtmlTags((String)event.getMessage().getFormattedMessage()).replaceAll(REGEXP, "<br />"));
        this.sbuf.append("</td>" + LINE_SEP);
        this.sbuf.append("</tr>" + LINE_SEP);
        if (event.getContextStack() != null && !event.getContextStack().isEmpty()) {
            this.sbuf.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : ").append("xx-small");
            this.sbuf.append(";\" colspan=\"6\" ");
            this.sbuf.append("title=\"Nested Diagnostic Context\">");
            this.sbuf.append("NDC: ").append(Transform.escapeHtmlTags((String)event.getContextStack().toString()));
            this.sbuf.append("</td></tr>" + LINE_SEP);
        }
        if ((s = event.getContextStack().asList().toArray(new String[0])) != null) {
            this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, this.sbuf);
            this.sbuf.append("</td></tr>" + LINE_SEP);
        }
        return this.sbuf.toString();
    }

    void appendThrowableAsHTML(String[] s, StringBuffer sbuf) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append(Transform.escapeHtmlTags((String)s[0]));
            sbuf.append(LINE_SEP);
            for (int i = 1; i < len; ++i) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeHtmlTags((String)s[i]));
                sbuf.append(LINE_SEP);
            }
        }
    }

    public byte[] getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + LINE_SEP);
        sbuf.append("<html>" + LINE_SEP);
        sbuf.append("<head>" + LINE_SEP);
        sbuf.append("<title>" + this.title + "</title>" + LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + LINE_SEP);
        sbuf.append("<!--" + LINE_SEP);
        sbuf.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + LINE_SEP);
        sbuf.append("th {background: #336699; color: #FFFFFF; text-align: left;}" + LINE_SEP);
        sbuf.append("-->" + LINE_SEP);
        sbuf.append("</style>" + LINE_SEP);
        sbuf.append("</head>" + LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\" style=\"font-family: arial,sans-serif; font-size: x-small\">" + LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>" + LINE_SEP);
        sbuf.append("Log session start time " + new Date() + "<br>" + LINE_SEP);
        sbuf.append("<br>" + LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + LINE_SEP);
        sbuf.append("<tr style=\"background: #336699; color: #FFFFFF; text-align: left\">" + LINE_SEP);
        if (this.showTimeColumn()) {
            sbuf.append("<th>Time</th>" + LINE_SEP);
        }
        sbuf.append("<th>File/Folder</th>" + LINE_SEP);
        if (this.showLevelColumn()) {
            sbuf.append("<th>Level</th>" + LINE_SEP);
        }
        if (this.showCodeLineColumn()) {
            sbuf.append("<th>File:Line</th>" + LINE_SEP);
        }
        sbuf.append("<th>Message</th>" + LINE_SEP);
        sbuf.append("</tr>" + LINE_SEP);
        return sbuf.toString().getBytes(StandardCharsets.UTF_8);
    }

    public byte[] toByteArray(LogEvent event) {
        return this.format(event).getBytes(StandardCharsets.UTF_8);
    }

    public String toSerializable(LogEvent event) {
        return this.format(event);
    }

    public byte[] getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("</table>" + LINE_SEP);
        sbuf.append("<br>" + LINE_SEP);
        sbuf.append("</body></html>");
        return sbuf.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }

    private boolean showCodeLineColumn() {
        return Level.DEBUG.isMoreSpecificThan(this.loggerLogLevel);
    }

    private boolean showTimeColumn() {
        return Level.DEBUG.isMoreSpecificThan(this.loggerLogLevel);
    }

    private boolean showLevelColumn() {
        return true;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public void encode(LogEvent source, ByteBufferDestination destination) {
    }
}

