/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.mailer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.MultiStreamReportProcessTask;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportParameterValidationException;
import org.pentaho.reporting.engine.classic.core.ReportProcessTask;
import org.pentaho.reporting.engine.classic.core.ReportProcessTaskUtil;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskRegistry;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailDefinition;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailHeader;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailURLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.email.EmailRepository;

public class MailProcessor {
    private static final Log logger = LogFactory.getLog(MailProcessor.class);

    private MailProcessor() {
    }

    public static MimeMessage createReport(MailDefinition mailDefinition, Session session) throws ReportProcessingException, ContentIOException, MessagingException {
        return MailProcessor.createReport(mailDefinition, session, (DataRow)new StaticDataRow());
    }

    public static MimeMessage createReport(MailDefinition mailDefinition, Session session, DataRow parameters) throws ReportProcessingException, ContentIOException, MessagingException {
        MasterReport bodyReport = mailDefinition.getBodyReport();
        String[] paramNames = parameters.getColumnNames();
        ReportParameterValues parameterValues = bodyReport.getParameterValues();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            if (!MailProcessor.isParameterDefined(bodyReport, paramName)) continue;
            parameterValues.put(paramName, parameters.get(paramName));
        }
        ReportProcessTaskRegistry registry = ReportProcessTaskRegistry.getInstance();
        String bodyType = mailDefinition.getBodyType();
        ReportProcessTask processTask = registry.createProcessTask(bodyType);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ReportProcessTaskUtil.configureBodyStream((ReportProcessTask)processTask, (OutputStream)bout, (String)"report", null);
        processTask.setReport(bodyReport);
        if (processTask instanceof MultiStreamReportProcessTask) {
            MultiStreamReportProcessTask mtask = (MultiStreamReportProcessTask)processTask;
            mtask.setBulkLocation(mtask.getBodyContentLocation());
            mtask.setBulkNameGenerator((NameGenerator)new DefaultNameGenerator(mtask.getBodyContentLocation(), "data"));
            mtask.setUrlRewriter((URLRewriter)new MailURLRewriter());
        }
        processTask.run();
        if (!processTask.isTaskSuccessful()) {
            if (processTask.isTaskAborted()) {
                logger.info((Object)"EMail Task received interrupt.");
                return null;
            }
            logger.info((Object)"EMail Task failed:", processTask.getError());
            throw new ReportProcessingException("EMail Task failed", processTask.getError());
        }
        EmailRepository repository = new EmailRepository(session);
        MimeBodyPart messageBodyPart = repository.getBodypart();
        ByteArrayDataSource dataSource = new ByteArrayDataSource(bout.toByteArray(), processTask.getReportMimeType());
        messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
        int attachmentsSize = mailDefinition.getAttachmentCount();
        for (int i = 0; i < attachmentsSize; ++i) {
            MasterReport report = mailDefinition.getAttachmentReport(i);
            String type = mailDefinition.getAttachmentType(i);
            ContentLocation location = repository.getRoot();
            ContentLocation bulkLocation = location.createLocation("attachment-" + i);
            ReportProcessTask attachmentProcessTask = registry.createProcessTask(type);
            attachmentProcessTask.setBodyContentLocation(bulkLocation);
            attachmentProcessTask.setBodyNameGenerator((NameGenerator)new DefaultNameGenerator(bulkLocation, "report"));
            attachmentProcessTask.setReport(report);
            if (attachmentProcessTask instanceof MultiStreamReportProcessTask) {
                MultiStreamReportProcessTask mtask = (MultiStreamReportProcessTask)attachmentProcessTask;
                mtask.setBulkLocation(bulkLocation);
                mtask.setBulkNameGenerator((NameGenerator)new DefaultNameGenerator(bulkLocation, "data"));
                mtask.setUrlRewriter((URLRewriter)new MailURLRewriter());
            }
            attachmentProcessTask.run();
            if (attachmentProcessTask.isTaskSuccessful()) continue;
            if (attachmentProcessTask.isTaskAborted()) {
                logger.info((Object)"EMail Task received interrupt.");
                continue;
            }
            logger.info((Object)"EMail Task failed:", attachmentProcessTask.getError());
            throw new ReportProcessingException("EMail Task failed", attachmentProcessTask.getError());
        }
        return repository.getEmail();
    }

    private static boolean isParameterDefined(MasterReport bodyReport, String paramName) {
        ParameterDefinitionEntry[] definitionEntries = bodyReport.getParameterDefinition().getParameterDefinitions();
        for (int i = 0; i < definitionEntries.length; ++i) {
            ParameterDefinitionEntry definitionEntry = definitionEntries[i];
            if (!definitionEntry.getName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public static void performBursting(MailDefinition definition) throws ReportProcessingException, MessagingException, ContentIOException {
        Session session = Session.getInstance((Properties)definition.getSessionProperties(), (Authenticator)definition.getAuthenticator());
        MailProcessor.performBursting(definition, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performBursting(MailDefinition definition, Session session) throws MessagingException, ReportProcessingException, ContentIOException {
        if (session == null) {
            throw new NullPointerException();
        }
        ReportParameterValues parameterValues = definition.getParameterValues();
        try (DefaultParameterContext parameterContext = new DefaultParameterContext((DataFactory)definition.getDataFactory(), (DataRow)parameterValues, ClassicEngineBoot.getInstance().getGlobalConfig(), definition.getResourceBundleFactory(), definition.getResourceManager(), definition.getContextKey(), definition.getReportEnvironment());){
            ReportParameterDefinition parameterDefinition = definition.getParameterDefinition();
            ReportParameterValidator reportParameterValidator = parameterDefinition.getValidator();
            ValidationResult validationResult = reportParameterValidator.validate(new ValidationResult(), parameterDefinition, (ParameterContext)parameterContext);
            if (!validationResult.isEmpty()) {
                throw new ReportParameterValidationException("The parameters provided for this report are not valid.", validationResult);
            }
        }
        CompoundDataFactory dataFactory = definition.getDataFactory();
        TableModel burstingData = definition.getBurstQuery() != null && dataFactory.isQueryExecutable(definition.getBurstQuery(), (DataRow)parameterValues) ? MailProcessor.wrapWithParameters(dataFactory.queryData(definition.getBurstQuery(), (DataRow)parameterValues), (DataRow)parameterValues) : MailProcessor.wrapWithParameters(new DefaultTableModel(1, 0), (DataRow)parameterValues);
        if (burstingData.getRowCount() > 0) {
            for (int i = 0; i < burstingData.getRowCount(); ++i) {
                DataRow parameterDataRow = MailProcessor.createReportParameterDataRow(burstingData, i);
                MimeMessage message = MailProcessor.createReport(definition, session, parameterDataRow);
                parameterContext.setParameterValues(parameterDataRow);
                MailHeader[] headers = definition.getHeaders();
                for (int j = 0; j < headers.length; ++j) {
                    MailHeader header = headers[j];
                    message.addHeader(header.getName(), header.getValue((ParameterContext)parameterContext));
                }
                MailProcessor.processRecipients(definition, message, (DataFactory)dataFactory, parameterDataRow);
            }
        }
    }

    private static void processRecipients(MailDefinition definition, MimeMessage message, DataFactory dataFactory, DataRow parameterDataRow) throws ReportDataFactoryException, MessagingException {
        if (definition.getRecipientsQuery() != null && dataFactory.isQueryExecutable(definition.getRecipientsQuery(), parameterDataRow)) {
            TableModel model = MailProcessor.wrapWithParameters(dataFactory.queryData(definition.getRecipientsQuery(), parameterDataRow), parameterDataRow);
            for (int r = 0; r < model.getRowCount(); ++r) {
                String address = null;
                String name = null;
                String type = "TO";
                if (model.getColumnCount() >= 3) {
                    type = (String)model.getValueAt(0, 2);
                }
                if (model.getColumnCount() >= 2) {
                    name = (String)model.getValueAt(0, 1);
                }
                if (model.getColumnCount() >= 1) {
                    address = (String)model.getValueAt(0, 0);
                }
                if (address == null) continue;
                if (name == null) {
                    message.addRecipient(MailProcessor.parseType(type), (Address)new InternetAddress(address, true));
                    continue;
                }
                try {
                    message.addRecipient(MailProcessor.parseType(type), (Address)new InternetAddress(address, name, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException("Failed to encode recipient", (Exception)e);
                }
            }
        }
    }

    private static Message.RecipientType parseType(String type) {
        if ("TO".equalsIgnoreCase(type)) {
            return MimeMessage.RecipientType.TO;
        }
        if ("CC".equalsIgnoreCase(type)) {
            return MimeMessage.RecipientType.CC;
        }
        if ("BCC".equalsIgnoreCase(type)) {
            return MimeMessage.RecipientType.BCC;
        }
        return MimeMessage.RecipientType.TO;
    }

    private static DataRow createReportParameterDataRow(TableModel burstingData, int row) {
        int columnCount = burstingData.getColumnCount();
        String[] columnNames = new String[columnCount];
        Object[] columnValues = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnValues[i] = burstingData.getValueAt(row, i);
            columnNames[i] = burstingData.getColumnName(i);
        }
        return new StaticDataRow(columnNames, columnValues);
    }

    private static TableModel wrapWithParameters(TableModel model, DataRow parameter) {
        return new WrapperTableModel(parameter, model);
    }

    private static class WrapperTableModel
    implements TableModel {
        private TableModel parent;
        private DataRow parameters;
        private String[] parameterNames;

        private WrapperTableModel(DataRow parameters, TableModel parent) {
            this.parent = parent;
            this.parameters = parameters;
            this.parameterNames = parameters.getColumnNames();
        }

        @Override
        public int getRowCount() {
            return this.parent.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.parameterNames.length + this.parent.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex < this.parameterNames.length) {
                return this.parameters.get(this.parameterNames[columnIndex]);
            }
            return this.parent.getValueAt(rowIndex, columnIndex - this.parameterNames.length);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.parameterNames.length) {
                return this.parameterNames[columnIndex];
            }
            return this.parent.getColumnName(columnIndex - this.parameterNames.length);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex < this.parameterNames.length) {
                return Object.class;
            }
            return this.parent.getColumnClass(columnIndex - this.parameterNames.length);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

