/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.ui.entry.pmr;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.UserDefinedItem;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.pmr.JobEntryHadoopTransJobExecutor;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.jface.tags.JfaceMenuList;
import org.pentaho.ui.xul.util.AbstractModelList;

public class JobEntryHadoopTransJobExecutorController
extends AbstractXulEventHandler {
    private static final Class<?> PKG = JobEntryHadoopTransJobExecutor.class;
    public static final String JOB_ENTRY_NAME = "jobEntryName";
    public static final String HADOOP_JOB_NAME = "hadoopJobName";
    public static final String MAP_TRANS = "mapTrans";
    public static final String COMBINER_TRANS = "combinerTrans";
    public static final String REDUCE_TRANS = "reduceTrans";
    public static final String MAP_TRANS_INPUT_STEP_NAME = "mapTransInputStepName";
    public static final String MAP_TRANS_OUTPUT_STEP_NAME = "mapTransOutputStepName";
    public static final String COMBINER_TRANS_INPUT_STEP_NAME = "combinerTransInputStepName";
    public static final String COMBINER_TRANS_OUTPUT_STEP_NAME = "combinerTransOutputStepName";
    public static final String COMBINING_SINGLE_THREADED = "combiningSingleThreaded";
    public static final String REDUCE_TRANS_INPUT_STEP_NAME = "reduceTransInputStepName";
    public static final String REDUCE_TRANS_OUTPUT_STEP_NAME = "reduceTransOutputStepName";
    public static final String REDUCING_SINGLE_THREADED = "reducingSingleThreaded";
    public static final String SUPPRESS_OUTPUT_MAP_KEY = "suppressOutputOfMapKey";
    public static final String SUPPRESS_OUTPUT_MAP_VALUE = "suppressOutputOfMapValue";
    public static final String SUPPRESS_OUTPUT_KEY = "suppressOutputOfKey";
    public static final String SUPPRESS_OUTPUT_VALUE = "suppressOutputOfValue";
    public static final String MAP_OUTPUT_KEY_CLASS = "mapOutputKeyClass";
    public static final String MAP_OUTPUT_VALUE_CLASS = "mapOutputValueClass";
    public static final String OUTPUT_KEY_CLASS = "outputKeyClass";
    public static final String OUTPUT_VALUE_CLASS = "outputValueClass";
    public static final String INPUT_FORMAT_CLASS = "inputFormatClass";
    public static final String OUTPUT_FORMAT_CLASS = "outputFormatClass";
    public static final String INPUT_PATH = "inputPath";
    public static final String OUTPUT_PATH = "outputPath";
    public static final String CLEAN_OUTPUT_PATH = "cleanOutputPath";
    public static final String BLOCKING = "blocking";
    public static final String LOGGING_INTERVAL = "loggingInterval";
    public static final String HDFS_HOSTNAME = "hdfsHostname";
    public static final String HDFS_PORT = "hdfsPort";
    public static final String JOB_TRACKER_HOSTNAME = "jobTrackerHostname";
    public static final String JOB_TRACKER_PORT = "jobTrackerPort";
    public static final String NUM_MAP_TASKS = "numMapTasks";
    public static final String NUM_REDUCE_TASKS = "numReduceTasks";
    public static final String USER_DEFINED = "userDefined";
    public static final String LOCAL = "local";
    public static final String REPOSITORY = "repository";
    private final NamedClusterService namedClusterService;
    private final HadoopClusterDelegateImpl ncDelegate;
    private String jobEntryName;
    private String hadoopJobName;
    private boolean suppressOutputMapKey;
    private boolean suppressOutputMapValue;
    private boolean suppressOutputKey;
    private boolean suppressOutputValue;
    private String inputFormatClass;
    private String outputFormatClass;
    private String inputPath;
    private String outputPath;
    private boolean cleanOutputPath;
    private String numMapTasks = "1";
    private String numReduceTasks = "1";
    private boolean blocking;
    private String loggingInterval = "60";
    private String mapTrans = "";
    private String combinerTrans = "";
    private boolean combiningSingleThreaded;
    private String reduceTrans = "";
    private boolean reducingSingleThreaded;
    private String mapTransInputStepName = "";
    private String mapTransOutputStepName = "";
    private String combinerTransInputStepName = "";
    private String combinerTransOutputStepName = "";
    private String reduceTransInputStepName = "";
    private String reduceTransOutputStepName = "";
    private static String storageType;
    private List<NamedCluster> namedClusters;
    protected Shell shell;
    private Repository rep;
    private JobMeta jobMeta;
    private NamedCluster selectedNamedCluster;
    private JobEntryHadoopTransJobExecutor jobEntry;
    private AbstractModelList<UserDefinedItem> userDefined = new AbstractModelList();

    public JobEntryHadoopTransJobExecutorController(HadoopClusterDelegateImpl ncDelegate, NamedClusterService namedClusterService) throws Throwable {
        this.ncDelegate = ncDelegate;
        this.namedClusterService = namedClusterService;
    }

    protected VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public void accept() {
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-hadoopjob-name");
        this.hadoopJobName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-map-transformation");
        this.mapTrans = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-map-input-stepname");
        this.mapTransInputStepName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-map-output-stepname");
        this.mapTransOutputStepName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-combiner-transformation");
        this.combinerTrans = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-combiner-input-stepname");
        this.combinerTransInputStepName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-combiner-output-stepname");
        this.combinerTransOutputStepName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-reduce-transformation");
        this.reduceTrans = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-reduce-input-stepname");
        this.reduceTransInputStepName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-reduce-output-stepname");
        this.reduceTransOutputStepName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-path");
        this.inputPath = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("output-path");
        this.outputPath = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-input-format");
        this.inputFormatClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-format");
        this.outputFormatClass = ((Text)tempBox.getTextControl()).getText();
        JfaceMenuList ncBox = (JfaceMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("named-clusters");
        try {
            this.selectedNamedCluster = this.namedClusterService.read(ncBox.getSelectedItem(), this.jobMeta.getMetaStore());
        }
        catch (MetaStoreException e) {
            this.openErrorDialog(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage());
        }
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-map-tasks");
        this.numMapTasks = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-reduce-tasks");
        this.numReduceTasks = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("logging-interval");
        this.loggingInterval = ((Text)tempBox.getTextControl()).getText();
        String validationErrors = "";
        if (StringUtil.isEmpty((String)this.jobEntryName)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.JobEntryName.Error", (String[])new String[0]) + "\n";
        }
        if (this.selectedNamedCluster == null) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NamedClusterNotProvided.Error", (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.hadoopJobName)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.HadoopJobName.Error", (String[])new String[0]) + "\n";
        }
        if (!StringUtils.isEmpty((String)this.numReduceTasks)) {
            String reduceS = this.getVariableSpace().environmentSubstitute(this.numReduceTasks);
            try {
                int numR = Integer.parseInt(reduceS);
                if (numR < 0) {
                    validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NumReduceTasks.Error", (String[])new String[0]) + "\n";
                }
            }
            catch (NumberFormatException numR) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)this.numMapTasks)) {
            String mapS = this.getVariableSpace().environmentSubstitute(this.numMapTasks);
            try {
                int numM = Integer.parseInt(mapS);
                if (numM < 0) {
                    validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NumMapTasks.Error", (String[])new String[0]) + "\n";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!StringUtil.isEmpty((String)validationErrors)) {
            this.openErrorDialog(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), validationErrors);
            return;
        }
        this.jobEntry.setName(this.jobEntryName);
        this.jobEntry.setHadoopJobName(this.hadoopJobName);
        this.jobEntry.setMapTrans(this.mapTrans);
        this.jobEntry.setMapInputStepName(this.mapTransInputStepName);
        this.jobEntry.setMapOutputStepName(this.mapTransOutputStepName);
        this.jobEntry.setCombinerTrans(this.combinerTrans);
        this.jobEntry.setCombinerInputStepName(this.combinerTransInputStepName);
        this.jobEntry.setCombinerOutputStepName(this.combinerTransOutputStepName);
        this.jobEntry.setCombiningSingleThreaded(this.combiningSingleThreaded);
        this.jobEntry.setReduceTrans(this.reduceTrans);
        this.jobEntry.setReduceInputStepName(this.reduceTransInputStepName);
        this.jobEntry.setReduceOutputStepName(this.reduceTransOutputStepName);
        this.jobEntry.setReducingSingleThreaded(this.reducingSingleThreaded);
        this.jobEntry.setBlocking(this.isBlocking());
        this.jobEntry.setLoggingInterval(this.loggingInterval);
        this.jobEntry.setInputPath(this.getInputPath());
        this.jobEntry.setInputFormatClass(this.getInputFormatClass());
        this.jobEntry.setOutputPath(this.getOutputPath());
        this.jobEntry.setCleanOutputPath(this.isCleanOutputPath());
        this.jobEntry.setSuppressOutputOfMapKey(this.isSuppressOutputOfMapKey());
        this.jobEntry.setSuppressOutputOfMapValue(this.isSuppressOutputOfMapValue());
        this.jobEntry.setSuppressOutputOfKey(this.isSuppressOutputOfKey());
        this.jobEntry.setSuppressOutputOfValue(this.isSuppressOutputOfValue());
        this.jobEntry.setOutputFormatClass(this.getOutputFormatClass());
        this.jobEntry.setNamedCluster(this.selectedNamedCluster);
        this.jobEntry.setNumMapTasks(this.getNumMapTasks());
        this.jobEntry.setNumReduceTasks(this.getNumReduceTasks());
        this.jobEntry.setUserDefined((List<UserDefinedItem>)this.userDefined);
        this.jobEntry.setChanged();
        this.cancel();
    }

    public void init() throws Throwable {
        if (this.jobEntry != null) {
            TransMeta transMeta;
            this.setName(this.jobEntry.getName());
            this.setJobEntryName(this.jobEntry.getName());
            this.setHadoopJobName(this.jobEntry.getHadoopJobName());
            VariableSpace varSpace = this.getVariableSpace();
            ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-hadoopjob-name");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-map-transformation");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-map-input-stepname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-map-output-stepname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-combiner-transformation");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-combiner-input-stepname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-combiner-output-stepname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-reduce-transformation");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-reduce-input-stepname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-reduce-output-stepname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-path");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("output-path");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-input-format");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-format");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-map-tasks");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-reduce-tasks");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("logging-interval");
            tempBox.setVariableSpace(varSpace);
            this.setCombinerTransInputStepName(this.jobEntry.getCombinerInputStepName());
            this.setCombinerTransOutputStepName(this.jobEntry.getCombinerOutputStepName());
            this.setCombiningSingleThreaded(this.jobEntry.isCombiningSingleThreaded());
            if (this.jobEntry.getMapTrans() != null || this.rep == null) {
                this.setMapTrans(this.jobEntry.getMapTrans());
            } else if (this.jobEntry.getMapRepositoryReference() != null) {
                try {
                    transMeta = this.rep.loadTransformation(this.jobEntry.getMapRepositoryReference(), null);
                    if (transMeta != null && transMeta.getRepositoryDirectory() != null) {
                        this.setMapTrans(this.buildRepositoryPath(transMeta.getRepositoryDirectory().getPath(), transMeta.getName()));
                    }
                }
                catch (KettleException e) {
                    this.setMapTrans(null);
                }
            } else {
                this.setMapTrans(this.buildRepositoryPath(this.jobEntry.getMapRepositoryDir(), this.jobEntry.getMapRepositoryFile()));
            }
            this.setMapTransInputStepName(this.jobEntry.getMapInputStepName());
            this.setMapTransOutputStepName(this.jobEntry.getMapOutputStepName());
            if (this.jobEntry.getCombinerTrans() != null || this.rep == null) {
                this.setCombinerTrans(this.jobEntry.getCombinerTrans());
            } else if (this.jobEntry.getCombinerRepositoryReference() != null) {
                try {
                    transMeta = this.rep.loadTransformation(this.jobEntry.getCombinerRepositoryReference(), null);
                    if (transMeta != null && transMeta.getRepositoryDirectory() != null) {
                        this.setCombinerTrans(this.buildRepositoryPath(transMeta.getRepositoryDirectory().getPath(), transMeta.getName()));
                    }
                }
                catch (KettleException e) {
                    this.setCombinerTrans(null);
                }
            } else {
                this.setCombinerTrans(this.buildRepositoryPath(this.jobEntry.getCombinerRepositoryDir(), this.jobEntry.getCombinerRepositoryFile()));
            }
            if (this.jobEntry.getReduceTrans() != null || this.rep == null) {
                this.setReduceTrans(this.jobEntry.getReduceTrans());
            } else if (this.jobEntry.getReduceRepositoryReference() != null) {
                try {
                    transMeta = this.rep.loadTransformation(this.jobEntry.getReduceRepositoryReference(), null);
                    if (transMeta != null && transMeta.getRepositoryDirectory() != null) {
                        this.setReduceTrans(this.buildRepositoryPath(transMeta.getRepositoryDirectory().getPath(), transMeta.getName()));
                    }
                }
                catch (KettleException e) {
                    this.setReduceTrans(null);
                }
            } else {
                this.setReduceTrans(this.buildRepositoryPath(this.jobEntry.getReduceRepositoryDir(), this.jobEntry.getReduceRepositoryFile()));
            }
            this.setReduceTransInputStepName(this.jobEntry.getReduceInputStepName());
            this.setReduceTransOutputStepName(this.jobEntry.getReduceOutputStepName());
            this.setReducingSingleThreaded(this.jobEntry.isReducingSingleThreaded());
            this.userDefined.clear();
            if (this.jobEntry.getUserDefined() != null) {
                this.userDefined.addAll(this.jobEntry.getUserDefined());
            }
            this.setBlocking(this.jobEntry.isBlocking());
            this.setLoggingInterval(this.jobEntry.getLoggingInterval());
            this.setInputPath(this.jobEntry.getInputPath());
            this.setInputFormatClass(this.jobEntry.getInputFormatClass());
            this.setOutputPath(this.jobEntry.getOutputPath());
            this.setCleanOutputPath(this.jobEntry.isCleanOutputPath());
            this.setSuppressOutputOfMapKey(this.jobEntry.getSuppressOutputOfMapKey());
            this.setSuppressOutputOfMapValue(this.jobEntry.getSuppressOutputOfMapValue());
            this.setSuppressOutputOfKey(this.jobEntry.getSuppressOutputOfKey());
            this.setSuppressOutputOfValue(this.jobEntry.getSuppressOutputOfValue());
            this.setOutputFormatClass(this.jobEntry.getOutputFormatClass());
            this.selectedNamedCluster = this.jobEntry.getNamedCluster();
            this.setNumMapTasks(this.jobEntry.getNumMapTasks());
            this.setNumReduceTasks(this.jobEntry.getNumReduceTasks());
            storageType = Spoon.getInstance().getRepository() != null ? REPOSITORY : LOCAL;
        }
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void closeErrorDialog() {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("hadoop-error-dialog");
        errorDialog.hide();
    }

    public void setRepository(Repository rep) {
        this.rep = rep;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public void cancel() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("job-entry-dialog");
        Shell shell = (Shell)xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            PropsUI.getInstance().setScreen(winprop);
            ((Composite)xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public void mapTransBrowse() {
        if (storageType.equalsIgnoreCase(LOCAL)) {
            this.browseLocalFilesystem(this::setMapTrans, this.mapTrans);
        } else if (storageType.equalsIgnoreCase(REPOSITORY)) {
            this.browseRepository(this::setMapTrans);
        }
    }

    public void combinerTransBrowse() {
        if (storageType.equalsIgnoreCase(LOCAL)) {
            this.browseLocalFilesystem(this::setCombinerTrans, this.mapTrans);
        } else if (storageType.equalsIgnoreCase(REPOSITORY)) {
            this.browseRepository(this::setCombinerTrans);
        }
    }

    public void reduceTransBrowse() {
        if (storageType.equalsIgnoreCase(LOCAL)) {
            this.browseLocalFilesystem(this::setReduceTrans, this.mapTrans);
        } else if (storageType.equalsIgnoreCase(REPOSITORY)) {
            this.browseRepository(this::setReduceTrans);
        }
    }

    public void browseLocalFilesystem(StringResultSetter setter, String originalTransformationName) {
        String fname;
        Shell shell = this.getJobEntryDialog();
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(Const.STRING_TRANS_FILTER_EXT);
        dialog.setFilterNames(Const.getTransformationFilterNames());
        String prevName = this.jobEntry.environmentSubstitute(originalTransformationName);
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)this.jobEntry.environmentSubstitute(this.jobEntry.getFilename())).getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty((String)prevName)) {
            try {
                if (KettleVFS.fileExists((String)prevName)) {
                    dialog.setFilterPath(KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)prevName).getParent()));
                } else {
                    if (!prevName.endsWith(".ktr")) {
                        prevName = "${Internal.Job.Filename.Directory}/" + Const.trim((String)originalTransformationName) + ".ktr";
                    }
                    if (KettleVFS.fileExists((String)prevName)) {
                        setter.set(prevName);
                        return;
                    }
                }
            }
            catch (Exception e) {
                dialog.setFilterPath(parentFolder);
            }
        } else if (!StringUtils.isEmpty(parentFolder)) {
            dialog.setFilterPath(parentFolder);
        }
        if ((fname = dialog.open()) != null) {
            File file = new File(fname);
            String name = file.getName();
            String parentFolderSelection = file.getParentFile().toString();
            if (!StringUtils.isEmpty((String)parentFolder) && parentFolder.equals(parentFolderSelection)) {
                setter.set("${Internal.Job.Filename.Directory}/" + name);
            } else {
                setter.set(fname);
            }
        }
    }

    private void browseRepository(StringResultSetter transSetter) {
        Shell shell;
        SelectObjectDialog sod;
        String transname;
        if (this.rep != null && (transname = (sod = new SelectObjectDialog(shell = this.getJobEntryDialog(), this.rep, true, false)).open()) != null && transSetter != null) {
            transSetter.set(this.buildRepositoryPath(sod.getDirectory().getPath(), sod.getObjectName()));
        }
    }

    private String buildRepositoryPath(String dir, String file) {
        if (dir == null || file == null) {
            return "";
        }
        if (dir.endsWith("/")) {
            return dir + file;
        }
        return dir + "/" + file;
    }

    public void newUserDefinedItem() {
        this.userDefined.add((Object)new UserDefinedItem());
    }

    public AbstractModelList<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public String getName() {
        return "jobEntryController";
    }

    public String getJobEntryName() {
        return this.jobEntryName;
    }

    public void setJobEntryName(String jobEntryName) {
        String previousVal = this.jobEntryName;
        String newVal = jobEntryName;
        this.jobEntryName = jobEntryName;
        this.firePropertyChange(JOB_ENTRY_NAME, previousVal, newVal);
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        String previousVal = this.hadoopJobName;
        String newVal = hadoopJobName;
        this.hadoopJobName = hadoopJobName;
        this.firePropertyChange(HADOOP_JOB_NAME, previousVal, newVal);
    }

    public String getMapTrans() {
        return this.mapTrans;
    }

    public void setMapTrans(String mapTrans) {
        String previousVal = this.mapTrans;
        String newVal = mapTrans;
        this.mapTrans = mapTrans;
        this.firePropertyChange(MAP_TRANS, previousVal, newVal);
    }

    public String getCombinerTrans() {
        return this.combinerTrans;
    }

    public void setCombinerTrans(String combinerTrans) {
        String previousVal = this.combinerTrans;
        String newVal = combinerTrans;
        this.combinerTrans = combinerTrans;
        this.firePropertyChange(COMBINER_TRANS, previousVal, newVal);
    }

    public String getReduceTrans() {
        return this.reduceTrans;
    }

    public void setReduceTrans(String reduceTrans) {
        String previousVal = this.reduceTrans;
        String newVal = reduceTrans;
        this.reduceTrans = reduceTrans;
        this.firePropertyChange(REDUCE_TRANS, previousVal, newVal);
    }

    public String getMapTransInputStepName() {
        return this.mapTransInputStepName;
    }

    public void setMapTransInputStepName(String mapTransInputStepName) {
        String previousVal = this.mapTransInputStepName;
        String newVal = mapTransInputStepName;
        this.mapTransInputStepName = mapTransInputStepName;
        this.firePropertyChange(MAP_TRANS_INPUT_STEP_NAME, previousVal, newVal);
    }

    public String getMapTransOutputStepName() {
        return this.mapTransOutputStepName;
    }

    public void setMapTransOutputStepName(String mapTransOutputStepName) {
        String previousVal = this.mapTransOutputStepName;
        String newVal = mapTransOutputStepName;
        this.mapTransOutputStepName = mapTransOutputStepName;
        this.firePropertyChange(MAP_TRANS_OUTPUT_STEP_NAME, previousVal, newVal);
    }

    public String getCombinerTransInputStepName() {
        return this.combinerTransInputStepName;
    }

    public void setCombinerTransInputStepName(String combinerTransInputStepName) {
        String previousVal = this.combinerTransInputStepName;
        String newVal = combinerTransInputStepName;
        this.combinerTransInputStepName = combinerTransInputStepName;
        this.firePropertyChange(COMBINER_TRANS_INPUT_STEP_NAME, previousVal, newVal);
    }

    public String getCombinerTransOutputStepName() {
        return this.combinerTransOutputStepName;
    }

    public void setCombinerTransOutputStepName(String combinerTransOutputStepName) {
        String previousVal = this.combinerTransOutputStepName;
        String newVal = combinerTransOutputStepName;
        this.combinerTransOutputStepName = combinerTransOutputStepName;
        this.firePropertyChange(COMBINER_TRANS_OUTPUT_STEP_NAME, previousVal, newVal);
    }

    public String getReduceTransInputStepName() {
        return this.reduceTransInputStepName;
    }

    public void setReduceTransInputStepName(String reduceTransInputStepName) {
        String previousVal = this.reduceTransInputStepName;
        String newVal = reduceTransInputStepName;
        this.reduceTransInputStepName = reduceTransInputStepName;
        this.firePropertyChange(REDUCE_TRANS_INPUT_STEP_NAME, previousVal, newVal);
    }

    public String getReduceTransOutputStepName() {
        return this.reduceTransOutputStepName;
    }

    public void setReduceTransOutputStepName(String reduceTransOutputStepName) {
        String previousVal = this.reduceTransOutputStepName;
        String newVal = reduceTransOutputStepName;
        this.reduceTransOutputStepName = reduceTransOutputStepName;
        this.firePropertyChange(REDUCE_TRANS_OUTPUT_STEP_NAME, previousVal, newVal);
    }

    public void invertBlocking() {
        this.setBlocking(!this.isBlocking());
    }

    public JobEntryHadoopTransJobExecutor getJobEntry() {
        return this.jobEntry;
    }

    public void setJobEntry(JobEntryHadoopTransJobExecutor jobEntry) {
        this.jobEntry = jobEntry;
    }

    public void invertSuppressOutputOfMapKey() {
        this.setSuppressOutputOfMapKey(!this.isSuppressOutputOfMapKey());
    }

    public boolean isSuppressOutputOfMapKey() {
        return this.suppressOutputMapKey;
    }

    public void setSuppressOutputOfMapKey(boolean suppress) {
        boolean previousVal = this.suppressOutputMapKey;
        boolean newVal = suppress;
        this.suppressOutputMapKey = suppress;
        this.firePropertyChange(SUPPRESS_OUTPUT_MAP_KEY, previousVal, newVal);
    }

    public void invertSuppressOutputOfMapValue() {
        this.setSuppressOutputOfMapValue(!this.isSuppressOutputOfMapValue());
    }

    public boolean isSuppressOutputOfMapValue() {
        return this.suppressOutputMapValue;
    }

    public void setSuppressOutputOfMapValue(boolean suppress) {
        boolean previousVal = this.suppressOutputMapValue;
        boolean newVal = suppress;
        this.suppressOutputMapValue = suppress;
        this.firePropertyChange(SUPPRESS_OUTPUT_MAP_VALUE, previousVal, newVal);
    }

    public void invertSuppressOutputOfKey() {
        this.setSuppressOutputOfKey(!this.isSuppressOutputOfKey());
    }

    public boolean isSuppressOutputOfKey() {
        return this.suppressOutputKey;
    }

    public void setSuppressOutputOfKey(boolean suppress) {
        boolean previousVal = this.suppressOutputKey;
        boolean newVal = suppress;
        this.suppressOutputKey = suppress;
        this.firePropertyChange(SUPPRESS_OUTPUT_KEY, previousVal, newVal);
    }

    public void invertSuppressOutputOfValue() {
        this.setSuppressOutputOfValue(!this.isSuppressOutputOfValue());
    }

    public boolean isSuppressOutputOfValue() {
        return this.suppressOutputValue;
    }

    public void setSuppressOutputOfValue(boolean suppress) {
        boolean previousVal = this.suppressOutputValue;
        boolean newVal = suppress;
        this.suppressOutputValue = suppress;
        this.firePropertyChange(SUPPRESS_OUTPUT_VALUE, previousVal, newVal);
    }

    public String getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        String previousVal = this.inputFormatClass;
        String newVal = inputFormatClass;
        this.inputFormatClass = inputFormatClass;
        this.firePropertyChange(INPUT_FORMAT_CLASS, previousVal, newVal);
    }

    public String getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public void setOutputFormatClass(String outputFormatClass) {
        String previousVal = this.outputFormatClass;
        String newVal = outputFormatClass;
        this.outputFormatClass = outputFormatClass;
        this.firePropertyChange(OUTPUT_FORMAT_CLASS, previousVal, newVal);
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        String previousVal = this.inputPath;
        String newVal = inputPath;
        this.inputPath = inputPath;
        this.firePropertyChange(INPUT_PATH, previousVal, newVal);
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        String previousVal = this.outputPath;
        String newVal = outputPath;
        this.outputPath = outputPath;
        this.firePropertyChange(OUTPUT_PATH, previousVal, newVal);
    }

    public void invertCleanOutputPath() {
        this.setCleanOutputPath(!this.isCleanOutputPath());
    }

    public boolean isCleanOutputPath() {
        return this.cleanOutputPath;
    }

    public void setCleanOutputPath(boolean cleanOutputPath) {
        boolean old = this.cleanOutputPath;
        this.cleanOutputPath = cleanOutputPath;
        this.firePropertyChange(CLEAN_OUTPUT_PATH, old, this.cleanOutputPath);
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        boolean previousVal = this.blocking;
        boolean newVal = blocking;
        this.blocking = blocking;
        this.firePropertyChange(BLOCKING, previousVal, newVal);
    }

    public void setReducingSingleThreaded(boolean reducingSingleThreaded) {
        boolean previousVal = this.reducingSingleThreaded;
        boolean newVal = reducingSingleThreaded;
        this.reducingSingleThreaded = reducingSingleThreaded;
        this.firePropertyChange(REDUCING_SINGLE_THREADED, previousVal, newVal);
    }

    public String getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        String previousVal = this.loggingInterval;
        String newVal = loggingInterval;
        this.loggingInterval = loggingInterval;
        this.firePropertyChange(LOGGING_INTERVAL, previousVal, newVal);
    }

    public String getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(String numMapTasks) {
        String previousVal = this.numMapTasks;
        String newVal = numMapTasks;
        this.numMapTasks = numMapTasks;
        this.firePropertyChange(NUM_MAP_TASKS, previousVal, newVal);
    }

    public String getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(String numReduceTasks) {
        String previousVal = this.numReduceTasks;
        String newVal = numReduceTasks;
        this.numReduceTasks = numReduceTasks;
        this.firePropertyChange(NUM_REDUCE_TASKS, previousVal, newVal);
    }

    public List<NamedCluster> getNamedClusters() throws MetaStoreException {
        return this.namedClusterService.list(this.jobMeta.getMetaStore());
    }

    public void setNamedClusters(List<NamedCluster> namedClusters) {
        this.namedClusters = namedClusters;
    }

    public void openErrorDialog(String title, String message) {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("hadoop-error-dialog");
        errorDialog.setTitle(title);
        XulTextbox errorMessage = (XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("hadoop-error-message");
        errorMessage.setValue(message);
        errorDialog.show();
    }

    public void invertReducingSingleThreaded() {
        this.setReducingSingleThreaded(!this.isReducingSingleThreaded());
    }

    public boolean isReducingSingleThreaded() {
        return this.reducingSingleThreaded;
    }

    public void invertCombiningSingleThreaded() {
        this.setCombiningSingleThreaded(!this.isCombiningSingleThreaded());
    }

    public boolean isCombiningSingleThreaded() {
        return this.combiningSingleThreaded;
    }

    public void setCombiningSingleThreaded(boolean combiningSingleThreaded) {
        boolean old = this.combiningSingleThreaded;
        this.combiningSingleThreaded = combiningSingleThreaded;
        this.firePropertyChange(COMBINING_SINGLE_THREADED, old, this.combiningSingleThreaded);
    }

    public void help() {
        Shell shell = this.getJobEntryDialog();
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, this.jobEntry.getPluginId());
        HelpUtils.openHelpDialog((Shell)shell, (PluginInterface)plugin);
    }

    public void editNamedCluster() throws MetaStoreException {
        String newNcName;
        if (this.isSelectedNamedCluster() && (newNcName = this.ncDelegate.editNamedCluster(null, this.getSelectedNamedCluster(), this.getJobEntryDialog())) != null) {
            this.namedClustersChanged();
            this.selectedNamedClusterChanged(this.getNamedClusterName(this.getSelectedNamedCluster()), newNcName);
        }
    }

    public void newNamedCluster() throws MetaStoreException {
        String newNcName = this.ncDelegate.newNamedCluster((VariableSpace)this.jobMeta, null, this.getJobEntryDialog());
        if (newNcName != null) {
            this.namedClustersChanged();
            this.selectedNamedClusterChanged(this.getNamedClusterName(this.getSelectedNamedCluster()), newNcName);
        }
    }

    private Shell getJobEntryDialog() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("job-entry-dialog");
        Shell shell = (Shell)xulDialog.getRootObject();
        return shell;
    }

    private String getNamedClusterName(NamedCluster namedCluster) {
        return namedCluster != null ? namedCluster.getName() : null;
    }

    @VisibleForTesting
    void namedClustersChanged() throws MetaStoreException {
        this.firePropertyChange("namedClusters", null, this.getNamedClusters());
    }

    @VisibleForTesting
    void selectedNamedClusterChanged(String ncVal, String newNcVal) throws MetaStoreException {
        if (newNcVal != null) {
            ncVal = newNcVal;
        }
        if (ncVal != null) {
            for (NamedCluster nc : this.getNamedClusters()) {
                if (!nc.getName().equals(ncVal)) continue;
                this.firePropertyChange("selectedNamedCluster", null, nc);
                return;
            }
        }
    }

    public void setSelectedNamedCluster(NamedCluster namedCluster) {
        this.selectedNamedCluster = namedCluster;
    }

    public NamedCluster getSelectedNamedCluster() {
        return this.selectedNamedCluster;
    }

    public boolean isSelectedNamedCluster() {
        return this.selectedNamedCluster != null;
    }

    private static interface ObjectIdResultSetter {
        public void set(ObjectId var1);
    }

    private static interface StringResultSetter {
        public void set(String var1);
    }
}

