/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.ui.entry.hadoop;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.dom4j.DocumentException;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.hadoop.JobEntryHadoopJobExecutor;
import org.pentaho.big.data.kettle.plugins.mapreduce.ui.entry.hadoop.JobEntryHadoopJobExecutorController;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEntryHadoopJobExecutorDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static final Class<?> CLZ = JobEntryHadoopJobExecutor.class;
    private static final Logger logger = LoggerFactory.getLogger(JobEntryHadoopJobExecutorDialog.class);
    private final NamedClusterService namedClusterService;
    private final JobEntryHadoopJobExecutorController controller;
    private JobEntryHadoopJobExecutor jobEntry;
    private XulDomContainer container;
    private BindingFactory bf;
    private ResourceBundle bundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)CLZ, (String)key, (String[])new String[0]);
        }
    };

    public JobEntryHadoopJobExecutorDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) throws XulException, DocumentException, Throwable {
        super(parent, jobEntry, rep, jobMeta);
        this.jobEntry = (JobEntryHadoopJobExecutor)jobEntry;
        this.namedClusterService = this.jobEntry.getNamedClusterService();
        this.controller = new JobEntryHadoopJobExecutorController(new HadoopClusterDelegateImpl(Spoon.getInstance(), this.namedClusterService, this.jobEntry.getRuntimeTestActionService(), this.jobEntry.getRuntimeTester()), this.namedClusterService, this.jobEntry.getNamedClusterServiceLocator());
        SwtXulLoader swtXulLoader = new SwtXulLoader();
        swtXulLoader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
        swtXulLoader.register("VARIABLETEXTBOX", "org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox");
        swtXulLoader.register("VARIABLEMENULIST", "org.pentaho.di.ui.core.database.dialog.tags.ExtMenuList");
        swtXulLoader.setOuterContext((Object)this.shell);
        this.container = swtXulLoader.loadXul("org/pentaho/big/data/kettle/plugins/mapreduce/ui/entry/JobEntryHadoopJobExecutorDialog.xul", (Object)this.bundle);
        SwtXulRunner runner = new SwtXulRunner();
        runner.addContainer(this.container);
        this.container.addEventHandler((XulEventHandler)this.controller);
        this.bf = new DefaultBindingFactory();
        this.bf.setDocument(this.container.getDocumentRoot());
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding("jobentry-name", "value", (Object)this.controller, "jobEntryName", new BindingConvertor[0]);
        this.bf.createBinding("jobentry-hadoopjob-name", "value", (Object)this.controller, "hadoopJobName", new BindingConvertor[0]);
        this.bf.createBinding("jar-url", "value", (Object)this.controller, "jarUrl", new BindingConvertor[0]);
        this.bf.createBinding("driver-class", "value", (Object)this.controller, "driverClass", new BindingConvertor[0]);
        this.bf.createBinding("driver-class", "selectedItem", (Object)this.controller, "driverClass", new BindingConvertor[0]);
        this.bf.createBinding("driver-class", "elements", (Object)this.controller, "driverClasses", new BindingConvertor[0]);
        this.bf.createBinding("command-line-arguments", "value", (Object)this.controller.getSimpleConfiguration(), "commandLineArgs", new BindingConvertor[0]);
        this.bf.createBinding("classes-output-key-class", "value", (Object)this.controller.getAdvancedConfiguration(), "outputKeyClass", new BindingConvertor[0]);
        this.bf.createBinding("classes-output-value-class", "value", (Object)this.controller.getAdvancedConfiguration(), "outputValueClass", new BindingConvertor[0]);
        this.bf.createBinding("classes-mapper-class", "value", (Object)this.controller.getAdvancedConfiguration(), "mapperClass", new BindingConvertor[0]);
        this.bf.createBinding("classes-combiner-class", "value", (Object)this.controller.getAdvancedConfiguration(), "combinerClass", new BindingConvertor[0]);
        this.bf.createBinding("classes-reducer-class", "value", (Object)this.controller.getAdvancedConfiguration(), "reducerClass", new BindingConvertor[0]);
        this.bf.createBinding("classes-input-format", "value", (Object)this.controller.getAdvancedConfiguration(), "inputFormatClass", new BindingConvertor[0]);
        this.bf.createBinding("classes-output-format", "value", (Object)this.controller.getAdvancedConfiguration(), "outputFormatClass", new BindingConvertor[0]);
        this.bf.createBinding("num-map-tasks", "value", (Object)this.controller.getAdvancedConfiguration(), "numMapTasks", new BindingConvertor[0]);
        this.bf.createBinding("num-reduce-tasks", "value", (Object)this.controller.getAdvancedConfiguration(), "numReduceTasks", new BindingConvertor[0]);
        this.bf.createBinding("simple-blocking", "selected", (Object)this.controller.getSimpleConfiguration(), "simpleBlocking", new BindingConvertor[0]);
        this.bf.createBinding("blocking", "selected", (Object)this.controller.getAdvancedConfiguration(), "blocking", new BindingConvertor[0]);
        this.bf.createBinding("simple-logging-interval", "value", (Object)this.controller.getSimpleConfiguration(), "simpleLoggingInterval", new BindingConvertor[0]);
        this.bf.createBinding("logging-interval", "value", (Object)this.controller.getAdvancedConfiguration(), "loggingInterval", new BindingConvertor[0]);
        this.bf.createBinding("input-path", "value", (Object)this.controller.getAdvancedConfiguration(), "inputPath", new BindingConvertor[0]);
        this.bf.createBinding("output-path", "value", (Object)this.controller.getAdvancedConfiguration(), "outputPath", new BindingConvertor[0]);
        ((XulRadio)this.container.getDocumentRoot().getElementById("simpleRadioButton")).setSelected(this.jobEntry.isSimple());
        ((XulRadio)this.container.getDocumentRoot().getElementById("advancedRadioButton")).setSelected(!this.jobEntry.isSimple());
        ((XulVbox)this.container.getDocumentRoot().getElementById("advanced-configuration")).setVisible(!this.jobEntry.isSimple());
        XulTextbox simpleLoggingInterval = (XulTextbox)this.container.getDocumentRoot().getElementById("simple-logging-interval");
        simpleLoggingInterval.setValue("" + this.controller.getSimpleConfiguration().getSimpleLoggingInterval());
        XulTextbox loggingInterval = (XulTextbox)this.container.getDocumentRoot().getElementById("logging-interval");
        loggingInterval.setValue(this.controller.getAdvancedConfiguration().getLoggingInterval());
        XulTextbox mapTasks = (XulTextbox)this.container.getDocumentRoot().getElementById("num-map-tasks");
        mapTasks.setValue(this.controller.getAdvancedConfiguration().getNumMapTasks());
        XulTextbox reduceTasks = (XulTextbox)this.container.getDocumentRoot().getElementById("num-reduce-tasks");
        reduceTasks.setValue(this.controller.getAdvancedConfiguration().getNumReduceTasks());
        XulTree variablesTree = (XulTree)this.container.getDocumentRoot().getElementById("fields-table");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding(this.controller.getUserDefined(), "children", (Object)variablesTree, "elements", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.controller.setJobMeta(jobMeta);
        this.controller.setJobEntry((JobEntryHadoopJobExecutor)jobEntry);
        this.controller.init();
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.controller, "namedClusters", "named-clusters", "elements", new BindingConvertor[0]).fireSourceChanged();
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding("named-clusters", "selectedIndex", (Object)this.controller.getAdvancedConfiguration(), "selectedNamedCluster", new BindingConvertor[]{new BindingConvertor<Integer, NamedCluster>(){

            public NamedCluster sourceToTarget(Integer index) {
                List<Object> clusters = new ArrayList();
                try {
                    clusters = JobEntryHadoopJobExecutorDialog.this.controller.getNamedClusters();
                }
                catch (MetaStoreException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (index == -1 || clusters.isEmpty()) {
                    return null;
                }
                return (NamedCluster)clusters.get(index);
            }

            public Integer targetToSource(NamedCluster value) {
                return null;
            }
        }}).fireSourceChanged();
        this.selectNamedCluster();
    }

    private void selectNamedCluster() {
        XulMenuList namedClusterMenu = (XulMenuList)this.container.getDocumentRoot().getElementById("named-clusters");
        NamedCluster namedCluster = this.jobEntry.getNamedCluster();
        if (namedCluster != null && this.isKnownNamedCluster(namedCluster, this.controller)) {
            namedClusterMenu.setSelectedItem((Object)namedCluster);
            this.controller.getAdvancedConfiguration().setSelectedNamedCluster(namedCluster);
        }
    }

    public JobEntryInterface open() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("job-entry-dialog");
        dialog.show();
        return this.jobEntry;
    }

    private boolean isKnownNamedCluster(NamedCluster jobNameCluster, JobEntryHadoopJobExecutorController controller) {
        boolean result = false;
        if (jobNameCluster != null) {
            String jncName = jobNameCluster.getName();
            List<NamedCluster> nClusters = null;
            try {
                nClusters = controller.getNamedClusters();
            }
            catch (MetaStoreException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (jncName != null && nClusters != null) {
                for (NamedCluster nc : nClusters) {
                    if (jncName == null || !jncName.equals(nc.getName())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}

