/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.entry.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.pentaho.big.data.kettle.plugins.mapreduce.DialogClassUtil;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.NamedClusterLoadSaveUtil;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.UserDefinedItem;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.pmr.JobEntryHadoopTransJobExecutor;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobAdvanced;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobBuilder;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobSimple;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceService;
import org.pentaho.hadoop.shim.api.mapreduce.TaskCompletionEvent;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@JobEntry(id="HadoopJobExecutorPlugin", image="HDE.svg", name="HadoopJobExecutorPlugin.Name", description="HadoopJobExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.big.data.kettle.plugins.mapreduce", documentationUrl=" https://pentaho-community.atlassian.net/wiki/display/EAI/Hadoop+Job+Executor")
public class JobEntryHadoopJobExecutor
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static final String DEFAULT_LOGGING_INTERVAL = "60";
    public static final String CLUSTER_NAME = "cluster_name";
    public static final String HDFS_HOSTNAME = "hdfs_hostname";
    public static final String HDFS_PORT = "hdfs_port";
    public static final String JOB_TRACKER_HOSTNAME = "job_tracker_hostname";
    public static final String JOB_TRACKER_PORT = "job_tracker_port";
    private static Class<?> PKG = JobEntryHadoopJobExecutor.class;
    public static final String DIALOG_NAME = DialogClassUtil.getDialogClassName(PKG);
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final NamedClusterLoadSaveUtil namedClusterLoadSaveUtil = new NamedClusterLoadSaveUtil();
    private String hadoopJobName;
    private String jarUrl = "";
    private String driverClass = "";
    private boolean isSimple = true;
    private String cmdLineArgs;
    private String outputKeyClass;
    private String outputValueClass;
    private String mapperClass;
    private String combinerClass;
    private String reducerClass;
    private String inputFormatClass;
    private String outputFormatClass;
    private NamedCluster namedCluster;
    private String inputPath;
    private String outputPath;
    private boolean blocking;
    private String loggingInterval;
    private boolean simpleBlocking;
    private String simpleLoggingInterval = this.loggingInterval = "60";
    private String numMapTasks = "1";
    private String numReduceTasks = "1";
    private List<UserDefinedItem> userDefined = new ArrayList<UserDefinedItem>();

    public JobEntryHadoopJobExecutor(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedClusterServiceLocator namedClusterServiceLocator) {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        this.hadoopJobName = hadoopJobName;
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public void setJarUrl(String jarUrl) {
        this.jarUrl = jarUrl;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public String getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public void setCmdLineArgs(String cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
    }

    public String getOutputKeyClass() {
        return this.outputKeyClass;
    }

    public void setOutputKeyClass(String outputKeyClass) {
        this.outputKeyClass = outputKeyClass;
    }

    public String getOutputValueClass() {
        return this.outputValueClass;
    }

    public void setOutputValueClass(String outputValueClass) {
        this.outputValueClass = outputValueClass;
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String mapperClass) {
        this.mapperClass = mapperClass;
    }

    public String getCombinerClass() {
        return this.combinerClass;
    }

    public void setCombinerClass(String combinerClass) {
        this.combinerClass = combinerClass;
    }

    public String getReducerClass() {
        return this.reducerClass;
    }

    public void setReducerClass(String reducerClass) {
        this.reducerClass = reducerClass;
    }

    public String getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public String getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public void setOutputFormatClass(String outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public String getLoggingInterval() {
        return this.loggingInterval == null ? DEFAULT_LOGGING_INTERVAL : this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public List<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(List<UserDefinedItem> userDefined) {
        this.userDefined = userDefined;
    }

    public String getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(String numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public String getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(String numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public Result execute(Result result, int arg1) throws KettleException {
        block28: {
            result.setNrErrors(0L);
            this.log.setLogLevel(this.parentJob.getLogLevel());
            try {
                URL resolvedJarUrl = this.resolveJarUrl(this.jarUrl);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.ResolvedJar", (String[])new String[]{resolvedJarUrl.toExternalForm()}));
                }
                MapReduceService mapReduceService = (MapReduceService)this.namedClusterServiceLocator.getService(this.namedCluster, MapReduceService.class);
                if (this.isSimple) {
                    String simpleLoggingIntervalS = this.environmentSubstitute(this.getSimpleLoggingInterval());
                    int simpleLogInt = 60;
                    try {
                        simpleLogInt = Integer.parseInt(simpleLoggingIntervalS, 10);
                    }
                    catch (NumberFormatException e) {
                        this.logError(BaseMessages.getString(PKG, (String)"ErrorParsingLogInterval", (Object[])new Object[]{simpleLoggingIntervalS, simpleLogInt}));
                    }
                    MapReduceJobSimple mapReduceJobSimple = mapReduceService.executeSimple(resolvedJarUrl, this.environmentSubstitute(this.driverClass), this.environmentSubstitute(this.cmdLineArgs));
                    String mainClass = mapReduceJobSimple.getMainClass();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.UsingDriverClass", (String[])new String[]{mainClass == null ? "null" : mainClass}));
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.SimpleMode", (String[])new String[0]));
                    }
                    if (this.simpleBlocking) {
                        boolean done = false;
                        do {
                            done = mapReduceJobSimple.waitOnCompletion((long)simpleLogInt, TimeUnit.SECONDS, new MapReduceService.Stoppable(){

                                public boolean isStopped() {
                                    return JobEntryHadoopJobExecutor.this.parentJob.isStopped();
                                }
                            });
                            this.logDetailed(BaseMessages.getString(JobEntryHadoopJobExecutor.class, (String)"JobEntryHadoopJobExecutor.Blocking", (String[])new String[]{mainClass}));
                        } while (!this.parentJob.isStopped() && !done);
                        if (!done) {
                            mapReduceJobSimple.killJob();
                        }
                        if (!mapReduceJobSimple.isSuccessful()) {
                            result.setStopped(true);
                            result.setNrErrors(1L);
                            result.setResult(false);
                            this.log.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.FailedToExecuteClass", (Object[])new Object[]{mainClass, mapReduceJobSimple.getStatus()}));
                        }
                    }
                    break block28;
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.AdvancedMode", (String[])new String[0]));
                }
                MapReduceJobBuilder jobBuilder = mapReduceService.createJobBuilder(this.log, this.variables);
                jobBuilder.setResolvedJarUrl(resolvedJarUrl);
                jobBuilder.setJarUrl(this.environmentSubstitute(this.jarUrl));
                jobBuilder.setHadoopJobName(this.environmentSubstitute(this.hadoopJobName));
                jobBuilder.setOutputKeyClass(this.environmentSubstitute(this.outputKeyClass));
                jobBuilder.setOutputValueClass(this.environmentSubstitute(this.outputValueClass));
                if (this.mapperClass != null) {
                    jobBuilder.setMapperClass(this.environmentSubstitute(this.mapperClass));
                }
                if (this.combinerClass != null) {
                    jobBuilder.setCombinerClass(this.environmentSubstitute(this.combinerClass));
                }
                if (this.reducerClass != null) {
                    jobBuilder.setReducerClass(this.environmentSubstitute(this.reducerClass));
                }
                if (this.inputFormatClass != null) {
                    jobBuilder.setInputFormatClass(this.environmentSubstitute(this.inputFormatClass));
                }
                if (this.outputFormatClass != null) {
                    jobBuilder.setOutputFormatClass(this.environmentSubstitute(this.outputFormatClass));
                }
                jobBuilder.setInputPaths(JobEntryHadoopTransJobExecutor.splitInputPaths(this.inputPath, this.variables));
                jobBuilder.setOutputPath(this.environmentSubstitute(this.outputPath));
                for (UserDefinedItem item : this.userDefined) {
                    if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                    String nameS = this.environmentSubstitute(item.getName());
                    String valueS = this.environmentSubstitute(item.getValue());
                    jobBuilder.set(nameS, valueS);
                }
                String numMapTasksS = this.environmentSubstitute(this.numMapTasks);
                String numReduceTasksS = this.environmentSubstitute(this.numReduceTasks);
                int numM = 1;
                try {
                    numM = Integer.parseInt(numMapTasksS);
                }
                catch (NumberFormatException e) {
                    this.logError("Can't parse number of map tasks '" + numMapTasksS + "'. Setting nummap tasks to 1");
                }
                int numR = 1;
                try {
                    numR = Integer.parseInt(numReduceTasksS);
                }
                catch (NumberFormatException e) {
                    this.logError("Can't parse number of reduce tasks '" + numReduceTasksS + "'. Setting numreduce tasks to 1");
                }
                jobBuilder.setNumMapTasks(numM);
                jobBuilder.setNumReduceTasks(numR);
                MapReduceJobAdvanced mapReduceJobAdvanced = jobBuilder.submit();
                String loggingIntervalS = this.environmentSubstitute(this.getLoggingInterval());
                int logIntv = 60;
                try {
                    logIntv = Integer.parseInt(loggingIntervalS);
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ErrorParsingLogInterval", (Object[])new Object[]{loggingIntervalS, logIntv}));
                }
                if (!this.blocking) break block28;
                try {
                    int taskCompletionEventIndex = 0;
                    while (!mapReduceJobAdvanced.waitOnCompletion(logIntv >= 1 ? (long)logIntv : 60L, TimeUnit.SECONDS, new MapReduceService.Stoppable(){

                        public boolean isStopped() {
                            return JobEntryHadoopJobExecutor.this.parentJob.isStopped();
                        }
                    })) {
                        if (logIntv < 1) continue;
                        this.printJobStatus(mapReduceJobAdvanced);
                        taskCompletionEventIndex = this.logTaskMessages(mapReduceJobAdvanced, taskCompletionEventIndex);
                    }
                    if (this.parentJob.isStopped() && !mapReduceJobAdvanced.isComplete()) {
                        mapReduceJobAdvanced.killJob();
                        result.setResult(false);
                    }
                    this.printJobStatus(mapReduceJobAdvanced);
                    this.logTaskMessages(mapReduceJobAdvanced, taskCompletionEventIndex);
                }
                catch (InterruptedException ie) {
                    this.logError(ie.getMessage(), ie);
                }
                result.setResult(mapReduceJobAdvanced.isSuccessful());
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.setStopped(true);
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError(t.getMessage(), t);
            }
        }
        return result;
    }

    @VisibleForTesting
    URL resolveJarUrl(String jarUrl) throws MalformedURLException {
        return JobEntryHadoopJobExecutor.resolveJarUrl(jarUrl, (VariableSpace)this);
    }

    public static URL resolveJarUrl(String jarUrl, VariableSpace variableSpace) throws MalformedURLException {
        String jarUrlS = variableSpace.environmentSubstitute(jarUrl);
        if (jarUrlS.indexOf("://") == -1) {
            File jarFile = new File(jarUrlS);
            return jarFile.toURI().toURL();
        }
        return new URL(jarUrlS);
    }

    private int logTaskMessages(MapReduceJobAdvanced runningJob, int startIndex) throws IOException {
        TaskCompletionEvent[] tcEvents = runningJob.getTaskCompletionEvents(startIndex);
        block5: for (int i = 0; i < tcEvents.length; ++i) {
            String[] diags = runningJob.getTaskDiagnostics(tcEvents[i].getTaskAttemptId());
            StringBuilder diagsOutput = new StringBuilder();
            if (diags != null && diags.length > 0) {
                diagsOutput.append(Const.CR);
                for (String s : diags) {
                    diagsOutput.append(s);
                    diagsOutput.append(Const.CR);
                }
            }
            switch (tcEvents[i].getTaskStatus()) {
                case KILLED: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.KILLED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block5;
                }
                case FAILED: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.FAILED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block5;
                }
                case SUCCEEDED: {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.SUCCEEDED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                }
            }
        }
        return tcEvents.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMainMethod(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Object[] objectArray;
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            Method mainMethod = clazz.getMethod("main", String[].class);
            String commandLineArgs = this.environmentSubstitute(this.cmdLineArgs);
            if (commandLineArgs != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = commandLineArgs.split(" ");
            } else {
                objectArray = new Object[]{};
            }
            Object[] args = objectArray;
            mainMethod.invoke(null, args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void printJobStatus(MapReduceJobAdvanced runningJob) throws IOException {
        if (this.log.isBasic()) {
            double setupPercent = runningJob.getSetupProgress() * 100.0;
            double mapPercent = runningJob.getMapProgress() * 100.0;
            double reducePercent = runningJob.getReduceProgress() * 100.0;
            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.RunningPercent", (Object[])new Object[]{setupPercent, mapPercent, reducePercent}));
        }
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.isSimple = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"simple"));
        this.jarUrl = XMLHandler.getTagValue((Node)entrynode, (String)"jar_url");
        this.driverClass = XMLHandler.getTagValue((Node)entrynode, (String)"driver_class");
        this.cmdLineArgs = XMLHandler.getTagValue((Node)entrynode, (String)"command_line_args");
        this.simpleBlocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"simple_blocking"));
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.simpleLoggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"simple_logging_interval");
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
        this.mapperClass = XMLHandler.getTagValue((Node)entrynode, (String)"mapper_class");
        this.combinerClass = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_class");
        this.reducerClass = XMLHandler.getTagValue((Node)entrynode, (String)"reducer_class");
        this.inputPath = XMLHandler.getTagValue((Node)entrynode, (String)"input_path");
        this.inputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"input_format_class");
        this.outputPath = XMLHandler.getTagValue((Node)entrynode, (String)"output_path");
        this.outputKeyClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_key_class");
        this.outputValueClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_value_class");
        this.outputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_format_class");
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, null, rep, metaStore, entrynode, this.log);
        this.setRepository(rep);
        this.numMapTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_map_tasks");
        this.numReduceTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_reduce_tasks");
        this.userDefined = new ArrayList<UserDefinedItem>();
        Node userDefinedList = XMLHandler.getSubNode((Node)entrynode, (String)"user_defined_list");
        int nrUserDefined = XMLHandler.countNodes((Node)userDefinedList, (String)"user_defined");
        for (int i = 0; i < nrUserDefined; ++i) {
            Node userDefinedNode = XMLHandler.getSubNodeByNr((Node)userDefinedList, (String)"user_defined", (int)i);
            String name = XMLHandler.getTagValue((Node)userDefinedNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)userDefinedNode, (String)"value");
            UserDefinedItem item = new UserDefinedItem();
            item.setName(name);
            item.setValue(value);
            this.userDefined.add(item);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simple", (boolean)this.isSimple));
        retval.append("      ").append(XMLHandler.addTagValue((String)"jar_url", (String)this.jarUrl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"driver_class", (String)this.driverClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"command_line_args", (String)this.cmdLineArgs));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simple_blocking", (boolean)this.simpleBlocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simple_logging_interval", (String)this.simpleLoggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"mapper_class", (String)this.mapperClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_class", (String)this.combinerClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reducer_class", (String)this.reducerClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_path", (String)this.inputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_format_class", (String)this.inputFormatClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_path", (String)this.outputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_key_class", (String)this.outputKeyClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_value_class", (String)this.outputValueClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_format_class", (String)this.outputFormatClass));
        this.namedClusterLoadSaveUtil.getXmlNamedCluster(this.namedCluster, this.namedClusterService, this.metaStore, this.log, retval);
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_map_tasks", (String)this.numMapTasks));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_reduce_tasks", (String)this.numReduceTasks));
        retval.append("      <user_defined_list>").append(Const.CR);
        if (this.userDefined != null) {
            for (UserDefinedItem item : this.userDefined) {
                if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                retval.append("        <user_defined>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)item.getName()));
                retval.append("          ").append(XMLHandler.addTagValue((String)"value", (String)item.getValue()));
                retval.append("        </user_defined>").append(Const.CR);
            }
        }
        retval.append("      </user_defined_list>").append(Const.CR);
        return retval.toString();
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep != null) {
            super.loadRep(rep, metaStore, id_jobentry, databases, slaveServers);
            this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
            this.setSimple(rep.getJobEntryAttributeBoolean(id_jobentry, "simple"));
            this.setJarUrl(rep.getJobEntryAttributeString(id_jobentry, "jar_url"));
            this.setDriverClass(rep.getJobEntryAttributeString(id_jobentry, "driver_class"));
            this.setCmdLineArgs(rep.getJobEntryAttributeString(id_jobentry, "command_line_args"));
            this.setSimpleBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "simple_blocking"));
            this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
            this.setSimpleLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "simple_logging_interval"));
            this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
            this.setMapperClass(rep.getJobEntryAttributeString(id_jobentry, "mapper_class"));
            this.setCombinerClass(rep.getJobEntryAttributeString(id_jobentry, "combiner_class"));
            this.setReducerClass(rep.getJobEntryAttributeString(id_jobentry, "reducer_class"));
            this.setInputPath(rep.getJobEntryAttributeString(id_jobentry, "input_path"));
            this.setInputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "input_format_class"));
            this.setOutputPath(rep.getJobEntryAttributeString(id_jobentry, "output_path"));
            this.setOutputKeyClass(rep.getJobEntryAttributeString(id_jobentry, "output_key_class"));
            this.setOutputValueClass(rep.getJobEntryAttributeString(id_jobentry, "output_value_class"));
            this.setOutputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "output_format_class"));
            this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, id_jobentry, rep, metaStore, null, this.log);
            this.setRepository(rep);
            this.setNumMapTasks(rep.getJobEntryAttributeString(id_jobentry, "num_map_tasks"));
            this.setNumReduceTasks(rep.getJobEntryAttributeString(id_jobentry, "num_reduce_tasks"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "user_defined_name");
            if (argnr > 0) {
                this.userDefined = new ArrayList<UserDefinedItem>();
                UserDefinedItem item = null;
                for (int i = 0; i < argnr; ++i) {
                    item = new UserDefinedItem();
                    item.setName(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_name"));
                    item.setValue(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_value"));
                    this.userDefined.add(item);
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        if (rep != null) {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simple", this.isSimple);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "jar_url", this.jarUrl);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "driver_class", this.driverClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "command_line_args", this.cmdLineArgs);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simple_blocking", this.simpleBlocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simple_logging_interval", this.simpleLoggingInterval);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "mapper_class", this.mapperClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_class", this.combinerClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reducer_class", this.reducerClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_path", this.inputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_format_class", this.inputFormatClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_path", this.outputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_key_class", this.outputKeyClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_value_class", this.outputValueClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_format_class", this.outputFormatClass);
            this.namedClusterLoadSaveUtil.saveNamedClusterRep(this.namedCluster, this.namedClusterService, rep, metaStore, id_job, this.getObjectId(), this.log);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_map_tasks", this.numMapTasks);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_reduce_tasks", this.numReduceTasks);
            if (this.userDefined != null) {
                for (int i = 0; i < this.userDefined.size(); ++i) {
                    UserDefinedItem item = this.userDefined.get(i);
                    if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_name", item.getName());
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_value", item.getValue());
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getSimpleLoggingInterval() {
        return this.simpleLoggingInterval == null ? DEFAULT_LOGGING_INTERVAL : this.simpleLoggingInterval;
    }

    public void setSimpleLoggingInterval(String simpleLoggingInterval) {
        this.simpleLoggingInterval = simpleLoggingInterval;
    }

    public boolean isSimpleBlocking() {
        return this.simpleBlocking;
    }

    public void setSimpleBlocking(boolean simpleBlocking) {
        this.simpleBlocking = simpleBlocking;
    }

    public String getDialogClassName() {
        return DIALOG_NAME;
    }
}

