/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.entry;

import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Node;

public class NamedClusterLoadSaveUtil {
    public static final String CLUSTER_NAME = "cluster_name";
    public static final String HDFS_HOSTNAME = "hdfs_hostname";
    public static final String HDFS_PORT = "hdfs_port";
    public static final String JOB_TRACKER_HOSTNAME = "job_tracker_hostname";
    public static final String JOB_TRACKER_PORT = "job_tracker_port";

    public void saveNamedClusterRep(NamedCluster namedCluster, NamedClusterService namedClusterService, Repository rep, IMetaStore metaStore, ObjectId id_job, ObjectId objectId, LogChannelInterface logChannelInterface) throws KettleException {
        if (namedCluster != null) {
            String namedClusterName = namedCluster.getName();
            if (!Const.isEmpty((String)namedClusterName)) {
                rep.saveJobEntryAttribute(id_job, objectId, CLUSTER_NAME, namedClusterName);
            }
            try {
                if (!StringUtils.isEmpty((String)namedClusterName) && namedClusterService.contains(namedClusterName, metaStore)) {
                    namedCluster = namedClusterService.read(namedClusterName, metaStore);
                }
            }
            catch (MetaStoreException e) {
                logChannelInterface.logDebug(e.getMessage(), new Object[]{e});
            }
            rep.saveJobEntryAttribute(id_job, objectId, HDFS_HOSTNAME, namedCluster.getHdfsHost());
            rep.saveJobEntryAttribute(id_job, objectId, HDFS_PORT, namedCluster.getHdfsPort());
            rep.saveJobEntryAttribute(id_job, objectId, JOB_TRACKER_HOSTNAME, namedCluster.getJobTrackerHost());
            rep.saveJobEntryAttribute(id_job, objectId, JOB_TRACKER_PORT, namedCluster.getJobTrackerPort());
        }
    }

    public void getXmlNamedCluster(NamedCluster namedCluster, NamedClusterService namedClusterService, IMetaStore metaStore, LogChannelInterface logChannelInterface, StringBuilder retval) {
        if (namedCluster != null) {
            String namedClusterName = namedCluster.getName();
            if (!Const.isEmpty((String)namedClusterName)) {
                retval.append("      ").append(XMLHandler.addTagValue((String)CLUSTER_NAME, (String)namedClusterName));
            }
            try {
                if (metaStore != null && !StringUtils.isEmpty((String)namedClusterName) && namedClusterService.contains(namedClusterName, metaStore)) {
                    namedCluster = namedClusterService.read(namedClusterName, metaStore);
                }
            }
            catch (MetaStoreException e) {
                logChannelInterface.logDebug(e.getMessage(), new Object[]{e});
            }
            retval.append("      ").append(XMLHandler.addTagValue((String)HDFS_HOSTNAME, (String)namedCluster.getHdfsHost()));
            retval.append("      ").append(XMLHandler.addTagValue((String)HDFS_PORT, (String)namedCluster.getHdfsPort()));
            retval.append("      ").append(XMLHandler.addTagValue((String)JOB_TRACKER_HOSTNAME, (String)namedCluster.getJobTrackerHost()));
            retval.append("      ").append(XMLHandler.addTagValue((String)JOB_TRACKER_PORT, (String)namedCluster.getJobTrackerPort()));
        }
    }

    public NamedCluster loadClusterConfig(NamedClusterService namedClusterService, ObjectId id_jobentry, Repository rep, IMetaStore metaStore, Node entrynode, LogChannelInterface logChannelInterface) {
        boolean configLoaded = false;
        try {
            String clusterName = null;
            if (entrynode != null) {
                clusterName = XMLHandler.getTagValue((Node)entrynode, (String)CLUSTER_NAME);
            } else if (rep != null) {
                clusterName = rep.getJobEntryAttributeString(id_jobentry, CLUSTER_NAME);
            }
            NamedCluster nc = null;
            if (!StringUtils.isEmpty((String)clusterName) && namedClusterService.contains(clusterName, metaStore)) {
                nc = namedClusterService.read(clusterName, metaStore);
            }
            if (nc != null) {
                return nc;
            }
        }
        catch (Throwable t) {
            logChannelInterface.logDebug(t.getMessage(), new Object[]{t});
        }
        NamedCluster namedCluster = namedClusterService.getClusterTemplate();
        if (entrynode != null) {
            namedCluster.setHdfsHost(XMLHandler.getTagValue((Node)entrynode, (String)HDFS_HOSTNAME));
            namedCluster.setHdfsPort(XMLHandler.getTagValue((Node)entrynode, (String)HDFS_PORT));
            namedCluster.setJobTrackerHost(XMLHandler.getTagValue((Node)entrynode, (String)JOB_TRACKER_HOSTNAME));
            namedCluster.setJobTrackerPort(XMLHandler.getTagValue((Node)entrynode, (String)JOB_TRACKER_PORT));
        } else if (rep != null) {
            try {
                namedCluster.setHdfsHost(rep.getJobEntryAttributeString(id_jobentry, HDFS_HOSTNAME));
                namedCluster.setHdfsPort(rep.getJobEntryAttributeString(id_jobentry, HDFS_PORT));
                namedCluster.setJobTrackerHost(rep.getJobEntryAttributeString(id_jobentry, JOB_TRACKER_HOSTNAME));
                namedCluster.setJobTrackerPort(rep.getJobEntryAttributeString(id_jobentry, JOB_TRACKER_PORT));
            }
            catch (KettleException ke) {
                logChannelInterface.logError(ke.getMessage(), (Throwable)ke);
            }
        }
        return namedCluster;
    }
}

