/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.controller;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.repo.model.RepositoryDirectory;
import org.pentaho.repo.model.RepositoryFile;
import org.pentaho.repo.model.RepositoryName;
import org.pentaho.repo.model.RepositoryTree;
import org.pentaho.repo.util.Util;

public class RepositoryBrowserController {
    public static final String PENTAHO_ENTERPRISE_REPOSITORY = "PentahoEnterpriseRepository";
    public static Repository repository;
    public static final String TRANSFORMATION = "transformation";
    public static final String JOB = "job";
    public static final String FOLDER = "folder";
    public static final String FILTER = "*.ktr|*.kjb";
    private RepositoryDirectoryInterface rootDirectory;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;

    public boolean loadFile(String id, String type) {
        try {
            this.getSpoon().getDisplay().asyncExec(() -> {
                try {
                    this.getSpoon().loadObjectFromRepository(() -> id, type.equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getActiveFileName() {
        try {
            return this.getSpoon().getActiveMeta().getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public ObjectId rename(String id, String path, String newName, String type, String oldName) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
        ObjectId objectId = null;
        switch (type) {
            case "job": {
                if (this.getRepository().exists(newName, repositoryDirectoryInterface, RepositoryObjectType.JOB)) {
                    throw new KettleObjectExistsException();
                }
                if (this.isJobOpened(id, path, oldName)) {
                    throw new KettleJobException();
                }
                this.renameRecent(id, type, newName);
                objectId = this.getRepository().renameJob(() -> id, repositoryDirectoryInterface, newName);
                break;
            }
            case "transformation": {
                if (this.getRepository().exists(newName, repositoryDirectoryInterface, RepositoryObjectType.TRANSFORMATION)) {
                    throw new KettleObjectExistsException();
                }
                if (this.isTransOpened(id, path, oldName)) {
                    throw new KettleTransException();
                }
                this.renameRecent(id, type, newName);
                objectId = this.getRepository().renameTransformation(() -> id, repositoryDirectoryInterface, newName);
                break;
            }
            case "folder": {
                RepositoryDirectoryInterface child;
                this.isFileOpenedInFolder(path);
                RepositoryDirectoryInterface parent = this.findDirectory(path).getParent();
                if (parent == null) {
                    parent = this.findDirectory(path);
                }
                if ((child = parent.findChild(newName)) != null) {
                    throw new KettleObjectExistsException();
                }
                objectId = this.getRepository() instanceof RepositoryExtended ? ((RepositoryExtended)this.getRepository()).renameRepositoryDirectory(() -> id, null, newName, true) : this.getRepository().renameRepositoryDirectory(() -> id, null, newName);
            }
        }
        return objectId;
    }

    private boolean isTransOpened(String id, String path, String name) {
        List openedTransFiles = this.getSpoon().delegates.trans.getTransformationList();
        for (TransMeta t : openedTransFiles) {
            if ((t.getObjectId() == null || !id.equals(t.getObjectId().getId())) && (!path.equals(t.getRepositoryDirectory().getPath()) || !name.equals(t.getName()))) continue;
            return true;
        }
        return false;
    }

    private boolean isJobOpened(String id, String path, String name) {
        List openedJobFiles = this.getSpoon().delegates.jobs.getJobList();
        for (JobMeta j : openedJobFiles) {
            if ((j.getObjectId() == null || !id.equals(j.getObjectId().getId())) && (!path.equals(j.getRepositoryDirectory().getPath()) || !name.equals(j.getName()))) continue;
            return true;
        }
        return false;
    }

    private void isFileOpenedInFolder(String path) throws KettleException {
        List openedTransFiles = this.getSpoon().delegates.trans.getTransformationList();
        for (TransMeta t : openedTransFiles) {
            if (t.getRepositoryDirectory().getPath() == null || !(t.getRepositoryDirectory().getPath() + "/").startsWith(path + "/")) continue;
            throw new KettleTransException();
        }
        List openedJobFiles = this.getSpoon().delegates.jobs.getJobList();
        for (JobMeta j : openedJobFiles) {
            if (j.getRepositoryDirectory().getPath() == null || !(j.getRepositoryDirectory().getPath() + "/").startsWith(path + "/")) continue;
            throw new KettleJobException();
        }
    }

    private void removeRecentsUsingPath(String path) {
        Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
        for (List lastUsedFiles : lastUsedRepoFiles) {
            for (int i = 0; i < lastUsedFiles.size(); ++i) {
                if (!(((LastUsedFile)lastUsedFiles.get(i)).getDirectory() + "/").startsWith(path + "/")) continue;
                lastUsedFiles.remove(i);
                --i;
            }
        }
    }

    public boolean remove(String id, String name, String path, String type) throws KettleException {
        try {
            switch (type) {
                case "job": {
                    if (this.isJobOpened(id, path, name)) {
                        throw new KettleJobException();
                    }
                    this.getRepository().deleteJob(() -> id);
                    break;
                }
                case "transformation": {
                    if (this.isTransOpened(id, path, name)) {
                        throw new KettleTransException();
                    }
                    this.getRepository().deleteTransformation(() -> id);
                    break;
                }
                case "folder": {
                    this.isFileOpenedInFolder(path);
                    this.removeRecentsUsingPath(path);
                    RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
                    if (this.getRepository() instanceof RepositoryExtended) {
                        ((RepositoryExtended)this.getRepository()).deleteRepositoryDirectory(repositoryDirectoryInterface, true);
                        break;
                    }
                    this.getRepository().deleteRepositoryDirectory(repositoryDirectoryInterface);
                }
            }
            return true;
        }
        catch (KettleJobException | KettleTransException ke) {
            throw ke;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<RepositoryFile> getRecentFiles() {
        PropsUI props = PropsUI.getInstance();
        ArrayList<RepositoryFile> repositoryFiles = new ArrayList<RepositoryFile>();
        IUser userInfo = Spoon.getInstance().rep.getUserInfo();
        String repoAndUser = Spoon.getInstance().rep.getName() + ":" + (userInfo != null ? userInfo.getLogin() : "");
        List lastUsedFiles = props.getLastUsedRepoFiles().getOrDefault(repoAndUser, Collections.emptyList());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        Date dateBefore = calendar.getTime();
        for (int i = 0; i < lastUsedFiles.size(); ++i) {
            LastUsedFile lastUsedFile = (LastUsedFile)lastUsedFiles.get(i);
            if (lastUsedFile.getLastOpened().before(dateBefore) || lastUsedFile.getRepositoryName() == null || !lastUsedFile.getRepositoryName().equals(Spoon.getInstance().rep.getName())) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            String index = String.valueOf(i);
            repositoryFile.setObjectId(() -> index);
            repositoryFile.setType(lastUsedFile.isTransformation() ? TRANSFORMATION : JOB);
            repositoryFile.setName(lastUsedFile.getFilename());
            repositoryFile.setPath(lastUsedFile.getDirectory());
            repositoryFile.setDate(lastUsedFile.getLastOpened());
            repositoryFile.setRepository(lastUsedFile.getRepositoryName());
            repositoryFile.setUsername(lastUsedFile.getUsername());
            repositoryFiles.add(repositoryFile);
        }
        return repositoryFiles;
    }

    private boolean renameRecent(String id, String type, String name) {
        RepositoryObject repositoryObject = null;
        try {
            repositoryObject = this.getRepository().getObjectInformation(() -> id, type.equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
        }
        catch (Exception e) {
            return false;
        }
        if (repositoryObject != null) {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (LastUsedFile lastUsedFile : lastUsedFiles) {
                    if (!lastUsedFile.getDirectory().equals(repositoryObject.getRepositoryDirectory().getPath()) || !lastUsedFile.getFilename().equals(repositoryObject.getName())) continue;
                    lastUsedFile.setFilename(name);
                    return true;
                }
            }
        }
        return true;
    }

    public boolean updateRecentFiles(String oldPath, String newPath) {
        try {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (int i = 0; i < lastUsedFiles.size(); ++i) {
                    if (!(((LastUsedFile)lastUsedFiles.get(i)).getDirectory() + "/").startsWith(oldPath + "/")) continue;
                    if (((LastUsedFile)lastUsedFiles.get(i)).getDirectory().length() == oldPath.length()) {
                        ((LastUsedFile)lastUsedFiles.get(i)).setDirectory(newPath);
                        continue;
                    }
                    String prefix = newPath.substring(0, newPath.lastIndexOf("/")) + "/";
                    String newFolder = newPath.substring(newPath.lastIndexOf("/") + 1);
                    String suffix = ((LastUsedFile)lastUsedFiles.get(i)).getDirectory().substring(oldPath.length());
                    ((LastUsedFile)lastUsedFiles.get(i)).setDirectory(prefix + newFolder + suffix);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public RepositoryDirectory create(String parent, String name) {
        if (this.hasDupeFolder(parent, name)) {
            return null;
        }
        try {
            RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().createRepositoryDirectory(this.findDirectory(parent), name);
            RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
            repositoryDirectory.setName(repositoryDirectoryInterface.getName());
            repositoryDirectory.setPath(repositoryDirectoryInterface.getPath());
            repositoryDirectory.setObjectId(repositoryDirectoryInterface.getObjectId());
            repositoryDirectory.setParent(parent);
            return repositoryDirectory;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean hasDupeFolder(String parent, String name) {
        try {
            RepositoryDirectoryInterface rdi = this.getRepository().findDirectory(parent).findChild(name);
            return rdi != null;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public boolean saveFile(String path, String name, String fileName, boolean override) {
        boolean result = this.checkForSecurityOrDupeIssues(path, name, fileName, override);
        if (result) {
            try {
                RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
                this.getSpoon().getDisplay().asyncExec(() -> {
                    try {
                        EngineMetaInterface meta = this.getSpoon().getActiveMeta();
                        meta.setRepositoryDirectory(repositoryDirectoryInterface);
                        meta.setName(name);
                        this.getSpoon().saveToRepositoryConfirmed(meta);
                        this.getSpoon().delegates.tabs.renameTabs();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    public boolean checkForSecurityOrDupeIssues(String path, String name, String fileName, boolean override) {
        return this.checkSecurity() && !this.hasDupeFile(path, name, fileName, override);
    }

    private boolean hasDupeFile(String path, String name, String fileName, boolean override) {
        try {
            RepositoryObjectType type;
            RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().findDirectory(path);
            EngineMetaInterface meta = this.getSpoon().getActiveMeta();
            RepositoryObjectType repositoryObjectType = type = "Trans".equals(meta.getFileType()) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB;
            if (this.getRepository().exists(name, repositoryDirectoryInterface, type)) {
                return !override || !name.equals(fileName);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return false;
    }

    private boolean checkSecurity() {
        EngineMetaInterface meta = this.getSpoon().getActiveMeta();
        return this.getSpoon().saveToRepositoryCheckSecurity(meta);
    }

    public RepositoryTree loadDirectoryTree() {
        if (this.getRepository() != null) {
            try {
                this.rootDirectory = this.getRepository() instanceof RepositoryExtended ? ((RepositoryExtended)this.getRepository()).loadRepositoryDirectoryTree(false) : this.getRepository().loadRepositoryDirectoryTree();
                RepositoryTree repositoryTree = new RepositoryTree();
                RepositoryDirectory repositoryDirectory = RepositoryDirectory.build(null, this.rootDirectory);
                this.populateFolders(repositoryDirectory, this.rootDirectory);
                boolean isPentahoRepository = this.getRepository().getRepositoryMeta().getId().equals(PENTAHO_ENTERPRISE_REPOSITORY);
                repositoryTree.setIncludeRoot(!isPentahoRepository);
                repositoryTree.addChild(repositoryDirectory);
                return repositoryTree;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private List<RepositoryElementMetaInterface> getRepositoryElements(RepositoryDirectoryInterface repositoryDirectoryInterface) {
        List elements = repositoryDirectoryInterface.getRepositoryObjects();
        if (elements == null) {
            try {
                return this.getRepository().getJobAndTransformationObjects(repositoryDirectoryInterface.getObjectId(), false);
            }
            catch (KettleException ke) {
                ke.printStackTrace();
            }
        } else {
            return elements;
        }
        return Collections.emptyList();
    }

    public boolean openRecentFile(String repo, String id) {
        if (this.getSpoon().recentRepoFileExists(repo, id)) {
            this.getSpoon().getDisplay().asyncExec(() -> this.getSpoon().lastRepoFileSelect(repo, id));
            return true;
        }
        return false;
    }

    private void populateFolders(RepositoryDirectory repositoryDirectory, RepositoryDirectoryInterface repositoryDirectoryInterface) {
        if (this.getRepository() instanceof RepositoryExtended) {
            this.populateFoldersLazy(repositoryDirectory);
        } else {
            List children = repositoryDirectoryInterface.getChildren();
            repositoryDirectory.setHasChildren(!Utils.isEmpty((List)children));
            if (!Utils.isEmpty((List)children)) {
                for (RepositoryDirectoryInterface child : children) {
                    repositoryDirectory.addChild(RepositoryDirectory.build(repositoryDirectory.getPath(), child));
                }
            }
        }
    }

    private void populateFiles(RepositoryDirectory repositoryDirectory, RepositoryDirectoryInterface repositoryDirectoryInterface, String filter) throws KettleException {
        if (this.getRepository() instanceof RepositoryExtended && !repositoryDirectory.getPath().equals("/")) {
            this.populateFilesLazy(repositoryDirectory, filter);
        } else {
            Date latestDate = null;
            for (RepositoryObjectInterface repositoryObjectInterface : this.getRepositoryElements(repositoryDirectoryInterface)) {
                RepositoryObject ro = (RepositoryObject)repositoryObjectInterface;
                String extension = ro.getObjectType().getExtension();
                if (!Util.isFiltered(extension, filter)) {
                    RepositoryFile repositoryFile = RepositoryFile.build(ro);
                    repositoryDirectory.addChild(repositoryFile);
                }
                if (latestDate != null && !ro.getModifiedDate().after(latestDate)) continue;
                latestDate = ro.getModifiedDate();
            }
            repositoryDirectory.setDate(latestDate);
        }
    }

    public void populateFoldersLazy(RepositoryDirectory repositoryDirectory) {
        RepositoryRequest repositoryRequest = new RepositoryRequest(repositoryDirectory.getPath(), Boolean.valueOf(true), Integer.valueOf(1), null);
        repositoryRequest.setTypes(RepositoryRequest.FILES_TYPE_FILTER.FOLDERS);
        repositoryRequest.setIncludeSystemFolders(false);
        RepositoryFileTree tree = this.getRepository().getUnderlyingRepository().getTree(repositoryRequest);
        for (RepositoryFileTree repositoryFileTree : tree.getChildren()) {
            org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile = repositoryFileTree.getFile();
            RepositoryDirectory repositoryDirectory1 = RepositoryDirectory.build(repositoryDirectory.getPath(), repositoryFile, this.isAdmin());
            repositoryDirectory.addChild(repositoryDirectory1);
        }
    }

    public void populateFilesLazy(RepositoryDirectory repositoryDirectory, String filter) {
        RepositoryRequest repositoryRequest = new RepositoryRequest();
        repositoryRequest.setPath(repositoryDirectory.getPath());
        repositoryRequest.setDepth(Integer.valueOf(1));
        repositoryRequest.setShowHidden(true);
        repositoryRequest.setTypes(RepositoryRequest.FILES_TYPE_FILTER.FILES);
        repositoryRequest.setChildNodeFilter(filter);
        RepositoryFileTree tree = this.getRepository().getUnderlyingRepository().getTree(repositoryRequest);
        for (RepositoryFileTree repositoryFileTree : tree.getChildren()) {
            org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile = repositoryFileTree.getFile();
            RepositoryFile repositoryFile1 = RepositoryFile.build(repositoryDirectory.getPath(), repositoryFile, this.isAdmin());
            repositoryDirectory.addChild(repositoryFile1);
        }
    }

    public RepositoryDirectory loadFolders(String path) {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
        RepositoryDirectory repositoryDirectory = RepositoryDirectory.build(null, repositoryDirectoryInterface);
        this.populateFolders(repositoryDirectory, repositoryDirectoryInterface);
        return repositoryDirectory;
    }

    public RepositoryDirectory loadFiles(String path) {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
        RepositoryDirectory repositoryDirectory = RepositoryDirectory.build(null, repositoryDirectoryInterface);
        try {
            this.populateFiles(repositoryDirectory, repositoryDirectoryInterface, FILTER);
        }
        catch (KettleException ke) {
            ke.printStackTrace();
        }
        return repositoryDirectory;
    }

    public RepositoryDirectory loadFilesAndFolders(String path) {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(path);
        RepositoryDirectory repositoryDirectory = RepositoryDirectory.build(null, repositoryDirectoryInterface);
        this.populateFolders(repositoryDirectory, repositoryDirectoryInterface);
        try {
            this.populateFiles(repositoryDirectory, repositoryDirectoryInterface, FILTER);
        }
        catch (KettleException ke) {
            ke.printStackTrace();
        }
        return repositoryDirectory;
    }

    public List<org.pentaho.repo.model.RepositoryObject> search(String path, String filter) {
        RepositoryDirectory repositoryDirectory = this.loadFilesAndFolders(path);
        ArrayList<org.pentaho.repo.model.RepositoryObject> repositoryObjects = new ArrayList<org.pentaho.repo.model.RepositoryObject>();
        for (org.pentaho.repo.model.RepositoryObject repositoryObject : repositoryDirectory.getChildren()) {
            if (!repositoryObject.getName().toLowerCase().contains(filter.toLowerCase()) && Util.isFiltered(repositoryObject.getName(), filter)) continue;
            repositoryObjects.add(repositoryObject);
        }
        return repositoryObjects;
    }

    public JSONArray getRecentSearches() {
        try {
            PropsUI props = PropsUI.getInstance();
            String jsonString = props.getRecentSearches();
            if (jsonString != null) {
                JSONParser jsonParser = new JSONParser();
                JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonString);
                return (JSONArray)jsonObject.get((Object)this.getLogin());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JSONArray();
    }

    public JSONArray storeRecentSearch(String recentSearch) {
        JSONArray recentSearches = this.getRecentSearches();
        try {
            if (recentSearch == null || recentSearches.contains((Object)recentSearch)) {
                return recentSearches;
            }
            recentSearches.add((Object)recentSearch);
            if (recentSearches.size() > 5) {
                recentSearches.remove(0);
            }
            PropsUI props = PropsUI.getInstance();
            String jsonValue = props.getRecentSearches();
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = jsonValue != null ? (JSONObject)jsonParser.parse(jsonValue) : new JSONObject();
            jsonObject.put((Object)this.getLogin(), (Object)recentSearches);
            props.setRecentSearches(jsonObject.toJSONString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recentSearches;
    }

    private RepositoryDirectoryInterface findDirectory(ObjectId objectId) {
        return this.rootDirectory.findDirectory(objectId);
    }

    private Spoon getSpoon() {
        return this.spoonSupplier.get();
    }

    private String getLogin() {
        String login = "file_repository_no_login";
        if (this.getSpoon().rep.getUserInfo() != null) {
            login = this.getSpoon().rep.getUserInfo().getLogin();
        }
        return login;
    }

    private RepositoryDirectoryInterface findDirectory(String path) {
        return this.rootDirectory.findDirectory(path);
    }

    public RepositoryName getCurrentRepo() {
        return new RepositoryName(this.getRepository().getName());
    }

    private Repository getRepository() {
        return repository != null ? repository : this.spoonSupplier.get().rep;
    }

    private Boolean isAdmin() {
        return this.getRepository().getUserInfo().isAdmin();
    }
}

