/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.containers.XulGroupbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.ScrollablePanel;
import org.pentaho.ui.xul.swing.tags.SwingCaption;
import org.pentaho.ui.xul.util.Orient;

public class SwingGroupbox
extends AbstractSwingContainer
implements XulGroupbox {
    private static final Log logger = LogFactory.getLog(SwingGroupbox.class);

    public SwingGroupbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("groupbox");
        this.orientation = Orient.VERTICAL;
        this.container = new ScrollablePanel(new GridBagLayout());
        this.container.setBorder(BorderFactory.createTitledBorder(""));
        this.setManagedObject(this.container);
        this.setPadding(2);
    }

    @Override
    public void resetContainer() {
        this.container.removeAll();
        if (this.getOrientation() == Orient.VERTICAL) {
            this.gc = new GridBagConstraints();
            this.gc.gridy = -1;
            this.gc.gridx = 0;
            this.gc.gridheight = 1;
            this.gc.gridwidth = 0;
            int pad = this.getPadding();
            this.gc.insets = new Insets(pad, pad, pad, pad);
            this.gc.fill = 2;
            this.gc.anchor = 18;
            this.gc.weightx = 1.0;
        } else {
            this.gc = new GridBagConstraints();
            this.gc.gridy = 0;
            this.gc.gridx = -1;
            this.gc.gridheight = 0;
            this.gc.gridwidth = 1;
            this.gc.insets = new Insets(2, 2, 2, 2);
            this.gc.fill = 3;
            this.gc.anchor = 18;
            this.gc.weighty = 1.0;
        }
    }

    public void setCaption(String caption) {
        this.container.setBorder(BorderFactory.createTitledBorder(caption));
    }

    @Override
    public void setOrient(String orientation) {
        this.orientation = Orient.valueOf((String)orientation.toUpperCase());
    }

    @Override
    public void layout() {
        this.resetContainer();
        super.layout();
        for (Element comp : this.getChildNodes()) {
            if (!(comp instanceof SwingCaption)) continue;
            this.setCaption(((SwingCaption)comp).getLabel());
        }
        int width = this.container.getSize().width;
        int height = this.container.getSize().height;
        if (this.getWidth() > 0) {
            width = this.getWidth();
        }
        if (this.getHeight() > 0) {
            height = this.getHeight();
        }
        this.container.setSize(width, height);
    }

    @Override
    public void removeChild(Element ele) {
        super.removeChild(ele);
        if (this.initialized) {
            this.resetContainer();
            this.layout();
        }
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        this.resetContainer();
        super.replaceChild(oldElement, newElement);
    }
}

