/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mondrian.publish;

import java.util.Locale;

public class LocaleHelper {
    private static final ThreadLocal<Locale> threadLocales = new ThreadLocal();
    private static Locale defaultLocale;
    public static final String UTF_8 = "UTF-8";
    private static String encoding;
    public static final String LEFT_TO_RIGHT = "LTR";
    private static String textDirection;

    public static void setDefaultLocale(Locale newLocale) {
        defaultLocale = newLocale;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    public static Locale getLocale() {
        Locale rtn = threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        defaultLocale = Locale.getDefault();
        LocaleHelper.setLocale(defaultLocale);
        return defaultLocale;
    }

    public static void setSystemEncoding(String encoding) {
        LocaleHelper.encoding = encoding;
    }

    public static void setTextDirection(String textDirection) {
        LocaleHelper.textDirection = textDirection;
    }

    public static String getSystemEncoding() {
        return encoding;
    }

    public static String getTextDirection() {
        return textDirection;
    }

    static {
        encoding = UTF_8;
        textDirection = LEFT_TO_RIGHT;
    }
}

