/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.DefaultBindingContext;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.impl.AbstractXulDomContainer;
import org.pentaho.ui.xul.util.XmlParserFactoryProducer;

public class XulWindowContainer
extends AbstractXulDomContainer {
    private static final Log logger = LogFactory.getLog(XulWindowContainer.class);
    private List<org.pentaho.ui.xul.dom.Document> windows = new ArrayList<org.pentaho.ui.xul.dom.Document>();
    private boolean closed = false;
    private boolean ignoreClose = false;

    public XulWindowContainer() throws XulException {
        this.bindings = new DefaultBindingContext(this);
    }

    public XulWindowContainer(XulLoader xulLoader) throws XulException {
        this();
        this.xulLoader = xulLoader;
    }

    @Override
    public org.pentaho.ui.xul.dom.Document getDocumentRoot() {
        return this.windows.get(0);
    }

    @Override
    public void addDocument(org.pentaho.ui.xul.dom.Document document) {
        this.windows.add(document);
        document.setXulDomContainer(this);
    }

    @Override
    public void close() {
        XulRoot rootEle = (XulRoot)this.getDocumentRoot().getRootElement();
        logger.debug((Object)("onclose: " + rootEle.getOnclose()));
        String onclose = rootEle.getOnclose();
        if (onclose != null) {
            Object oncloseCalls;
            for (Object close : oncloseCalls = onclose.split(",")) {
                close = ((String)close).trim();
                try {
                    Object result = this.invoke((String)close, new Object[0]);
                    if (result != null && result instanceof Boolean && !((Boolean)result).booleanValue()) {
                        logger.debug((Object)("onclose " + (String)close + " returned false, exiting close procedure"));
                        return;
                    }
                }
                catch (XulException e) {
                    logger.error((Object)("Error calling onclose event: " + (String)close), (Throwable)e);
                }
            }
        }
        for (org.pentaho.ui.xul.dom.Document wind : this.windows) {
            XulWindow window = (XulWindow)wind.getRootElement();
            if (window == null) continue;
            window.close();
        }
        this.closed = true;
        logger.debug((Object)("onunload: " + rootEle.getOnload()));
        String onunload = rootEle.getOnunload();
        if (onunload != null) {
            String[] unloadCalls;
            for (String unload : unloadCalls = onunload.split(",")) {
                unload = unload.trim();
                try {
                    this.invoke(unload, new Object[0]);
                }
                catch (XulException e) {
                    logger.error((Object)("Error calling onunload event: " + unload), (Throwable)e);
                }
            }
        }
        if (!this.ignoreClose) {
            System.exit(0);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void ignoreCloseOperation(boolean flag) {
        this.ignoreClose = flag;
    }

    @Override
    public XulDomContainer loadFragment(String xulLocation) throws XulException {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(xulLocation);
            if (in == null) {
                throw new XulException("loadFragment: input document is null");
            }
            SAXReader rdr = XmlParserFactoryProducer.getSAXReader(null);
            Document doc = rdr.read(in);
            XulDomContainer container = this.xulLoader.loadXulFragment(doc);
            in.close();
            return container;
        }
        catch (Exception e) {
            logger.error((Object)"Error Loading Xul Fragment", (Throwable)e);
            throw new XulException(e);
        }
    }

    @Override
    public XulDomContainer loadFragment(String xulLocation, Object bundle) throws XulException {
        XulDomContainer container = this.xulLoader.loadXulFragment(xulLocation, (ResourceBundle)bundle);
        return container;
    }

    @Override
    public org.pentaho.ui.xul.dom.Document getDocument(int idx) {
        return this.windows.get(idx);
    }

    @Override
    public void loadOverlay(String src) throws XulException {
        this.xulLoader.processOverlay(src, this.getDocumentRoot(), this);
    }

    @Override
    public void loadOverlay(String src, Object resourceBundle) throws XulException {
        this.xulLoader.processOverlay(src, this.getDocumentRoot(), this, resourceBundle);
    }

    @Override
    public void removeOverlay(String src) throws XulException {
        this.xulLoader.removeOverlay(src, this.getDocumentRoot(), this);
    }

    @Override
    public void removeBinding(Binding binding) {
        this.bindings.remove(binding);
    }

    @Override
    public void loadFragment(String id, String src) throws XulException {
        XulComponent c = this.getDocumentRoot().getElementById(id);
        if (c == null) {
            throw new IllegalArgumentException("target element does not exist");
        }
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(src);
            if (in == null) {
                throw new XulException("loadFragment: input document is null");
            }
            SAXReader rdr = XmlParserFactoryProducer.getSAXReader(null);
            Document doc = rdr.read(in);
            XulDomContainer container = this.xulLoader.loadXulFragment(doc);
            c.addChild(container.getDocumentRoot().getRootElement());
        }
        catch (Exception e) {
            logger.error((Object)"Error Loading Xul Fragment", (Throwable)e);
            throw new XulException(e);
        }
    }
}

