/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database.util;

import org.pentaho.di.compatibility.ValueString;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseInterfaceExtended;
import org.pentaho.di.core.database.util.LogExceptionBehaviourInterface;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.i18n.BaseMessages;

public class DatabaseLogExceptionFactory {
    public static final String KETTLE_GLOBAL_PROP_NAME = "KETTLE_FAIL_ON_LOGGING_ERROR";
    private static final LogExceptionBehaviourInterface throwable = new ThrowableBehaviour();
    private static final LogExceptionBehaviourInterface suppressable = new SuppressBehaviour();
    private static final LogExceptionBehaviourInterface suppressableWithShortMessage = new SuppressableWithShortMessage();

    public static LogExceptionBehaviourInterface getExceptionStrategy(LogTableCoreInterface table) {
        return DatabaseLogExceptionFactory.getExceptionStrategy(table, null);
    }

    public static LogExceptionBehaviourInterface getExceptionStrategy(LogTableCoreInterface table, Exception e) {
        String val;
        DatabaseInterfaceExtended databaseInterface = DatabaseLogExceptionFactory.extractDatabase(table);
        LogExceptionBehaviourInterface suppressableResult = suppressable;
        if (databaseInterface != null && !databaseInterface.fullExceptionLog(e)) {
            suppressableResult = suppressableWithShortMessage;
        }
        if ((val = System.getProperty(KETTLE_GLOBAL_PROP_NAME)) == null) {
            return suppressableResult;
        }
        ValueString sVal = new ValueString(val);
        return sVal.getBoolean() ? throwable : suppressableResult;
    }

    private static DatabaseInterfaceExtended extractDatabase(LogTableCoreInterface table) {
        DatabaseInterfaceExtended result = null;
        if (table != null && table.getDatabaseMeta() != null) {
            DatabaseInterface databaseInterface = table.getDatabaseMeta().getDatabaseInterface();
            result = databaseInterface instanceof DatabaseInterfaceExtended ? (DatabaseInterfaceExtended)databaseInterface : null;
        }
        return result;
    }

    private static class SuppressableWithShortMessage
    extends SuppressBehaviour {
        private SuppressableWithShortMessage() {
        }

        @Override
        public void registerException(LogChannelInterface log, Exception e, Class<?> packageClass, String key, String ... parameters) throws KettleDatabaseException {
            this.registerException(log, packageClass, key, parameters);
            log.logError(e.getMessage());
        }
    }

    private static class SuppressBehaviour
    implements LogExceptionBehaviourInterface {
        private SuppressBehaviour() {
        }

        @Override
        public void registerException(LogChannelInterface log, Class<?> packageClass, String key, String ... parameters) {
            log.logError(BaseMessages.getString(packageClass, key, parameters));
        }

        @Override
        public void registerException(LogChannelInterface log, Exception e, Class<?> packageClass, String key, String ... parameters) throws KettleDatabaseException {
            log.logError(BaseMessages.getString(packageClass, key, parameters), e);
        }
    }

    private static class ThrowableBehaviour
    implements LogExceptionBehaviourInterface {
        private ThrowableBehaviour() {
        }

        @Override
        public void registerException(LogChannelInterface log, Class<?> packageClass, String key, String ... parameters) throws KettleDatabaseException {
            throw new KettleDatabaseException(BaseMessages.getString(packageClass, key, parameters));
        }

        @Override
        public void registerException(LogChannelInterface log, Exception e, Class<?> packageClass, String key, String ... parameters) throws KettleDatabaseException {
            throw new KettleDatabaseException(BaseMessages.getString(packageClass, key, parameters), e);
        }
    }
}

