/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.pentaho.di.core.database.VerticaDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;

public class Vertica5DatabaseMeta
extends VerticaDatabaseMeta {
    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "com.vertica.jdbc.Driver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    @Override
    public Object getValueFromResultSet(ResultSet rs, ValueMetaInterface val, int index) throws KettleDatabaseException {
        Date data;
        try {
            switch (val.getType()) {
                case 3: 
                case 9: {
                    if (val.getOriginalColumnType() == 93) {
                        data = rs.getTimestamp(index + 1);
                        break;
                    }
                    if (val.getOriginalColumnType() == 92) {
                        data = rs.getTime(index + 1);
                        break;
                    }
                    data = rs.getDate(index + 1);
                    break;
                }
                default: {
                    return super.getValueFromResultSet(rs, val, index);
                }
            }
            if (rs.wasNull()) {
                data = null;
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get value '" + val.toStringMeta() + "' from database resultset, index " + index, e);
        }
        return data;
    }
}

