/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.sort;

import java.util.Comparator;
import org.apache.log4j.Logger;

class Quicksorter<T> {
    public static final int TOO_SMALL = 8;
    private static final Logger LOGGER = Logger.getLogger(Quicksorter.class);
    private final T[] vec;
    private final Comparator<T> comp;
    private final boolean traced;
    private long partitions;
    private long comparisons;
    private long exchanges;

    public Quicksorter(T[] vec, Comparator<T> comp) {
        this.vec = vec;
        this.comp = comp;
        this.exchanges = 0L;
        this.comparisons = 0L;
        this.partitions = 0L;
        this.traced = LOGGER.isDebugEnabled();
    }

    private void traceStats(String prefix) {
        String sb = prefix + ": " + this.partitions + " partitions, " + this.comparisons + " comparisons, " + this.exchanges + " exchanges.";
        LOGGER.debug((Object)sb);
    }

    private boolean less(T x, T y) {
        ++this.comparisons;
        return this.comp.compare(x, y) < 0;
    }

    private boolean more(T x, T y) {
        ++this.comparisons;
        return this.comp.compare(x, y) > 0;
    }

    private boolean equal(T x, T y) {
        ++this.comparisons;
        return this.comp.compare(x, y) == 0;
    }

    private void swap(int i, int j) {
        ++this.exchanges;
        T temp = this.vec[i];
        this.vec[i] = this.vec[j];
        this.vec[j] = temp;
    }

    private void order3(int i, int j, int k) {
        if (this.more(this.vec[i], this.vec[j])) {
            this.swap(i, j);
        }
        if (this.more(this.vec[i], this.vec[k])) {
            this.swap(i, k);
        }
        if (this.more(this.vec[j], this.vec[k])) {
            this.swap(j, k);
        }
    }

    private void selectionSort(int start, int end) {
        for (int i = start; i < end; ++i) {
            int pmin = i;
            for (int j = i + 1; j <= end; ++j) {
                if (!this.less(this.vec[j], this.vec[pmin])) continue;
                pmin = j;
            }
            if (pmin == i) continue;
            this.swap(i, pmin);
        }
    }

    private int partition(int start, int end) {
        ++this.partitions;
        assert (start <= end);
        int mid = (start + end) / 2;
        this.order3(start, mid, end);
        if (end - start <= 2) {
            return mid;
        }
        T pivot = this.vec[mid];
        this.swap(mid, end - 1);
        int left = start + 1;
        int right = end - 2;
        while (left < right) {
            while (this.less(this.vec[left], pivot)) {
                ++left;
            }
            while (this.less(pivot, this.vec[right])) {
                --right;
            }
            if (left >= right) continue;
            this.swap(left, right);
            ++left;
            --right;
        }
        if (left == right && this.less(this.vec[left], pivot)) {
            ++left;
        }
        this.swap(left, end - 1);
        return left;
    }

    private void sort(int start, int end) {
        if (end - start < 8) {
            this.selectionSort(start, end);
            return;
        }
        int mid = this.partition(start, end);
        this.sort(start, mid - 1);
        this.sort(mid + 1, end);
    }

    private void select(int limit, int start, int end) {
        if (limit == 0) {
            return;
        }
        if (end - start < 8) {
            this.selectionSort(start, end);
            return;
        }
        int mid = this.partition(start, end);
        int leftSize = mid - start + 1;
        if (limit < leftSize) {
            this.select(limit, start, mid);
        } else {
            this.select(limit -= leftSize, mid + 1, end);
        }
    }

    public void sort() {
        int n = this.vec.length - 1;
        this.sort(0, n);
        if (this.traced) {
            this.traceStats("quicksort on " + n + "items");
        }
    }

    public void select(int limit) {
        int n = this.vec.length - 1;
        this.select(limit, 0, n);
        if (this.traced) {
            this.traceStats("quickselect for " + limit + " from" + n + "items");
        }
    }

    public void partialSort(int limit) {
        int n = this.vec.length - 1;
        this.select(limit, 0, n);
        if (this.traced) {
            this.traceStats("partial sort: quickselect phase for " + limit + "from " + n + "items");
        }
        this.sort(0, limit - 1);
        if (this.traced) {
            this.traceStats("partial sort: quicksort phase on " + n + "items");
        }
    }
}

