/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.sort;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.sort.OrderKey;
import mondrian.olap.fun.sort.Sorter;
import mondrian.olap.fun.sort.TupleExpMemoComparator;

class HierarchicalTupleKeyComparator
extends TupleExpMemoComparator {
    HierarchicalTupleKeyComparator(Evaluator e, Calc calc, int arity) {
        super(e, calc, arity);
    }

    @Override
    protected int nonEqualCompare(List<Member> a1, List<Member> a2) {
        OrderKey k1 = (OrderKey)this.eval(a1);
        OrderKey k2 = (OrderKey)this.eval(a2);
        return this.compareMemberOrderKeysHierarchically(k1, k2);
    }

    private int compareMemberOrderKeysHierarchically(OrderKey k1, OrderKey k2) {
        Member prev2;
        Member prev1;
        if (k1 == Util.nullValue) {
            return -1;
        }
        if (k2 == Util.nullValue) {
            return 1;
        }
        Member m1 = k1.member;
        Member m2 = k2.member;
        if (Util.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                return -1;
            }
            if (depth1 > depth2) {
                if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                return 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        OrderKey pk1 = new OrderKey(prev1);
        OrderKey pk2 = new OrderKey(prev2);
        return Sorter.compareValues(pk1, pk2);
    }
}

