/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.extra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class CachedExistsFunDef
extends FunDefBase {
    public static final CachedExistsFunDef instance = new CachedExistsFunDef();

    CachedExistsFunDef() {
        super("CachedExists", "Returns tuples from a non-dynamic <Set> that exists in the specified <Tuple>.  This function will build a query level cache named <String> based on the <Tuple> type.", "fxxtS");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final TupleCalc tupleCalc1 = compiler.compileTuple(call.getArg(1));
        final StringCalc stringCalc = compiler.compileString(call.getArg(2));
        return new AbstractListCalc(call, new Calc[]{listCalc1, tupleCalc1, stringCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                Member[] subtotal = tupleCalc1.evaluateTuple(evaluator);
                String namedSetName = stringCalc.evaluateString(evaluator);
                Object cacheObj = evaluator.getQuery().getEvalCache(CachedExistsFunDef.this.makeSetCacheKey(namedSetName, subtotal));
                if (cacheObj != null) {
                    HashMap setCache = (HashMap)cacheObj;
                    TupleList tuples = (TupleList)setCache.get(CachedExistsFunDef.this.makeSubtotalKey(subtotal));
                    if (tuples == null) {
                        tuples = TupleCollections.emptyList(listCalc1.getType().getArity());
                    }
                    return tuples;
                }
                List listHiers = CachedExistsFunDef.this.getHierarchies(listCalc1.getType());
                List subtotalHiers = CachedExistsFunDef.this.getHierarchies(tupleCalc1.getType());
                int[] subtotalToListIndex = new int[subtotalHiers.size()];
                for (int i = 0; i < subtotalToListIndex.length; ++i) {
                    Hierarchy subtotalHier = (Hierarchy)subtotalHiers.get(i);
                    boolean found = false;
                    for (int j = 0; j < listHiers.size(); ++j) {
                        if (listHiers.get(j) != subtotalHier) continue;
                        subtotalToListIndex[i] = j;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("Hierarchy in <Tuple> not present in <Set>");
                }
                HashMap<String, TupleList> setCache = new HashMap<String, TupleList>();
                TupleList setToCache = listCalc1.evaluateList(evaluator);
                for (List tuple : setToCache) {
                    String subtotalKey = CachedExistsFunDef.this.makeSubtotalKey(subtotalToListIndex, tuple, subtotal);
                    TupleList tupleCache = (TupleList)setCache.get(subtotalKey);
                    if (tupleCache == null) {
                        tupleCache = TupleCollections.createList(listCalc1.getType().getArity());
                        setCache.put(subtotalKey, tupleCache);
                    }
                    tupleCache.add(tuple);
                }
                evaluator.getQuery().putEvalCache(CachedExistsFunDef.this.makeSetCacheKey(namedSetName, subtotal), setCache);
                TupleList tuples = (TupleList)setCache.get(CachedExistsFunDef.this.makeSubtotalKey(subtotal));
                if (tuples == null) {
                    tuples = TupleCollections.emptyList(listCalc1.getType().getArity());
                }
                return tuples;
            }
        };
    }

    private List<Hierarchy> getHierarchies(Type t) {
        ArrayList<Hierarchy> hiers = new ArrayList<Hierarchy>();
        if (t instanceof MemberType) {
            hiers.add(((MemberType)t).getHierarchy());
            return hiers;
        }
        if (t instanceof TupleType) {
            return ((TupleType)t).getHierarchies();
        }
        if (t instanceof SetType) {
            SetType setType = (SetType)t;
            if (setType.getElementType() instanceof MemberType) {
                hiers.add(((MemberType)setType.getElementType()).getHierarchy());
                return hiers;
            }
            if (setType.getElementType() instanceof TupleType) {
                return ((TupleType)setType.getElementType()).getHierarchies();
            }
        }
        throw new IllegalStateException();
    }

    private String makeSubtotalKey(int[] subtotalToListIndex, List<Member> tuple, Member[] subtotal) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < subtotal.length; ++i) {
            Member subtotalMember = subtotal[i];
            Member tupleMember = tuple.get(subtotalToListIndex[i]);
            int parentLevels = tupleMember.getDepth() - subtotalMember.getDepth();
            while (parentLevels-- > 0) {
                tupleMember = tupleMember.getParentMember();
            }
            builder.append(tupleMember.getUniqueName());
        }
        return builder.toString();
    }

    private String makeSetCacheKey(String setName, Member[] members) {
        StringBuilder builder = new StringBuilder();
        builder.append(setName);
        for (Member m : members) {
            builder.append(m.getLevel().getUniqueName());
        }
        return builder.toString();
    }

    private String makeSubtotalKey(Member[] members) {
        StringBuilder builder = new StringBuilder();
        for (Member m : members) {
            builder.append(m.getUniqueName());
        }
        return builder.toString();
    }
}

