/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.spi.MemberFormatter;

public abstract class MemberBase
extends OlapElementBase
implements Member {
    protected Member parentMember;
    protected final Level level;
    protected String uniqueName;
    protected final int flags;
    private static final int FLAG_TYPE_MASK = 7;
    private static final int FLAG_HIDDEN = 8;
    private static final int FLAG_ALL = 16;
    private static final int FLAG_NULL = 32;
    private static final int FLAG_CALCULATED = 64;
    private static final int FLAG_MEASURE = 128;
    private static final Member.MemberType[] MEMBER_TYPE_VALUES = Member.MemberType.values();

    protected MemberBase(Member parentMember, Level level, Member.MemberType memberType) {
        this.parentMember = parentMember;
        this.level = level;
        this.flags = memberType.ordinal() | (memberType == Member.MemberType.ALL ? 16 : 0) | (memberType == Member.MemberType.NULL ? 32 : 0) | (this.computeCalculated(memberType) ? 64 : 0) | (level.getHierarchy().getDimension().isMeasures() ? 128 : 0);
    }

    protected MemberBase() {
        this.flags = 0;
        this.level = null;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.getUniqueName());
    }

    @Override
    public abstract String getName();

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        String caption = super.getCaption();
        return caption != null ? caption : this.getName();
    }

    @Override
    public String getParentUniqueName() {
        return this.parentMember == null ? null : this.parentMember.getUniqueName();
    }

    @Override
    public Dimension getDimension() {
        return this.level.getDimension();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Member.MemberType getMemberType() {
        return MEMBER_TYPE_VALUES[this.flags & 7];
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue(Property.DESCRIPTION.name);
    }

    @Override
    public boolean isMeasure() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isAll() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isNull() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isCalculated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isEvaluated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }

    @Override
    public Member getParentMember() {
        return this.parentMember;
    }

    @Override
    public boolean isChildOrEqualTo(Member member) {
        return member != null && this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        return MemberBase.isChildOrEqualTo(this, uniqueName);
    }

    private static boolean isChildOrEqualTo(Member member, String uniqueName) {
        do {
            String thisUniqueName;
            if (!(thisUniqueName = member.getUniqueName()).equals(uniqueName)) continue;
            return true;
        } while ((member = member.getParentMember()) != null);
        return false;
    }

    protected boolean computeCalculated(Member.MemberType memberType) {
        return this.isCalculatedInQuery() || memberType == Member.MemberType.FORMULA;
    }

    @Override
    public int getSolveOrder() {
        return -1;
    }

    @Override
    public Exp getExpression() {
        return null;
    }

    @Override
    public List<Member> getAncestorMembers() {
        SchemaReader schemaReader = this.getDimension().getSchema().getSchemaReader();
        ArrayList<Member> ancestorList = new ArrayList<Member>();
        schemaReader.getMemberAncestors(this, ancestorList);
        return ancestorList;
    }

    @Override
    public int getOrdinal() {
        return -1;
    }

    @Override
    public Comparable getOrderKey() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Member getDataMember() {
        return null;
    }

    @Override
    public String getPropertyFormattedValue(String propertyName) {
        return this.getPropertyValue(propertyName).toString();
    }

    @Override
    public boolean isParentChildPhysicalMember() {
        return false;
    }

    @Override
    public boolean isParentChildLeaf() {
        return false;
    }

    @Override
    public boolean isOnSameHierarchyChain(Member otherMember) {
        return ((MemberBase)otherMember).isOnSameHierarchyChainInternal(this);
    }

    public boolean isOnSameHierarchyChainInternal(MemberBase otherMember) {
        return FunUtil.isAncestorOf(otherMember, this, false) || FunUtil.isAncestorOf(this, otherMember, false);
    }
}

