/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.dataservice.jdbc.BaseResultSet;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultSetMetaData;

public class RowsResultSet
extends BaseResultSet
implements ResultSet {
    private ImmutableList<Object[]> rows;

    public RowsResultSet(RowMetaInterface rowMeta, List<Object[]> rows) {
        super(rowMeta);
        this.rows = ImmutableList.copyOf(rows);
    }

    @Override
    protected Object[] retrieveRow(int i) throws Exception {
        return Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.rows.size())).contains((Comparable)Integer.valueOf(i)) ? (Object[])this.rows.get(i - 1) : null;
    }

    @Override
    public int size() throws SQLException {
        return this.rows.size();
    }

    @Override
    public void close() throws SQLException {
        this.rows = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rows == null;
    }

    @Override
    public String getCursorName() throws SQLException {
        return "rows";
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ThinResultSetMetaData("rows", this.getRowMeta());
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }
}

