/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui.validate;

import java.lang.reflect.Field;
import java.util.TreeSet;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.validate.JdbcValidator;
import mondrian.gui.validate.Messages;
import mondrian.gui.validate.TreeModel;
import mondrian.gui.validate.TreeModelPath;
import org.apache.log4j.Logger;

public class ValidationUtils {
    private static final Logger LOGGER = Logger.getLogger(ValidationUtils.class);
    static String[] DEF_LEVEL = new String[]{"column", "nameColumn", "parentColumn", "ordinalColumn", "captionColumn"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String invalid(Messages messages, JdbcValidator jdbcValidator, TreeModel treeModel, TreeModelPath tpath, Object value, MondrianGuiDef.Cube cube, MondrianGuiDef.Dimension parentDimension, MondrianGuiDef.Hierarchy parentHierarchy, MondrianGuiDef.Level parentLevel, boolean isSchemaRequired) {
        int i;
        block97: {
            block104: {
                boolean notfound;
                String sourcename;
                MondrianGuiDef.Dimension[] ds;
                block105: {
                    block116: {
                        String nameMustBeSet;
                        block115: {
                            block114: {
                                block113: {
                                    block112: {
                                        block111: {
                                            block110: {
                                                block109: {
                                                    MondrianGuiDef.Level[] levels;
                                                    block108: {
                                                        block106: {
                                                            String table;
                                                            String column;
                                                            block107: {
                                                                block103: {
                                                                    block102: {
                                                                        block101: {
                                                                            block100: {
                                                                                block99: {
                                                                                    block98: {
                                                                                        nameMustBeSet = messages.getString("schemaTreeCellRenderer.nameMustBeSet.alert", "Name must be set");
                                                                                        if (!tpath.isEmpty()) {
                                                                                            int pathcount = tpath.getPathCount();
                                                                                            for (i = 0; i < pathcount && (cube == null || parentDimension == null || parentHierarchy == null || parentLevel == null); ++i) {
                                                                                                Object p = tpath.getPathComponent(i);
                                                                                                if (p instanceof MondrianGuiDef.Cube && cube == null) {
                                                                                                    cube = (MondrianGuiDef.Cube)((Object)p);
                                                                                                }
                                                                                                if (p instanceof MondrianGuiDef.Dimension && parentDimension == null) {
                                                                                                    parentDimension = (MondrianGuiDef.Dimension)((Object)p);
                                                                                                }
                                                                                                if (p instanceof MondrianGuiDef.Hierarchy && parentHierarchy == null) {
                                                                                                    parentHierarchy = (MondrianGuiDef.Hierarchy)((Object)p);
                                                                                                }
                                                                                                if (!(p instanceof MondrianGuiDef.Level) || parentLevel != null) continue;
                                                                                                parentLevel = (MondrianGuiDef.Level)((Object)p);
                                                                                            }
                                                                                        }
                                                                                        if (!(value instanceof MondrianGuiDef.Schema)) break block98;
                                                                                        if (ValidationUtils.isEmpty(((MondrianGuiDef.Schema)((Object)value)).name)) {
                                                                                            return nameMustBeSet;
                                                                                        }
                                                                                        break block97;
                                                                                    }
                                                                                    if (!(value instanceof MondrianGuiDef.VirtualCube)) break block99;
                                                                                    MondrianGuiDef.VirtualCube virtCube = (MondrianGuiDef.VirtualCube)((Object)value);
                                                                                    if (ValidationUtils.isEmpty(virtCube.name)) {
                                                                                        return nameMustBeSet;
                                                                                    }
                                                                                    if (ValidationUtils.isEmpty((Object[])virtCube.dimensions)) {
                                                                                        return messages.getString("schemaTreeCellRenderer.cubeMustHaveDimensions.alert", "Cube must contain dimensions");
                                                                                    }
                                                                                    if (ValidationUtils.isEmpty((Object[])virtCube.measures)) {
                                                                                        return messages.getString("schemaTreeCellRenderer.cubeMustHaveMeasures.alert", "Cube must contain measures");
                                                                                    }
                                                                                    break block97;
                                                                                }
                                                                                if (!(value instanceof MondrianGuiDef.VirtualCubeDimension)) break block100;
                                                                                if (ValidationUtils.isEmpty(((MondrianGuiDef.VirtualCubeDimension)((Object)value)).name)) {
                                                                                    return nameMustBeSet;
                                                                                }
                                                                                break block97;
                                                                            }
                                                                            if (!(value instanceof MondrianGuiDef.VirtualCubeMeasure)) break block101;
                                                                            if (ValidationUtils.isEmpty(((MondrianGuiDef.VirtualCubeMeasure)((Object)value)).name)) {
                                                                                return nameMustBeSet;
                                                                            }
                                                                            break block97;
                                                                        }
                                                                        if (!(value instanceof MondrianGuiDef.Cube)) break block102;
                                                                        MondrianGuiDef.Cube cubeVal = (MondrianGuiDef.Cube)((Object)value);
                                                                        if (ValidationUtils.isEmpty(cubeVal.name)) {
                                                                            return nameMustBeSet;
                                                                        }
                                                                        if (cubeVal.fact == null) return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                                                                        if (cubeVal.fact instanceof MondrianGuiDef.Table) {
                                                                            if (ValidationUtils.isEmpty(((MondrianGuiDef.Table)cubeVal.fact).name)) return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                                                                        }
                                                                        if (cubeVal.fact instanceof MondrianGuiDef.View && ValidationUtils.isEmpty(((MondrianGuiDef.View)cubeVal.fact).alias)) {
                                                                            return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                                                                        }
                                                                        if (ValidationUtils.isEmpty((Object[])cubeVal.dimensions)) {
                                                                            return messages.getString("schemaTreeCellRenderer.cubeMustHaveDimensions.alert", "Cube must contain dimensions");
                                                                        }
                                                                        if (ValidationUtils.isEmpty((Object[])cubeVal.measures)) {
                                                                            return messages.getString("schemaTreeCellRenderer.cubeMustHaveMeasures.alert", "Cube must contain measures");
                                                                        }
                                                                        if (jdbcValidator.isInitialized() && ((MondrianGuiDef.Cube)((Object)value)).fact instanceof MondrianGuiDef.Table) {
                                                                            MondrianGuiDef.Table table2 = (MondrianGuiDef.Table)cubeVal.fact;
                                                                            String schemaName = table2.schema;
                                                                            String factTable = table2.name;
                                                                            if (!jdbcValidator.isTableExists(schemaName, factTable)) {
                                                                                return messages.getFormattedString("schemaTreeCellRenderer.factTableDoesNotExist.alert", "Fact table {0} does not exist in database {1}", factTable, schemaName == null || schemaName.equals("") ? "." : "schema " + schemaName);
                                                                            }
                                                                        }
                                                                        break block97;
                                                                    }
                                                                    if (!(value instanceof MondrianGuiDef.CubeDimension)) break block103;
                                                                    if (ValidationUtils.isEmpty(((MondrianGuiDef.CubeDimension)((Object)value)).name)) {
                                                                        return nameMustBeSet;
                                                                    }
                                                                    if (!(value instanceof MondrianGuiDef.DimensionUsage)) break block104;
                                                                    if (ValidationUtils.isEmpty(((MondrianGuiDef.DimensionUsage)((Object)value)).source)) {
                                                                        return messages.getString("schemaTreeCellRenderer.sourceMustBeSet.alert", "Source must be set");
                                                                    }
                                                                    MondrianGuiDef.Schema s = (MondrianGuiDef.Schema)((Object)treeModel.getRoot());
                                                                    ds = s.dimensions;
                                                                    sourcename = ((MondrianGuiDef.DimensionUsage)((Object)value)).source;
                                                                    notfound = true;
                                                                    break block105;
                                                                }
                                                                if (value instanceof MondrianGuiDef.Level) {
                                                                    MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)value);
                                                                    if (!ValidationUtils.isEmpty(level.levelType) && parentDimension != null) {
                                                                        if ((ValidationUtils.isEmpty(parentDimension.type) || parentDimension.type.equals("StandardDimension")) && !ValidationUtils.isEmpty(level.levelType) && !level.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                                                                            return messages.getFormattedString("schemaTreeCellRenderer.levelUsedOnlyInTimeDimension.alert", "levelType {0} can only be used with a TimeDimension", level.levelType);
                                                                        }
                                                                        if (!ValidationUtils.isEmpty(parentDimension.type) && parentDimension.type.equals("TimeDimension") && !ValidationUtils.isEmpty(level.levelType) && level.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                                                                            return messages.getFormattedString("schemaTreeCellRenderer.levelUsedOnlyInStandardDimension.alert", "levelType {0} can only be used with a StandardDimension", level.levelType);
                                                                        }
                                                                    }
                                                                    if (ValidationUtils.isEmpty(level.name)) {
                                                                        return messages.getString("schemaTreeCellRenderer.nameMustBeSet.alert", "Level name must be set");
                                                                    }
                                                                    String column2 = level.column;
                                                                    if (ValidationUtils.isEmpty(column2)) {
                                                                        if (level.properties == null) return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                        if (level.properties.length == 0) {
                                                                            return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                        }
                                                                        break block97;
                                                                    } else {
                                                                        String theMessage = null;
                                                                        try {
                                                                            int i2 = 0;
                                                                            while (i2 < DEF_LEVEL.length) {
                                                                                Field theField = ((Object)((Object)level)).getClass().getDeclaredField(DEF_LEVEL[i2]);
                                                                                column2 = (String)theField.get((Object)level);
                                                                                theMessage = ValidationUtils.validateColumn(column2, DEF_LEVEL[i2], messages, level, jdbcValidator, cube, parentHierarchy);
                                                                                if (theMessage != null) {
                                                                                    return theMessage;
                                                                                }
                                                                                ++i2;
                                                                            }
                                                                            return theMessage;
                                                                        }
                                                                        catch (Exception ex) {
                                                                            LOGGER.error((Object)"ValidationUtils", (Throwable)ex);
                                                                        }
                                                                        return theMessage;
                                                                    }
                                                                }
                                                                if (!(value instanceof MondrianGuiDef.Property)) break block106;
                                                                MondrianGuiDef.Property p = (MondrianGuiDef.Property)((Object)value);
                                                                column = p.column;
                                                                if (ValidationUtils.isEmpty(column)) {
                                                                    return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                }
                                                                if (!jdbcValidator.isInitialized()) break block97;
                                                                table = null;
                                                                if (parentLevel != null) {
                                                                    table = parentLevel.table;
                                                                }
                                                                if (!ValidationUtils.isEmpty(table)) break block107;
                                                                if (parentHierarchy != null) {
                                                                    if (parentHierarchy.relation == null && cube != null) {
                                                                        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)cube.fact;
                                                                        if (!jdbcValidator.isColExists(factTable.schema, factTable.name, column)) {
                                                                            return messages.getFormattedString("schemaTreeCellRenderer.degenDimensionColumnDoesNotExist.alert", "Degenerate dimension validation check - Column {0} does not exist in fact table", column);
                                                                        }
                                                                        break block97;
                                                                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                                                                        MondrianGuiDef.Table parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                                                                        if (!jdbcValidator.isColExists(parentTable.schema, parentTable.name, column)) {
                                                                            return messages.getFormattedString("schemaTreeCellRenderer.columnInDimensionDoesNotExist.alert", "Column {0} does not exist in Dimension table", parentTable.name);
                                                                        }
                                                                    }
                                                                }
                                                                break block97;
                                                            }
                                                            if (!jdbcValidator.isColExists(null, table, column)) {
                                                                return messages.getFormattedString("schemaTreeCellRenderer.columnInDimensionDoesNotExist.alert", "Column {0} does not exist in Level table {1}", column, table);
                                                            }
                                                            break block97;
                                                        }
                                                        if (!(value instanceof MondrianGuiDef.Measure)) break block108;
                                                        MondrianGuiDef.Measure measure = (MondrianGuiDef.Measure)((Object)value);
                                                        if (ValidationUtils.isEmpty(measure.name)) {
                                                            return nameMustBeSet;
                                                        }
                                                        if (ValidationUtils.isEmpty(measure.aggregator)) {
                                                            return messages.getString("schemaTreeCellRenderer.aggregatorMustBeSet.alert", "Aggregator must be set");
                                                        }
                                                        if (measure.measureExp == null) {
                                                            if (ValidationUtils.isEmpty(measure.column)) {
                                                                return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                            }
                                                            if (cube != null && cube.fact != null && cube.fact instanceof MondrianGuiDef.Table) {
                                                                String column;
                                                                MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)cube.fact;
                                                                if (jdbcValidator.isInitialized() && jdbcValidator.isColExists(factTable.schema, factTable.name, column = measure.column)) {
                                                                    int colType = jdbcValidator.getColumnDataType(factTable.schema, factTable.name, measure.column);
                                                                    int agIndex = -1;
                                                                    if ("sum".equals(measure.aggregator) || "avg".equals(measure.aggregator)) {
                                                                        agIndex = 0;
                                                                    }
                                                                    if (agIndex != -1 && (colType < 2 || colType > 8) && colType != -5 && colType != -6) {
                                                                        return messages.getFormattedString("schemaTreeCellRenderer.aggregatorNotValidForColumn.alert", "Aggregator {0} is not valid for the data type of the column {1}", measure.aggregator, measure.column);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        break block97;
                                                    }
                                                    if (!(value instanceof MondrianGuiDef.Hierarchy)) break block109;
                                                    MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)value);
                                                    if (hierarchy.relation instanceof MondrianGuiDef.Join) {
                                                        if (ValidationUtils.isEmpty(hierarchy.primaryKeyTable)) {
                                                            if (!ValidationUtils.isEmpty(hierarchy.primaryKey)) return messages.getString("schemaTreeCellRenderer.primaryKeyTableMustBeSet.alert", "PrimaryKeyTable must be set for Join");
                                                            return messages.getString("schemaTreeCellRenderer.primaryKeyTableAndPrimaryKeyMustBeSet.alert", "PrimaryKeyTable and PrimaryKey must be set for Join");
                                                        }
                                                        if (ValidationUtils.isEmpty(hierarchy.primaryKey)) {
                                                            return messages.getString("schemaTreeCellRenderer.primaryKeyMustBeSet.alert", "PrimaryKey must be set for Join");
                                                        }
                                                    }
                                                    if ((levels = hierarchy.levels) == null) return messages.getString("schemaTreeCellRenderer.atLeastOneLevelForHierarchy.alert", "At least one Level must be set for Hierarchy");
                                                    if (levels.length == 0) {
                                                        return messages.getString("schemaTreeCellRenderer.atLeastOneLevelForHierarchy.alert", "At least one Level must be set for Hierarchy");
                                                    }
                                                    String schema = null;
                                                    String pkTable = null;
                                                    if (hierarchy.relation instanceof MondrianGuiDef.Join) {
                                                        String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(hierarchy.relation, hierarchy.primaryKeyTable);
                                                        schema = schemaAndTable[0];
                                                        pkTable = schemaAndTable[1];
                                                    } else if (hierarchy.relation instanceof MondrianGuiDef.Table) {
                                                        MondrianGuiDef.Table table = (MondrianGuiDef.Table)hierarchy.relation;
                                                        pkTable = table.name;
                                                        schema = table.schema;
                                                    }
                                                    if (pkTable != null && !jdbcValidator.isColExists(schema, pkTable, hierarchy.primaryKey)) {
                                                        return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(hierarchy.primaryKey.trim()) ? "' '" : hierarchy.primaryKey, "primaryKey", pkTable);
                                                    }
                                                    if (hierarchy.relation instanceof MondrianGuiDef.Table && !ValidationUtils.isEmpty(hierarchy.primaryKeyTable)) {
                                                        return messages.getString("schemaTreeCellRenderer.fieldMustBeEmpty", "Table field must be empty");
                                                    }
                                                    String primaryKeyTable = hierarchy.primaryKeyTable;
                                                    if (!ValidationUtils.isEmpty(primaryKeyTable) && hierarchy.relation instanceof MondrianGuiDef.Join) {
                                                        TreeSet<String> joinTables = new TreeSet<String>();
                                                        SchemaExplorer.getTableNamesForJoin(hierarchy.relation, joinTables);
                                                        if (!joinTables.contains(primaryKeyTable)) {
                                                            return messages.getString("schemaTreeCellRenderer.wrongTableValue", "Table value does not correspond to any join");
                                                        }
                                                    }
                                                    if (!ValidationUtils.isEmpty(primaryKeyTable) && hierarchy.relation instanceof MondrianGuiDef.Table) {
                                                        String compareTo;
                                                        MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)hierarchy.relation;
                                                        String string = compareTo = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                                                        if (!primaryKeyTable.equals(compareTo)) {
                                                            return messages.getString("schemaTreeCellRenderer.tableDoesNotMatch", "Table value does not correspond to Hierarchy Relation");
                                                        }
                                                    }
                                                    break block97;
                                                }
                                                if (!(value instanceof MondrianGuiDef.NamedSet)) break block110;
                                                MondrianGuiDef.NamedSet namedSet = (MondrianGuiDef.NamedSet)((Object)value);
                                                if (ValidationUtils.isEmpty(namedSet.name)) {
                                                    return nameMustBeSet;
                                                }
                                                if (ValidationUtils.isEmpty(namedSet.formula) && namedSet.formulaElement == null) {
                                                    return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                                                }
                                                break block97;
                                            }
                                            if (!(value instanceof MondrianGuiDef.Formula)) break block111;
                                            MondrianGuiDef.Formula formula = (MondrianGuiDef.Formula)((Object)value);
                                            if (ValidationUtils.isEmpty(formula.cdata)) {
                                                return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                                            }
                                            break block97;
                                        }
                                        if (!(value instanceof MondrianGuiDef.UserDefinedFunction)) break block112;
                                        MondrianGuiDef.UserDefinedFunction udf = (MondrianGuiDef.UserDefinedFunction)((Object)value);
                                        if (ValidationUtils.isEmpty(udf.name)) {
                                            return nameMustBeSet;
                                        }
                                        if (ValidationUtils.isEmpty(udf.className) && udf.script == null) {
                                            return messages.getString("Either a Class Name or a Script are required", "Class name must be set");
                                        }
                                        break block97;
                                    }
                                    if (!(value instanceof MondrianGuiDef.MemberFormatter)) break block113;
                                    MondrianGuiDef.MemberFormatter f = (MondrianGuiDef.MemberFormatter)((Object)value);
                                    if (ValidationUtils.isEmpty(f.className) && f.script == null) {
                                        return messages.getString("schemaTreeCellRenderer.classNameOrScriptRequired.alert", "Either a Class Name or a Script are required");
                                    }
                                    break block97;
                                }
                                if (!(value instanceof MondrianGuiDef.CellFormatter)) break block114;
                                MondrianGuiDef.CellFormatter f = (MondrianGuiDef.CellFormatter)((Object)value);
                                if (ValidationUtils.isEmpty(f.className) && f.script == null) {
                                    return messages.getString("schemaTreeCellRenderer.classNameOrScriptRequired.alert", "Either a Class Name or a Script are required");
                                }
                                break block97;
                            }
                            if (!(value instanceof MondrianGuiDef.PropertyFormatter)) break block115;
                            MondrianGuiDef.PropertyFormatter f = (MondrianGuiDef.PropertyFormatter)((Object)value);
                            if (ValidationUtils.isEmpty(f.className) && f.script == null) {
                                return messages.getString("schemaTreeCellRenderer.classNameOrScriptRequired.alert", "Either a Class Name or a Script are required");
                            }
                            break block97;
                        }
                        if (!(value instanceof MondrianGuiDef.CalculatedMember)) break block116;
                        MondrianGuiDef.CalculatedMember calculatedMember = (MondrianGuiDef.CalculatedMember)((Object)value);
                        if (ValidationUtils.isEmpty(calculatedMember.name)) {
                            return nameMustBeSet;
                        }
                        if (ValidationUtils.isEmpty(calculatedMember.dimension)) {
                            return messages.getString("schemaTreeCellRenderer.dimensionMustBeSet.alert", "Dimension must be set");
                        }
                        if (ValidationUtils.isEmpty(calculatedMember.formula) && calculatedMember.formulaElement == null) {
                            return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                        }
                        break block97;
                    }
                    if (value instanceof MondrianGuiDef.Join) {
                        MondrianGuiDef.Join join = (MondrianGuiDef.Join)((Object)value);
                        if (ValidationUtils.isEmpty(join.leftKey)) {
                            return messages.getString("schemaTreeCellRenderer.leftKeyMustBeSet.alert", "Left key must be set");
                        }
                        if (ValidationUtils.isEmpty(join.rightKey)) {
                            return messages.getString("schemaTreeCellRenderer.rightKeyMustBeSet.alert", "Right key must be set");
                        }
                        break block97;
                    } else if (value instanceof MondrianGuiDef.Table) {
                        MondrianGuiDef.Table table = (MondrianGuiDef.Table)((Object)value);
                        String tableName = table.name;
                        if (!jdbcValidator.isTableExists(null, tableName)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.tableDoesNotExist.alert", "Table {0} does not exist in database", tableName);
                        }
                        String theSchema = table.schema;
                        if (!ValidationUtils.isEmpty(theSchema) && !jdbcValidator.isSchemaExists(theSchema)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.schemaDoesNotExist.alert", "Schema {0} does not exist", theSchema);
                        }
                        if (ValidationUtils.isEmpty(theSchema) && isSchemaRequired) {
                            return messages.getString("schemaTreeCellRenderer.schemaMustBeSet.alert", "Schema must be set");
                        }
                    }
                    break block97;
                }
                for (int j = 0; j < ds.length; ++j) {
                    if (!ds[j].name.equalsIgnoreCase(sourcename)) continue;
                    notfound = false;
                    break;
                }
                if (notfound) {
                    return messages.getFormattedString("schemaTreeCellRenderer.sourceInSharedDimensionDoesNotExist.alert", "Source {0} does not exist as Shared Dimension of Schema", sourcename);
                }
            }
            if (value instanceof MondrianGuiDef.Dimension && cube != null && !ValidationUtils.isEmpty(((MondrianGuiDef.Dimension)((Object)value)).foreignKey) && jdbcValidator.isInitialized() && cube.fact instanceof MondrianGuiDef.Table) {
                MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)cube.fact;
                String foreignKey = ((MondrianGuiDef.Dimension)((Object)value)).foreignKey;
                if (!jdbcValidator.isColExists(factTable.schema, factTable.name, foreignKey)) {
                    return messages.getFormattedString("schemaTreeCellRenderer.foreignKeyDoesNotExist.alert", "foreignKey {0} does not exist in fact table", foreignKey);
                }
            }
        }
        int childCnt = treeModel.getChildCount(value);
        i = 0;
        while (i < childCnt) {
            String childErrMsg;
            Object child = treeModel.getChild(value, i);
            if (child instanceof MondrianGuiDef.Cube) {
                childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, (MondrianGuiDef.Cube)((Object)child), parentDimension, parentHierarchy, parentLevel, isSchemaRequired);
            } else if (child instanceof MondrianGuiDef.Dimension) {
                childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, (MondrianGuiDef.Dimension)((Object)child), parentHierarchy, parentLevel, isSchemaRequired);
            } else if (child instanceof MondrianGuiDef.Hierarchy) {
                if (value instanceof MondrianGuiDef.Dimension && cube != null && ((MondrianGuiDef.Hierarchy)((Object)child)).relation != null && ValidationUtils.isEmpty(((MondrianGuiDef.Dimension)((Object)value)).foreignKey)) {
                    return messages.getString("schemaTreeCellRenderer.foreignKeyMustBeSet.alert", "Foreign key must be set");
                }
                childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, parentDimension, (MondrianGuiDef.Hierarchy)((Object)child), parentLevel, isSchemaRequired);
            } else {
                childErrMsg = child instanceof MondrianGuiDef.Level ? ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, parentDimension, parentHierarchy, (MondrianGuiDef.Level)((Object)child), isSchemaRequired) : ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, parentDimension, parentHierarchy, parentLevel, isSchemaRequired);
            }
            if (childErrMsg != null) {
                String childClassName = child.getClass().getName();
                String[] simpleName = childClassName.split("[$.]", 0);
                try {
                    Field f = child.getClass().getField("name");
                    String childName = (String)f.get(child);
                    if (childName == null) {
                        childName = "";
                    }
                    return messages.getFormattedString("schemaTreeCellRenderer.childErrorMessageWithName.alert", "{0} {1} is invalid", simpleName[simpleName.length - 1], childName);
                }
                catch (Exception ex) {
                    return messages.getFormattedString("schemaTreeCellRenderer.childErrorExceptionMessage.alert", "{0} is invalid", simpleName[simpleName.length - 1]);
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isEmpty(String v) {
        return v == null || v.equals("");
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    private static String validateColumn(String column, String fieldName, Messages messages, MondrianGuiDef.Level level, JdbcValidator jdbcValidator, MondrianGuiDef.Cube cube, MondrianGuiDef.Hierarchy parentHierarchy) {
        if (!ValidationUtils.isEmpty(column) && jdbcValidator.isInitialized()) {
            MondrianGuiDef.Table parentTable;
            String table = level.table;
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                TreeSet<String> joinTables = new TreeSet<String>();
                SchemaExplorer.getTableNamesForJoin(parentHierarchy.relation, joinTables);
                if (!joinTables.contains(table)) {
                    return messages.getString("schemaTreeCellRenderer.wrongTableValue", "Table value does not correspond to any join");
                }
            }
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                String compareTo;
                MondrianGuiDef.Table theTable = parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                String string = compareTo = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                if (!table.equals(compareTo)) {
                    return messages.getString("schemaTreeCellRenderer.tableDoesNotMatch", "Table value does not correspond to Hierarchy Relation");
                }
            }
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.View) {
                return messages.getString("schemaTreeCellRenderer.noTableForView", "Table for column cannot be set in View");
            }
            if (ValidationUtils.isEmpty(table)) {
                if (parentHierarchy != null) {
                    if (parentHierarchy.relation == null && cube != null) {
                        if (!jdbcValidator.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.degenDimensionColumnDoesNotExist.alert", "Degenerate dimension validation check - Column {0} does not exist in fact table", column);
                        }
                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                        parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                        if (!jdbcValidator.isColExists(parentTable.schema, parentTable.name, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(column.trim()) ? "' '" : column, fieldName, parentTable.name);
                        }
                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                        return messages.getString("schemaTreeCellRenderer.tableMustBeSet.alert", "Table must be set");
                    }
                }
            } else {
                String schema = null;
                if (parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                    String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(parentHierarchy.relation, table);
                    schema = schemaAndTable[0];
                    table = schemaAndTable[1];
                }
                if (!jdbcValidator.isColExists(schema, table, column)) {
                    return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(column.trim()) ? "' '" : column, fieldName, table);
                }
            }
        }
        return null;
    }
}

