/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.SchemaTreeModel;
import mondrian.gui.Workbench;
import mondrian.gui.validate.ValidationUtils;
import mondrian.gui.validate.impl.WorkbenchJdbcValidator;
import mondrian.gui.validate.impl.WorkbenchMessages;
import mondrian.gui.validate.impl.WorkbenchTreeModel;
import mondrian.gui.validate.impl.WorkbenchTreeModelPath;
import org.eigenbase.xom.ElementDef;

public class SchemaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    public boolean invalidFlag;
    private JdbcMetaData jdbcMetaData;
    private final Workbench workbench;

    public SchemaTreeCellRenderer(Workbench workbench, JdbcMetaData jdbcMetaData) {
        this.workbench = workbench;
        this.jdbcMetaData = jdbcMetaData;
    }

    public SchemaTreeCellRenderer() {
        this(null, null);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.invalidFlag = this.isInvalid(tree, value, row);
        this.setPreferredSize(null);
        if (value instanceof MondrianGuiDef.Cube) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Cube)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("cube"))));
        } else if (value instanceof MondrianGuiDef.Column) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Column)value).name);
        } else if (value instanceof MondrianGuiDef.Dimension) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("dimension"))));
            this.setText(this.invalidFlag, ((MondrianGuiDef.CubeDimension)((Object)value)).name);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.DimensionUsage) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("dimensionUsage"))));
            this.setText(this.invalidFlag, ((MondrianGuiDef.CubeDimension)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.KeyExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("key"))));
            this.setText(this.workbench.getResourceConverter().getString("common.keyExpression.title", "Key Expression"));
        } else if (value instanceof MondrianGuiDef.NameExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("name"))));
            this.setText(this.workbench.getResourceConverter().getString("common.nameExpression.title", "Name Expression"));
        } else if (value instanceof MondrianGuiDef.OrdinalExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("ordinal"))));
            this.setText(this.workbench.getResourceConverter().getString("common.ordinalExpression.title", "Ordinal Expression"));
        } else if (value instanceof MondrianGuiDef.CaptionExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("name"))));
            this.setText(this.workbench.getResourceConverter().getString("common.captionExpression.title", "Caption Expression"));
        } else if (value instanceof MondrianGuiDef.ParentExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("parent"))));
            this.setText(this.workbench.getResourceConverter().getString("common.parentExpression.title", "Parent Expression"));
        } else if (value instanceof MondrianGuiDef.Expression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("expression"))));
            this.setText(this.workbench.getResourceConverter().getString("common.expression.title", "Expression"));
        } else if (value instanceof MondrianGuiDef.ExpressionView) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("expression"))));
            this.setText(this.workbench.getResourceConverter().getString("common.expressionView.title", "Expression View"));
        } else if (value instanceof MondrianGuiDef.Hierarchy) {
            String name = ((MondrianGuiDef.Hierarchy)((Object)value)).name;
            if (name == null || name.trim().length() == 0) {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.hierarchy.default.name", "default"));
            } else {
                this.setText(this.invalidFlag, name);
            }
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("hierarchy"))));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.RelationOrJoin) {
            Object parent;
            TreePath parentpath;
            TreePath tpath = tree.getPathForRow(row);
            String prefix = "";
            if (tpath != null && (parentpath = tpath.getParentPath()) != null && (parent = parentpath.getLastPathComponent()) instanceof MondrianGuiDef.Join) {
                int indexOfChild = tree.getModel().getIndexOfChild(parent, value);
                switch (indexOfChild) {
                    case 0: {
                        prefix = this.workbench.getResourceConverter().getString("common.left.title", "Left") + " ";
                        break;
                    }
                    case 1: {
                        prefix = this.workbench.getResourceConverter().getString("common.right.title", "Right") + " ";
                    }
                }
            }
            if (value instanceof MondrianGuiDef.Join) {
                this.setText(this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.join.title", "{0}Join", prefix));
                super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("join"))));
            } else if (value instanceof MondrianGuiDef.Table) {
                MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)((Object)value);
                String theName = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                this.setText(this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.table.title", "{0}Table: {1}", prefix.length() == 0 ? "" : prefix + " : ", theName));
                super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("table"))));
            } else if (value instanceof MondrianGuiDef.View) {
                this.setText(this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.view.title", "View", new Object[0]));
            }
            this.getPreferredSize();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 35, 24));
        } else if (value instanceof MondrianGuiDef.Level) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Level)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("level"))));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.Measure) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Measure)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("measure"))));
        } else if (value instanceof MondrianGuiDef.Formula) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Formula)((Object)value)).getName());
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("formula"))));
        } else if (value instanceof MondrianGuiDef.MemberReaderParameter) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.MemberReaderParameter)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.Property) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Property)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("property"))));
        } else if (value instanceof MondrianGuiDef.Schema) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.schema.title", "Schema"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("schema"))));
        } else if (value instanceof MondrianGuiDef.NamedSet) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.NamedSet)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("namedSet"))));
        } else if (value instanceof MondrianGuiDef.CalculatedMember) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.CalculatedMember)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("calculatedMember"))));
        } else if (value instanceof MondrianGuiDef.CalculatedMemberProperty) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.CalculatedMemberProperty)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("nopic"))));
        } else if (value instanceof MondrianGuiDef.UserDefinedFunction) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.UserDefinedFunction)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("userDefinedFunction"))));
        } else if (value instanceof MondrianGuiDef.MemberFormatter) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.memberFormatter.title", "Member Formatter"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("format"))));
        } else if (value instanceof MondrianGuiDef.CellFormatter) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.cellFormatter.title", "Cell Formatter"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("format"))));
        } else if (value instanceof MondrianGuiDef.PropertyFormatter) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.propertyFormatter.title", "Property Formatter"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("format"))));
        } else if (value instanceof MondrianGuiDef.Script) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.script.title", "Script"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("script"))));
        } else if (value instanceof MondrianGuiDef.Role) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Role)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("role"))));
        } else if (value instanceof MondrianGuiDef.Parameter) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Parameter)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("parameter"))));
        } else if (value instanceof MondrianGuiDef.SchemaGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.schemaGrant.title", "Schema Grant"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("schemaGrant"))));
        } else if (value instanceof MondrianGuiDef.CubeGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.cubeGrant.title", "Cube Grant"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("cubeGrant"))));
        } else if (value instanceof MondrianGuiDef.DimensionGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.dimensionGrant.title", "Dimension Grant"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("dimensionGrant"))));
        } else if (value instanceof MondrianGuiDef.HierarchyGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.hierarchyGrant.title", "Hierarchy Grant"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("hierarchyGrant"))));
        } else if (value instanceof MondrianGuiDef.MemberGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.memberGrant.title", "Member Grant"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("memberGrant"))));
        } else if (value instanceof MondrianGuiDef.Annotations) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.annotations.title", "Annotations"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("annotations"))));
        } else if (value instanceof MondrianGuiDef.Annotation) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Annotation)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("annotation"))));
        } else if (value instanceof MondrianGuiDef.SQL) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.SQL)((Object)value)).dialect);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("sql"))));
        } else if (value instanceof MondrianGuiDef.View) {
            this.setText(this.workbench.getResourceConverter().getString("common.view.title", "View"));
        } else if (value instanceof MondrianGuiDef.VirtualCube) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCube)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("virtualCube"))));
        } else if (value instanceof MondrianGuiDef.VirtualCubeDimension) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCubeDimension)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("virtualCubeDimension"))));
        } else if (value instanceof MondrianGuiDef.VirtualCubeMeasure) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCubeMeasure)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("virtualCubeMeasure"))));
        } else if (value instanceof MondrianGuiDef.AggName) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggName.title", "Aggregate Name"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggTable"))));
        } else if (value instanceof MondrianGuiDef.AggForeignKey) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggForeignKey.title", "Aggregate Foreign Key"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggForeignKey"))));
        } else if (value instanceof MondrianGuiDef.AggIgnoreColumn) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggIgnoreColumn.title", "Aggregate Ignore Column"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggIgnoreColumn"))));
        } else if (value instanceof MondrianGuiDef.AggLevel) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggLevel.title", "Aggregate Level"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggLevel"))));
        } else if (value instanceof MondrianGuiDef.AggLevelProperty) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggLevelProperty.title", "Aggregate Level Property"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("property"))));
        } else if (value instanceof MondrianGuiDef.AggMeasure) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggMeasure.title", "Aggregate Measure"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggMeasure"))));
        } else if (value instanceof MondrianGuiDef.AggPattern) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggPattern.title", "Aggregate Pattern"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggPattern"))));
        } else if (value instanceof MondrianGuiDef.AggExclude) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggExclude.title", "Aggregate Exclude"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggExclude"))));
        } else if (value instanceof MondrianGuiDef.Closure) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.closure.title", "Closure"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("closure"))));
        } else if (value instanceof ElementDef) {
            this.setText(((ElementDef)value).getName());
        } else {
            super.setText("");
        }
        return this;
    }

    public String invalid(JTree tree, TreePath tpath, Object value) {
        return this.invalid(tree, tpath, value, null, null, null, null);
    }

    public String invalid(JTree tree, TreePath tpath, Object value, MondrianGuiDef.Cube cube, MondrianGuiDef.Dimension parentDimension, MondrianGuiDef.Hierarchy parentHierarchy, MondrianGuiDef.Level parentLevel) {
        return ValidationUtils.invalid(new WorkbenchMessages(this.workbench.getResourceConverter()), new WorkbenchJdbcValidator(this.jdbcMetaData), new WorkbenchTreeModel((SchemaTreeModel)tree.getModel()), new WorkbenchTreeModelPath(tpath), value, cube, parentDimension, parentHierarchy, parentLevel, this.jdbcMetaData.getRequireSchema());
    }

    private boolean isInvalid(JTree tree, Object value, int row) {
        return this.invalid(tree, tree.getPathForRow(row), value) != null;
    }

    public void setText(boolean invalidFlag, String myText) {
        if (invalidFlag) {
            myText = "<html><FONT COLOR=RED><b>x</b></FONT><FONT COLOR=" + this.getForeground().hashCode() + ">" + myText + "</FONT></html>";
        }
        this.setText(myText);
    }

    public void setMetaData(JdbcMetaData jdbcMetaData) {
        this.jdbcMetaData = jdbcMetaData;
    }
}

