/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class JdbcTreeModel
implements TreeModel {
    private static final Logger LOGGER = Logger.getLogger(JdbcTreeModel.class);
    private Vector treeModelListeners = new Vector();
    Connection connection;
    DatabaseMetaData metadata;
    List catalogs;
    Node root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcTreeModel(Connection c) {
        this.connection = c;
        try {
            Node cat;
            block20: {
                this.metadata = this.connection.getMetaData();
                this.catalogs = new ArrayList();
                String catalogName = this.connection.getCatalog();
                cat = new Node(catalogName, 0);
                ResultSet trs = this.metadata.getTables(cat.name, null, null, null);
                block16: while (true) {
                    while (trs.next()) {
                        String tbname = trs.getString("TABLE_NAME");
                        if (!tbname.matches("(?!BIN\\$).+")) continue;
                        Node table = new Node(trs.getString(3), 1);
                        cat.children.add(table);
                        ResultSet crs = this.metadata.getColumns(cat.name, null, table.name, null);
                        try {
                            while (crs.next()) {
                                Node column = new Node(crs.getString(4), 2);
                                table.children.add(column);
                            }
                        }
                        finally {
                            try {
                                if (crs == null) continue block16;
                                crs.close();
                                continue block16;
                            }
                            catch (Exception exception) {}
                            continue;
                            continue block16;
                        }
                    }
                    break block20;
                    break;
                }
                finally {
                    try {
                        if (trs != null) {
                            trs.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            this.root = cat;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"JdbcTreeModel", (Throwable)ex);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof Node) {
            return ((Node)parent).children.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Node) {
            return ((Node)parent).children.size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Node) {
            return ((Node)parent).children.indexOf(child);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    class Node {
        static final int CATALOG = 0;
        static final int TABLE = 1;
        static final int COLUMN = 2;
        String name;
        int type;
        ArrayList children;

        public Node(String n, int t) {
            this.name = n;
            this.type = t;
            this.children = new ArrayList();
        }

        public String toString() {
            return this.name;
        }
    }
}

