/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.function.math.SumFunction;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.DefaultNumberSequence;

public class SumAFunction
extends SumFunction {
    @Override
    public String getCanonicalName() {
        return "SUMA";
    }

    @Override
    protected boolean isStrictSequenceNeeded() {
        return false;
    }

    @Override
    protected NumberSequence convertToNumberSequence(FormulaContext context, ParameterCallback parameters, int paramIdx) throws EvaluationException {
        try {
            return super.convertToNumberSequence(context, parameters, paramIdx);
        }
        catch (EvaluationException e) {
            if (522 == e.getErrorValue().getErrorCode()) {
                throw e;
            }
            Type type = parameters.getRaw(paramIdx).getValueType();
            if (type.isFlagSet(2)) {
                return new DefaultNumberSequence(new StaticValue((Object)BigDecimal.ZERO, NumberType.GENERIC_NUMBER), context);
            }
            if (type.isFlagSet(32)) {
                Boolean value = (Boolean)parameters.getRaw(paramIdx).evaluate().getValue();
                return new DefaultNumberSequence(new StaticValue((Object)(value != false ? BigDecimal.ONE : BigDecimal.ZERO), NumberType.GENERIC_NUMBER), context);
            }
            return new DefaultNumberSequence(context);
        }
    }
}

