/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class MinFunction
implements Function {
    private static final long serialVersionUID = 255618510939561419L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            return new TypeValuePair(NumberType.GENERIC_NUMBER, BigDecimal.ZERO);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        BigDecimal last = null;
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Type type = parameters.getType(paramIdx);
            Object value = parameters.getValue(paramIdx);
            NumberSequence sequence = typeRegistry.convertToNumberSequence(type, value, this.isStrictSequenceNeeded());
            while (sequence.hasNext()) {
                LValue rawValue = sequence.nextRawValue();
                if (rawValue == null) {
                    throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
                }
                TypeValuePair nextValue = rawValue.evaluate();
                Number number = typeRegistry.convertToNumber(nextValue.getType(), nextValue.getValue());
                BigDecimal next = NumberUtil.getAsBigDecimal(number);
                if (last != null && last.compareTo(next) <= 0) continue;
                last = next;
            }
        }
        if (last == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, last);
    }

    protected boolean isStrictSequenceNeeded() {
        return true;
    }

    @Override
    public String getCanonicalName() {
        return "MIN";
    }
}

