/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.table;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.FastPropertyEditorManager;

public class ArrayAccessUtility {
    public static boolean isArray(Object array) {
        if (array == null) {
            return false;
        }
        return array.getClass().isArray();
    }

    public static Object[] normalizeArray(Object array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        Object[] retval = new Object[Array.getLength(array)];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Array.get(array, i);
        }
        return retval;
    }

    public static Object normalizeNative(Object[] data, Class arrayType) {
        Object array = Array.newInstance(arrayType, data.length);
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            if (o != null && !arrayType.isInstance(o)) {
                throw new ClassCastException("Object " + o + " cannot be cast to " + arrayType);
            }
            Array.set(array, i, o);
        }
        return array;
    }

    public static String getArrayAsString(Object array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value;
            if (i > 0) {
                b.append(", ");
            }
            if ((value = Array.get(array, i)) == null) {
                b.append("<null>");
                continue;
            }
            if (value instanceof String) {
                b.append(value);
                continue;
            }
            PropertyEditor propertyEditor = FastPropertyEditorManager.findEditor(value.getClass());
            if (propertyEditor != null) {
                propertyEditor.setValue(value);
                b.append(propertyEditor.getAsText());
                continue;
            }
            b.append(value);
        }
        b.append(']');
        return b.toString();
    }
}

