/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.date.DateConverter;

public class TimeCellEditor
extends JPanel
implements TableCellEditor {
    private static final Log logger = LogFactory.getLog(TimeCellEditor.class);
    private JTextField dateField;
    private DateFormat sdf;
    private Class dateType;
    private EventListenerList listeners = new EventListenerList();
    private Date date;
    private static final String DEFAULT_FORMAT = "HH:mm:ss.SSS";

    public TimeCellEditor(Class dateType) {
        this.dateType = dateType;
        if (this.dateType.isArray()) {
            this.dateType = this.dateType.getComponentType();
        }
        this.dateField = new JTextField();
        this.dateField.setColumns(20);
        TextComponentEditHandler listener = new TextComponentEditHandler(this.dateField);
        this.dateField.getDocument().addDocumentListener(listener);
        this.dateField.addActionListener(listener);
        this.setLayout(new BorderLayout());
        this.dateField.setEditable(true);
        this.add((Component)this.dateField, "Center");
        this.setDateFormat(this.createDateFormat(DEFAULT_FORMAT, Locale.getDefault(), TimeZone.getDefault()));
    }

    private DateFormat createDateFormat(String parameterFormatString, Locale locale, TimeZone timeZone) {
        if (parameterFormatString != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(parameterFormatString, new DateFormatSymbols(locale));
                dateFormat.setTimeZone(timeZone);
                dateFormat.setLenient(true);
                return dateFormat;
            }
            catch (Exception e) {
                logger.warn((Object)"Parameter format-string for date-parameter was not a valid date-format-string", (Throwable)e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT, new DateFormatSymbols(locale));
        dateFormat.setTimeZone(timeZone);
        dateFormat.setLenient(true);
        return dateFormat;
    }

    private void setDate(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            try {
                Date date;
                this.date = date = this.convertValue((String)value);
                this.dateField.setText(this.sdf.format(date));
            }
            catch (Exception e) {
                logger.debug((Object)"Unparsable date-string", (Throwable)e);
            }
        } else if (value instanceof Date) {
            Date date;
            this.date = date = (Date)value;
            this.dateField.setText(this.sdf.format(date));
        } else {
            logger.debug((Object)("Date-parameter must be set either as normalized date-string or as date-object: " + value + " [" + value.getClass() + "]"));
        }
    }

    protected Date convertValue(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        try {
            Date o = (Date)this.sdf.parseObject(text);
            return DateConverter.convertToDateType(o, this.dateType);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to format object", e);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setDate(value);
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        return this.date;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() >= 2 && mouseEvent.getButton() == 1;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.listeners.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.listeners.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(CellEditorListener.class, l);
    }

    public void setDateFormat(DateFormat timeFormat) {
        if (timeFormat == null) {
            throw new NullPointerException();
        }
        this.sdf = timeFormat;
        this.setDate(this.getCellEditorValue());
        if (timeFormat instanceof SimpleDateFormat) {
            SimpleDateFormat dateFormat = (SimpleDateFormat)timeFormat;
            this.setToolTipText(dateFormat.toLocalizedPattern());
        } else {
            this.setToolTipText(null);
        }
    }

    public DateFormat getDateFormat() {
        return this.sdf;
    }

    private class TextComponentEditHandler
    implements Runnable,
    DocumentListener,
    ActionListener {
        private JTextComponent textComponent;
        private Color color;
        private boolean inProgress;

        public TextComponentEditHandler(JTextComponent textComponent) {
            this.textComponent = textComponent;
            this.color = this.textComponent.getBackground();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.convertParameterValue();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.convertParameterValue();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.convertParameterValue();
        }

        private void convertParameterValue() {
            if (this.inProgress) {
                return;
            }
            this.inProgress = true;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.convert();
        }

        protected void convert() {
            try {
                String text = this.textComponent.getText();
                this.textComponent.setBackground(this.color);
                Date date = TimeCellEditor.this.convertValue(text);
                TimeCellEditor.this.date = date;
            }
            catch (Exception e) {
                this.textComponent.setBackground(Color.RED);
            }
            finally {
                this.inProgress = false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.convert();
        }
    }
}

