/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata.InlineTableDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata.InlineTableRowReadHandler;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InlineTableReadHandler
extends AbstractXmlReadHandler {
    private String name;
    private TypedTableModel data;
    private InlineTableDefinitionReadHandler definitionReadHandler;
    private ArrayList rows = new ArrayList();

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Required attribute 'name' is not defined.", this.getLocator());
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("definition".equals(tagName)) {
            this.definitionReadHandler = new InlineTableDefinitionReadHandler();
            return this.definitionReadHandler;
        }
        if ("row".equals(tagName)) {
            if (this.definitionReadHandler == null) {
                throw new ParseException("A table-definition has to be specified before any row can be defined.", this.getLocator());
            }
            InlineTableRowReadHandler rowReadHandler = new InlineTableRowReadHandler(this.definitionReadHandler.getTypes());
            this.rows.add(rowReadHandler);
            return rowReadHandler;
        }
        return null;
    }

    public TableModel getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    protected void doneParsing() throws SAXException {
        this.data = new TypedTableModel(this.definitionReadHandler.getNames(), this.definitionReadHandler.getTypes(), this.rows.size());
        for (int row = 0; row < this.rows.size(); ++row) {
            InlineTableRowReadHandler handler = (InlineTableRowReadHandler)((Object)this.rows.get(row));
            Object[] data = (Object[])handler.getObject();
            for (int column = 0; column < data.length; ++column) {
                Object value = data[column];
                this.data.setValueAt(value, row, column);
            }
        }
    }

    public Object getObject() throws SAXException {
        return this.data;
    }
}

