/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFFontWrapper;

public class ExcelFontFactory {
    private HashMap<HSSFFontWrapper, Font> fonts;
    private final Workbook workbook;

    public ExcelFontFactory(Workbook workbook, ExcelColorProducer colorProducer) {
        if (workbook == null) {
            throw new NullPointerException();
        }
        if (colorProducer == null) {
            throw new NullPointerException();
        }
        this.fonts = new HashMap();
        this.workbook = workbook;
        int numberOfFonts = this.workbook.getNumberOfFonts();
        for (int i = 0; i < numberOfFonts; ++i) {
            Font font = workbook.getFontAt((short)i);
            this.fonts.put(new HSSFFontWrapper(font), font);
        }
        HSSFFontWrapper wrapper = new HSSFFontWrapper("Arial", 10, false, false, false, false, colorProducer.getNearestColor(Color.black));
        this.getExcelFont(wrapper);
    }

    public Font getExcelFont(HSSFFontWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        if (this.fonts.containsKey(wrapper)) {
            return this.fonts.get(wrapper);
        }
        Font excelFont = this.createFont(wrapper);
        this.fonts.put(wrapper, excelFont);
        return excelFont;
    }

    private Font createFont(HSSFFontWrapper wrapper) {
        Font font = this.workbook.createFont();
        font.setBold(wrapper.isBold());
        font.setColor(wrapper.getColorIndex());
        font.setFontName(wrapper.getFontName());
        font.setFontHeightInPoints((short)wrapper.getFontHeight());
        font.setItalic(wrapper.isItalic());
        font.setStrikeout(wrapper.isStrikethrough());
        if (wrapper.isUnderline()) {
            font.setUnderline((byte)1);
        } else {
            font.setUnderline((byte)0);
        }
        return font;
    }
}

