/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import java.awt.Window;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.AWTPrintingGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class PrintingPlugin
extends AbstractExportActionPlugin {
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages", ObjectUtilities.getClassLoader(PrintingPlugin.class));
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.print.ProgressDialogEnabled";

    @Override
    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(AWTPrintingGUIModule.class.getName());
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    @Override
    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("printing-export.progressdialog.message"));
        progressDialog.pack();
        LibSwingUtil.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.print.print.";
    }

    @Override
    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        if ("true".equals(report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false"))) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        PrintExportTask task = new PrintExportTask(report, progressDialog, this.getContext());
        Thread worker = new Thread(task);
        worker.start();
        return true;
    }

    @Override
    public String getDisplayName() {
        return this.resources.getString("action.print.name");
    }

    @Override
    public String getShortDescription() {
        return this.resources.getString("action.print.description");
    }

    @Override
    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.print.small-icon");
    }

    @Override
    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.print.icon");
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.print.accelerator");
    }

    @Override
    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.print.mnemonic");
    }
}

