/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;

public final class PhysicalPageKey
implements Serializable {
    private LogicalPageKey logicalPage;
    private int x;
    private int y;

    public PhysicalPageKey(LogicalPageKey logicalPage, int x, int y) {
        if (logicalPage == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        this.logicalPage = logicalPage;
    }

    public LogicalPageKey getLogicalPage() {
        return this.logicalPage;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSequentialPageNumber() {
        int logPosition = this.logicalPage.getPosition();
        return logPosition * this.logicalPage.getWidth() * this.logicalPage.getHeight() + this.x + this.y * this.logicalPage.getWidth();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalPageKey that = (PhysicalPageKey)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        return this.logicalPage.equals(that.logicalPage);
    }

    public int hashCode() {
        int result = this.logicalPage.hashCode();
        result = 29 * result + this.x;
        result = 29 * result + this.y;
        return result;
    }

    public String toString() {
        return "PhysicalPageKey{logicalPage=[" + this.logicalPage.getPosition() + "], x=" + this.x + ", y=" + this.y + '}';
    }
}

